/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CustomizerPackaging
extends NbPropertyPanel.Single {
    private JLabel author;
    private JTextField authorValue;
    private JButton browseLicense;
    private JLabel filler;
    private JLabel homePage;
    private JTextField homePageValue;
    private JLabel jarFile;
    private JTextField jarFileValue;
    private JLabel license;
    private JTextField licenseValue;
    private JLabel nbmPkgMetadata;
    private JCheckBox needsRestart;
    private JSeparator sep1;

    CustomizerPackaging(SingleModuleProperties props, ProjectCustomizer.Category cat) {
        super(props, CustomizerPackaging.class, cat);
        this.initComponents();
        this.initAccesibility();
        this.refresh();
        if (!this.getProperties().isNetBeansOrg()) {
            this.licenseValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent e) {
                    CustomizerPackaging.this.checkValidity();
                }
            });
        } else {
            this.license.setEnabled(false);
            this.licenseValue.setEnabled(false);
            this.browseLicense.setEnabled(false);
        }
        this.checkValidity();
    }

    private void checkValidity() {
        File currentLicenceF = this.getCurrentLicenceFile();
        if (currentLicenceF != null && !currentLicenceF.isFile()) {
            this.category.setErrorMessage(NbBundle.getMessage(CustomizerPackaging.class, (String)"MSG_LicenceFileDoesNotExist"));
            this.category.setValid(false);
        } else {
            this.category.setErrorMessage(null);
            this.category.setValid(true);
        }
    }

    @Override
    protected void refresh() {
        ApisupportAntUIUtils.setText(this.jarFileValue, this.getProperties().getJarFile());
        this.needsRestart.setSelected(this.getBooleanProperty("nbm.needs.restart"));
        ApisupportAntUIUtils.setText(this.homePageValue, this.getProperty("nbm.homepage"));
        ApisupportAntUIUtils.setText(this.authorValue, this.getProperty("nbm.module.author"));
        if (!this.getProperties().isNetBeansOrg()) {
            ApisupportAntUIUtils.setText(this.licenseValue, this.getProperty("license.file"));
        }
    }

    @Override
    public void store() {
        this.setBooleanProperty("nbm.needs.restart", this.needsRestart.isSelected());
        this.setProperty("nbm.homepage", this.homePageValue.getText());
        this.setProperty("nbm.module.author", this.authorValue.getText());
        if (!this.getProperties().isNetBeansOrg()) {
            this.setProperty("license.file", this.licenseValue.getText());
        }
    }

    private String getCurrentLicence() {
        return this.licenseValue.getText().trim();
    }

    private File getCurrentLicenceFile() {
        File file = null;
        String currentLicence = this.getCurrentLicence();
        if (!currentLicence.equals("")) {
            file = this.getProperties().evaluateFile(currentLicence);
        }
        return file;
    }

    private void initComponents() {
        this.license = new JLabel();
        this.licenseValue = new JTextField();
        this.homePage = new JLabel();
        this.homePageValue = new JTextField();
        this.nbmPkgMetadata = new JLabel();
        this.author = new JLabel();
        this.authorValue = new JTextField();
        this.jarFile = new JLabel();
        this.jarFileValue = new JTextField();
        this.sep1 = new JSeparator();
        this.needsRestart = new JCheckBox();
        this.filler = new JLabel();
        this.browseLicense = new JButton();
        this.setLayout(new GridBagLayout());
        this.license.setLabelFor(this.licenseValue);
        Mnemonics.setLocalizedText((JLabel)this.license, (String)NbBundle.getMessage(CustomizerPackaging.class, (String)"LBL_License"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this.license, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.licenseValue, gridBagConstraints);
        this.homePage.setLabelFor(this.homePageValue);
        Mnemonics.setLocalizedText((JLabel)this.homePage, (String)NbBundle.getMessage(CustomizerPackaging.class, (String)"LBL_HomePage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.homePage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.homePageValue, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.nbmPkgMetadata, (String)NbBundle.getMessage(CustomizerPackaging.class, (String)"LBL_NBMPackageMetadata"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.nbmPkgMetadata, gridBagConstraints);
        this.author.setLabelFor(this.authorValue);
        Mnemonics.setLocalizedText((JLabel)this.author, (String)NbBundle.getMessage(CustomizerPackaging.class, (String)"LBL_Author"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.author, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.authorValue, gridBagConstraints);
        this.jarFile.setLabelFor(this.jarFileValue);
        Mnemonics.setLocalizedText((JLabel)this.jarFile, (String)NbBundle.getMessage(CustomizerPackaging.class, (String)"LBL_JarFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jarFile, gridBagConstraints);
        this.jarFileValue.setColumns(30);
        this.jarFileValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jarFileValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.sep1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.needsRestart, (String)NbBundle.getMessage(CustomizerPackaging.class, (String)"CTL_NeedsRestartOnInstall"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.needsRestart, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLicense, (String)NbBundle.getMessage(CustomizerPackaging.class, (String)"CTL_BrowseButton"));
        this.browseLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPackaging.this.browseLicense(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.browseLicense, gridBagConstraints);
    }

    private void browseLicense(ActionEvent evt) {
        File currentLicenceF = this.getCurrentLicenceFile();
        String startDir = currentLicenceF != null && currentLicenceF.exists() && currentLicenceF.getParent() != null ? currentLicenceF.getParent() : this.getProperties().getProjectDirectory();
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setFileSelectionMode(0);
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            File f = chooser.getSelectedFile();
            String relPath = PropertyUtils.relativizeFile((File)this.getProperties().getProjectDirectoryFile(), (File)f);
            this.licenseValue.setText(relPath != null ? relPath : f.getAbsolutePath());
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(CustomizerPackaging.class, (String)key);
    }

    private void initAccesibility() {
        this.browseLicense.getAccessibleContext().setAccessibleDescription(CustomizerPackaging.getMessage("ACSD_BrowseLicense"));
        this.needsRestart.getAccessibleContext().setAccessibleDescription(CustomizerPackaging.getMessage("ACSD_NeedsRestart"));
        this.authorValue.getAccessibleContext().setAccessibleDescription(CustomizerPackaging.getMessage("ACSD_AuthorValue"));
        this.homePageValue.getAccessibleContext().setAccessibleDescription(CustomizerPackaging.getMessage("ACSD_HomePageValue"));
        this.jarFileValue.getAccessibleContext().setAccessibleDescription(CustomizerPackaging.getMessage("ACSD_JarFileValue"));
        this.licenseValue.getAccessibleContext().setAccessibleDescription(CustomizerPackaging.getMessage("ACSD_LicenseValue"));
    }
}

