/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.debugger.ContextProvider;

public final class DebuggerEngine
implements ContextProvider {
    private Lookup privateLookup;
    private Lookup lookup;
    private ActionsManager actionsManager;
    private Session s;

    DebuggerEngine(String typeID, Session s, Object[] services, Lookup sessionLookup) {
        Object[] services1 = new Object[services.length + 1];
        System.arraycopy(services, 0, services1, 0, services.length);
        services1[services1.length - 1] = this;
        this.privateLookup = new Lookup.Compound(new Lookup.Instance(services1), new Lookup.MetaInf(typeID));
        this.lookup = new Lookup.Compound(this.privateLookup, sessionLookup);
        this.s = s;
    }

    Lookup getLookup() {
        return this.lookup;
    }

    Lookup getPrivateLookup() {
        return this.privateLookup;
    }

    @Override
    public <T> List<? extends T> lookup(String folder, Class<T> service) {
        if (service.equals(Session.class)) {
            return Collections.singletonList(this.s);
        }
        return this.lookup.lookup(folder, service);
    }

    @Override
    public <T> T lookupFirst(String folder, Class<T> service) {
        if (service.equals(Session.class)) {
            return (T)this.s;
        }
        return this.lookup.lookupFirst(folder, service);
    }

    public synchronized ActionsManager getActionsManager() {
        if (this.actionsManager == null) {
            this.actionsManager = new ActionsManager(this.lookup);
        }
        return this.actionsManager;
    }

    public class Destructor {
        public void killEngine() {
            Session[] ss = DebuggerManager.getDebuggerManager().getSessions();
            int k = ss.length;
            for (int i = 0; i < k; ++i) {
                ss[i].removeEngine(DebuggerEngine.this);
            }
            DebuggerEngine.this.getActionsManager().destroy();
        }

        public void killLanguage(Session s, String language) {
            s.removeLanguage(language, DebuggerEngine.this);
            DebuggerEngine.this.getActionsManager().destroy();
        }
    }
}

