/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.metal.MetalMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class MetalJideSplitButtonUI
extends MetalMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    private int _splitButtonMargin = 12;
    private int _splitButtonMarginOnMenu = 18;
    protected PropertyChangeListener _propertyChangeListener;
    private FocusListener _focusListener;

    protected String getPropertyPrefix() {
        return "JideSplitButton";
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalJideSplitButtonUI();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._shadowColor = UIDefaultsLookup.getColor("controlShadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
        this._highlight = UIDefaultsLookup.getColor("controlHighlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createSplitButtonPropertyChangeListener(this.menuItem);
        }
        if (this._propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this._propertyChangeListener);
        }
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    MetalJideSplitButtonUI.this.menuItem.repaint();
                }

                public void focusLost(FocusEvent e) {
                    MetalJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this._propertyChangeListener);
        }
        this._propertyChangeListener = null;
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
        this._focusListener = null;
    }

    protected PropertyChangeListener createSplitButtonPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public InputMap getInputMap(int condition, JComponent c) {
        MetalJideSplitButtonUI ui;
        if (condition == 0 && (ui = (MetalJideSplitButtonUI)MetalJideSplitButtonUI.getUIOfType(((JideSplitButton)c).getUI(), MetalJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(ui.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem b = this.menuItem;
        LazyActionMap.installLazyActionMap(b, MetalJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap km = this.getInputMap(0, b);
        SwingUtilities.replaceUIInputMap(b, 0, km);
    }

    protected void uninstallKeyboardActions() {
        JMenuItem b = this.menuItem;
        SwingUtilities.replaceUIInputMap(b, 2, null);
        SwingUtilities.replaceUIInputMap(b, 0, null);
        SwingUtilities.replaceUIActionMap(b, null);
        super.uninstallKeyboardActions();
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int menuHeight;
        int menuWidth;
        ButtonModel model = menuItem.getModel();
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        orientation = 0;
        Object o = menuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean paintBackground = o instanceof Boolean ? ((Boolean)o).booleanValue() : menuItem.isOpaque();
        JideSplitButton b = (JideSplitButton)menuItem;
        if (!((JMenu)menuItem).isTopLevelMenu()) {
            super.paintBackground(g, menuItem, bgColor);
            if (menuItem.isEnabled()) {
                if (model.isArmed() || model.isPressed() || this.isMouseOver()) {
                    g.setColor(this.selectionForeground);
                    g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g, this.selectionForeground, menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                } else {
                    g.setColor(this.getForegroundOfState(menuItem));
                    g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g, this.getForegroundOfState(menuItem), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                }
            } else {
                g.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                JideSwingUtilities.paintArrow(g, UIDefaultsLookup.getColor("controlDkShadow"), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
            }
            return;
        }
        if (paintBackground) {
            if (menuItem.getParent() != null) {
                g.setColor(menuItem.getParent().getBackground());
            } else {
                g.setColor(menuItem.getBackground());
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        if (b.getButtonStyle() == 0) {
            Object segmentPosition = b.getClientProperty("JButton.segmentPosition");
            if (model.isSelected()) {
                if (this.isAlwaysDropdown(b)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                } else if (segmentPosition != null) {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 5);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
                }
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 4);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 4);
                    }
                } else {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 5);
                    }
                }
            } else if ((b.isRolloverEnabled() && this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                if (this.isAlwaysDropdown(b)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                }
            } else if (paintBackground) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isEnabled() && b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g, rect, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                if (b.isEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g, rect, 0);
                }
            }
        } else if (b.getButtonStyle() == 2) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                if (!b.isOpaque()) {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintSunkenBorder(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    }
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b.isOpaque()) {
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    }
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g, rect);
                    }
                }
            } else if ((b.isRolloverEnabled() && this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                if (this.isAlwaysDropdown(b)) {
                    rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                } else {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (b.isOpaque()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
            }
        } else if (b.getButtonStyle() == 1) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                if (!b.isOpaque()) {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintSunken2Border(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if (this.isMouseOver() && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                    }
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b.isOpaque()) {
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                    }
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                }
            } else if (b.isRolloverEnabled() && this.isMouseOver() && model.isEnabled()) {
                if (this.isAlwaysDropdown(b)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    this.paintRaised2Border(g, rect);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g, rect);
                }
            } else if (b.isOpaque()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
            } else if (this.isAlwaysDropdown(b)) {
                Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
            } else {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
            }
        }
        menuItem.putClientProperty("JButton.segmentPosition", null);
        this.paintArrow(menuItem, g);
    }

    protected Rectangle getDropDownRect(JComponent c, int orientation, int width, int height) {
        Object position = c.getClientProperty("JButton.segmentPosition");
        Rectangle rect = c.getComponentOrientation().isLeftToRight() ? new Rectangle(width - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), height) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), height);
        if (position != null && !"only".equals(position)) {
            if ("first".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("middle".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("last".equals(position)) {
                // empty if block
            }
        }
        c.putClientProperty("JButton.segmentPosition", "last");
        return rect;
    }

    protected void paintArrow(JMenuItem menuItem, Graphics g) {
        int menuHeight;
        int menuWidth;
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        int startX = menuItem.getComponentOrientation().isLeftToRight() ? menuWidth - 9 : 4;
        if (menuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(g, this.getForegroundOfState(menuItem), startX, menuHeight / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(g, UIDefaultsLookup.getColor("controlShadow"), startX, menuHeight / 2 - 1, 5, 0);
        }
    }

    protected Rectangle getButtonRect(JComponent c, int orientation, int width, int height) {
        Rectangle rect = orientation == 0 && c.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, width - this._splitButtonMargin, height) : new Rectangle(this._splitButtonMargin - 1, 0, width - this._splitButtonMargin, height);
        c.putClientProperty("JButton.segmentPosition", "first");
        return rect;
    }

    private void paintSunkenBorder(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._shadowColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    private void paintSunken2Border(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._darkShadowColor);
        g.drawLine(b.x, b.y, b.x + b.width - 2, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 2);
        g.setColor(this._shadowColor);
        g.drawLine(b.x + 1, b.y + 1, b.x + b.width - 3, b.y + 1);
        g.drawLine(b.x + 1, b.y + 1, b.x + 1, b.y + b.height - 3);
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.x, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    private void paintRaised2Border(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._shadowColor);
        g.drawLine(b.x + 1, b.y + b.height - 2, b.x + b.width - 2, b.y + b.height - 2);
        g.drawLine(b.x + b.width - 2, 1, b.x + b.width - 2, b.y + b.height - 2);
        g.setColor(this._darkShadowColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    private void paintRaisedBorder(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._shadowColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!(model.isEnabled() && menuItem instanceof JideSplitButton && ((JideSplitButton)menuItem).isButtonEnabled())) {
            if (UIDefaultsLookup.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIDefaultsLookup.getColor("MenuItem.disabledForeground"));
                JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(menuItem.getBackground().brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(menuItem.getBackground().darker());
                JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            if (model.isArmed() || model.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getMinimumSize(c);
        }
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            if (JideSwingUtilities.getOrientationOf(c) == 0) {
                d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            } else {
                d.height = (int)((float)d.height - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            }
        }
        int size = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        d.width += size;
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getPreferredSize(c);
        }
        AbstractButton b = (AbstractButton)c;
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c) == 1) {
            isHorizontal = false;
        }
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(b, this.defaultTextIconGap);
        int size = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        d.width += size;
        if (isHorizontal) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    public Dimension getMaximumSize(JComponent c) {
        int size;
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getMaximumSize(c);
        }
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c) == 1) {
            isHorizontal = false;
        }
        int n = size = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        if (isHorizontal) {
            d.width += size;
        } else {
            d.height += size;
        }
        return d;
    }

    private Color getForegroundOfState(JMenuItem menuItem) {
        int state = JideSwingUtilities.getButtonState(menuItem);
        Color foreground = null;
        if (menuItem instanceof ComponentStateSupport) {
            foreground = ((ComponentStateSupport)((Object)menuItem)).getForegroundOfState(state);
        }
        if (foreground == null || foreground instanceof UIResource) {
            foreground = menuItem.getForeground();
        }
        return foreground;
    }

    protected void paintIcon(JMenuItem b, Graphics g) {
        ButtonModel model = b.getModel();
        if (b.getIcon() != null) {
            Icon icon;
            if (JideSwingUtilities.getOrientationOf(b) == 1) {
                g.translate(0, b.getWidth() - 1);
                ((Graphics2D)g).rotate(-1.5707963267948966);
            }
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
                if (icon == null) {
                    icon = b.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b, icon);
                }
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(b, g, MetalJideSplitButtonUI.iconRect.x, MetalJideSplitButtonUI.iconRect.y);
            }
            if (JideSwingUtilities.getOrientationOf(b) == 1) {
                ((Graphics2D)g).rotate(1.5707963267948966);
                g.translate(0, -b.getHeight() + 1);
            }
        }
    }

    protected int getOffset() {
        return 0;
    }

    protected boolean isAlwaysDropdown(JMenuItem menuItem) {
        return menuItem instanceof JideSplitButton && ((JideSplitButton)menuItem).isAlwaysDropdown();
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
        map.put(new Actions("downPressed"));
        map.put(new Actions("downReleased"));
    }

    protected static void downButtonPressed(JMenu menu) {
        MenuElement[] selectedPath;
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        if (menu.isTopLevelMenu()) {
            if (menu.isSelected()) {
                manager.clearSelectedPath();
            } else {
                Container cnt = MetalJideSplitButtonUI.getFirstParentMenuElement(menu);
                if (cnt != null && cnt instanceof MenuElement) {
                    ArrayList<Container> parents = new ArrayList<Container>();
                    while (cnt instanceof MenuElement) {
                        parents.add(0, cnt);
                        if (cnt instanceof JPopupMenu) {
                            cnt = (Container)((JPopupMenu)cnt).getInvoker();
                            continue;
                        }
                        cnt = MetalJideSplitButtonUI.getFirstParentMenuElement(cnt);
                    }
                    MenuElement[] me = new MenuElement[parents.size() + 1];
                    for (int i = 0; i < parents.size(); ++i) {
                        Container container = (Container)parents.get(i);
                        me[i] = (MenuElement)((Object)container);
                    }
                    me[parents.size()] = menu;
                    manager.setSelectedPath(me);
                } else {
                    MenuElement[] me = new MenuElement[]{menu};
                    manager.setSelectedPath(me);
                }
            }
        }
        if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
            if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                MetalJideSplitButtonUI.appendPath(selectedPath, menu.getPopupMenu());
            } else {
                MetalJideSplitButtonUI.setupPostTimer(menu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component comp) {
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MenuElement)) continue;
            return parent;
        }
        return null;
    }

    protected int getRightMargin() {
        return this._splitButtonMargin - 1;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("buttonStyle")) {
                AbstractButton b = (AbstractButton)e.getSource();
                b.repaint();
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            String key = this.getName();
            if (PRESS.equals(key) && ((JideSplitButton)b).isAlwaysDropdown()) {
                key = DOWN_PRESS;
            }
            if (PRESS.equals(key)) {
                ButtonModel model = b.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!b.hasFocus()) {
                    b.requestFocus();
                }
            } else if (RELEASE.equals(key)) {
                ButtonModel model = b.getModel();
                model.setPressed(false);
                model.setArmed(false);
            } else if (DOWN_PRESS.equals(key)) {
                MetalJideSplitButtonUI.downButtonPressed((JMenu)b);
            } else if (DOWN_RELEASE.equals(key)) {
                // empty if block
            }
        }

        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            this.cancelMenuIfNecessary(e);
        }

        public void mousePressed(MouseEvent e) {
            JMenu menu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MetalJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.isClickOnButton(e, menu)) {
                if (((JideSplitButton)MetalJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    menu.getModel().setArmed(true);
                    menu.getModel().setPressed(true);
                }
                if (!menu.hasFocus() && menu.isRequestFocusEnabled()) {
                    menu.requestFocus();
                }
            } else {
                MetalJideSplitButtonUI.downButtonPressed(menu);
            }
        }

        private boolean isClickOnButton(MouseEvent e, JMenu menu) {
            int size;
            if (((JideSplitButton)menu).isAlwaysDropdown()) {
                return false;
            }
            boolean clickOnDropDown = false;
            int n = size = ((JMenu)MetalJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? MetalJideSplitButtonUI.this._splitButtonMargin : MetalJideSplitButtonUI.this._splitButtonMarginOnMenu;
            if (JideSwingUtilities.getOrientationOf(MetalJideSplitButtonUI.this.menuItem) == 0) {
                if (e.getPoint().getX() < (double)(menu.getWidth() - size)) {
                    clickOnDropDown = true;
                }
            } else if (e.getPoint().getY() < (double)(menu.getHeight() - size)) {
                clickOnDropDown = true;
            }
            return clickOnDropDown;
        }

        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(e, menu)) {
                MetalJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                MetalJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(e);
        }

        private void cancelMenuIfNecessary(MouseEvent e) {
            JMenu menu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(e, menu) && ((JideSplitButton)MetalJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    menu.getModel().setPressed(false);
                    menu.getModel().setArmed(false);
                } else {
                    menu.getModel().setArmed(false);
                    menu.getModel().setPressed(false);
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElements = manager.getSelectedPath();
                for (int i = menuElements.length - 1; i >= 0; --i) {
                    MenuElement menuElement = menuElements[i];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(menu)) continue;
                    menu.getModel().setRollover(false);
                    MetalJideSplitButtonUI.this.setMouseOver(false);
                    manager.clearSelectedPath();
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        MetalMenuUI.appendPath(MetalJideSplitButtonUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(MetalJideSplitButtonUI.this.getPath());
                        MetalMenuUI.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                MetalJideSplitButtonUI.this.setMouseOver(true);
            }
            MetalJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent e) {
            MetalJideSplitButtonUI.this.setMouseOver(false);
            MetalJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

