/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLPermission;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.CallableParameterMetaData;
import org.mariadb.jdbc.ClientSidePreparedStatement;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.MariaDbDatabaseMetaData;
import org.mariadb.jdbc.MariaDbFunctionStatement;
import org.mariadb.jdbc.MariaDbPooledConnection;
import org.mariadb.jdbc.MariaDbProcedureStatement;
import org.mariadb.jdbc.MariaDbSavepoint;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.ServerSidePreparedStatement;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.CallableStatementCache;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.CallableStatementCacheKey;
import org.mariadb.jdbc.internal.util.dao.CloneableCallableStatement;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;
import org.mariadb.jdbc.internal.util.pool.Pools;
import org.mariadb.jdbc.util.Options;

public class MariaDbConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(MariaDbConnection.class);
    private static final Pattern CALLABLE_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\{)?\\s*((\\?\\s*=)?(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*call(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*((((`[^`]+`)|([^`\\}]+))\\.)?((`[^`]+`)|([^`\\}\\(]+)))\\s*(\\(.*\\))?(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(#.*)?)\\s*(\\}\\s*)?$", 34);
    private static final Pattern PREPARABLE_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|CALL)", 2);
    public final ReentrantLock lock;
    private final Protocol protocol;
    private final Options options;
    public MariaDbPooledConnection pooledConnection;
    protected boolean nullCatalogMeansCurrent;
    private CallableStatementCache callableStatementCache;
    private volatile int lowercaseTableNames = -1;
    private boolean canUseServerTimeout;
    private boolean sessionStateAware;
    private int stateFlag = 0;
    private int defaultTransactionIsolation = 0;
    private ExceptionFactory exceptionFactory;
    private boolean warningsCleared;

    public MariaDbConnection(Protocol protocol) {
        this.protocol = protocol;
        this.options = protocol.getOptions();
        this.canUseServerTimeout = protocol.versionGreaterOrEqual(10, 1, 2);
        this.sessionStateAware = protocol.sessionStateAware();
        this.nullCatalogMeansCurrent = this.options.nullCatalogMeansCurrent;
        if (this.options.cacheCallableStmts) {
            this.callableStatementCache = CallableStatementCache.newInstance(this.options.callableStmtCacheSize);
        }
        this.lock = protocol.getLock();
        this.exceptionFactory = ExceptionFactory.of(this.getServerThreadId(), this.options);
    }

    public static MariaDbConnection newConnection(UrlParser urlParser, GlobalStateInfo globalInfo) throws SQLException {
        if (urlParser.getOptions().pool) {
            return Pools.retrievePool(urlParser).getConnection();
        }
        Protocol protocol = Utils.retrieveProxy(urlParser, globalInfo);
        return new MariaDbConnection(protocol);
    }

    public static String quoteIdentifier(String string) {
        return "`" + string.replaceAll("`", "``") + "`";
    }

    @Deprecated
    public static String unquoteIdentifier(String string) {
        if (string != null && string.startsWith("`") && string.endsWith("`") && string.length() >= 2) {
            return string.substring(1, string.length() - 1).replace("``", "`");
        }
        return string;
    }

    protected Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkConnection();
        return new MariaDbStatement(this, 1003, 1007, this.exceptionFactory);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new MariaDbStatement(this, resultSetType, resultSetConcurrency, this.exceptionFactory);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new MariaDbStatement(this, resultSetType, resultSetConcurrency, this.exceptionFactory);
    }

    private void checkConnection() throws SQLException {
        if (this.protocol.isExplicitClosed()) {
            throw this.exceptionFactory.create("createStatement() is called on closed connection", "08000");
        }
        if (this.protocol.isClosed() && this.protocol.getProxy() != null) {
            this.lock.lock();
            try {
                this.protocol.getProxy().reconnect();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public ClientSidePreparedStatement clientPrepareStatement(String sql) throws SQLException {
        return new ClientSidePreparedStatement(this, sql, 1003, 1007, 1, this.exceptionFactory);
    }

    public ServerSidePreparedStatement serverPrepareStatement(String sql) throws SQLException {
        return new ServerSidePreparedStatement(this, sql, 1003, 1007, 1, this.exceptionFactory);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.internalPrepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.internalPrepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.internalPrepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.internalPrepareStatement(sql, 1003, 1007, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    private PreparedStatement internalPrepareStatement(String sql, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys) throws SQLException {
        if (sql != null) {
            String sqlQuery = Utils.nativeSql(sql, this.protocol);
            if (this.options.useServerPrepStmts && PREPARABLE_STATEMENT_PATTERN.matcher(sqlQuery).find()) {
                this.checkConnection();
                try {
                    return new ServerSidePreparedStatement(this, sqlQuery, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys, this.exceptionFactory);
                }
                catch (SQLNonTransientConnectionException e) {
                    throw e;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return new ClientSidePreparedStatement(this, sqlQuery, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys, this.exceptionFactory);
        }
        throw new SQLException("SQL value can not be NULL");
    }

    public CallableParameterMetaData getInternalParameterMetaData(String procedureName, String databaseName, boolean isFunction) throws SQLException {
        ClientSidePreparedStatement prep = new ClientSidePreparedStatement(this, "SELECT * from information_schema.PARAMETERS WHERE SPECIFIC_NAME = ? AND SPECIFIC_SCHEMA = " + (databaseName != null ? "?" : "DATABASE()") + " ORDER BY ORDINAL_POSITION", 1003, 1007, 2, this.exceptionFactory);
        prep.setString(1, procedureName);
        if (databaseName != null) {
            prep.setString(2, databaseName);
        }
        ResultSet rs = prep.executeQuery();
        return new CallableParameterMetaData(rs, isFunction);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        Matcher matcher = CALLABLE_STATEMENT_PATTERN.matcher(sql);
        if (!matcher.matches()) {
            throw new SQLSyntaxErrorException("invalid callable syntax. must be like {[?=]call <procedure/function name>[(?,?, ...)]}\n but was : " + sql);
        }
        String query = Utils.nativeSql(matcher.group(2), this.protocol);
        boolean isFunction = matcher.group(3) != null;
        String databaseAndProcedure = matcher.group(8);
        String database = matcher.group(10);
        String procedureName = matcher.group(13);
        String arguments = matcher.group(16);
        if (database == null && this.sessionStateAware) {
            database = this.protocol.getDatabase();
        }
        if (database != null && this.options.cacheCallableStmts) {
            CallableStatement callableStatement;
            if (this.callableStatementCache.containsKey(new CallableStatementCacheKey(database, query))) {
                try {
                    callableStatement = (CallableStatement)this.callableStatementCache.get(new CallableStatementCacheKey(database, query));
                    if (callableStatement != null) {
                        return ((CloneableCallableStatement)callableStatement).clone(this);
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            callableStatement = this.createNewCallableStatement(query, procedureName, isFunction, databaseAndProcedure, database, arguments, resultSetType, resultSetConcurrency, this.exceptionFactory);
            this.callableStatementCache.put(new CallableStatementCacheKey(database, query), callableStatement);
            return callableStatement;
        }
        return this.createNewCallableStatement(query, procedureName, isFunction, databaseAndProcedure, database, arguments, resultSetType, resultSetConcurrency, this.exceptionFactory);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql);
    }

    private CallableStatement createNewCallableStatement(String query, String procedureName, boolean isFunction, String databaseAndProcedure, String database, String arguments, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        if (isFunction) {
            return new MariaDbFunctionStatement(this, database, databaseAndProcedure, arguments == null ? "()" : arguments, resultSetType, resultSetConcurrency, exceptionFactory);
        }
        return new MariaDbProcedureStatement(query, this, procedureName, database, resultSetType, resultSetConcurrency, exceptionFactory);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return Utils.nativeSql(sql, this.protocol);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.protocol.getAutocommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit == this.getAutoCommit()) {
            return;
        }
        try (Statement stmt = this.createStatement();){
            this.stateFlag |= 8;
            stmt.executeUpdate(autoCommit ? "set autocommit=1" : "set autocommit=0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        block9: {
            this.lock.lock();
            try {
                if (!this.protocol.inTransaction()) break block9;
                try (Statement st = this.createStatement();){
                    st.execute("COMMIT");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        block9: {
            this.lock.lock();
            try {
                if (!this.protocol.inTransaction()) break block9;
                try (Statement st = this.createStatement();){
                    st.execute("ROLLBACK");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try (Statement st = this.createStatement();){
            st.execute("ROLLBACK TO SAVEPOINT `" + savepoint.getSavepointName() + "`");
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.pooledConnection != null) {
            this.rollback();
            this.pooledConnection.fireConnectionClosed();
            return;
        }
        this.protocol.closeExplicit();
    }

    @Override
    public boolean isClosed() {
        return this.protocol.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new MariaDbDatabaseMetaData(this, this.protocol.getUrlParser());
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.protocol.getReadonly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            logger.debug("conn={}({}) - set read-only to value {} {}", this.protocol.getServerThreadId(), this.protocol.isMasterConnection() ? "M" : "S", readOnly);
            this.stateFlag |= 4;
            this.protocol.setReadonly(readOnly);
        }
        catch (SQLException e) {
            throw this.exceptionFactory.create(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.protocol.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (catalog == null) {
            throw new SQLException("The catalog name may not be null", "XAE05");
        }
        try {
            this.stateFlag |= 2;
            this.protocol.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw this.exceptionFactory.create(e);
        }
    }

    public boolean isServerMariaDb() throws SQLException {
        return this.protocol.isServerMariaDb();
    }

    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        return this.protocol.versionGreaterOrEqual(major, minor, patch);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        ResultSet rs;
        Statement stmt = this.createStatement();
        String sql = "SELECT @@tx_isolation";
        if (!this.protocol.isServerMariaDb() && (this.protocol.getMajorServerVersion() >= 8 && this.protocol.versionGreaterOrEqual(8, 0, 3) || this.protocol.getMajorServerVersion() < 8 && this.protocol.versionGreaterOrEqual(5, 7, 20))) {
            sql = "SELECT @@transaction_isolation";
        }
        if ((rs = stmt.executeQuery(sql)).next()) {
            String response;
            switch (response = rs.getString(1)) {
                case "REPEATABLE-READ": {
                    return 4;
                }
                case "READ-UNCOMMITTED": {
                    return 1;
                }
                case "READ-COMMITTED": {
                    return 2;
                }
                case "SERIALIZABLE": {
                    return 8;
                }
            }
            throw this.exceptionFactory.create(String.format("Could not get transaction isolation level: Invalid value \"%s\"", response));
        }
        throw this.exceptionFactory.create("Failed to retrieve transaction isolation");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.stateFlag |= 0x10;
            this.protocol.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw this.exceptionFactory.create(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.warningsCleared || this.isClosed() || !this.protocol.hasWarnings()) {
            return null;
        }
        SQLWarning last = null;
        SQLWarning first = null;
        try (Statement st = this.createStatement();
             ResultSet rs = st.executeQuery("show warnings");){
            while (rs.next()) {
                int code = rs.getInt(2);
                String message = rs.getString(3);
                SQLWarning warning = new SQLWarning(message, null, code);
                if (first == null) {
                    first = warning;
                    last = warning;
                    continue;
                }
                last.setNextWarning(warning);
                last = warning;
            }
        }
        return first;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw this.exceptionFactory.create("Connection.clearWarnings cannot be called on a closed connection");
        }
        this.warningsCleared = true;
    }

    public void reenableWarnings() {
        this.warningsCleared = false;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw this.exceptionFactory.notSupported("TypeMap are not supported");
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        String randomName = UUID.randomUUID().toString();
        return this.setSavepoint(randomName);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        MariaDbSavepoint savepoint = new MariaDbSavepoint(name);
        try (Statement st = this.createStatement();){
            st.execute("SAVEPOINT `" + savepoint.getSavepointName() + "`");
        }
        return savepoint;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try (Statement st = this.createStatement();){
            st.execute("RELEASE SAVEPOINT `" + savepoint.getSavepointName() + "`");
        }
    }

    @Override
    public Clob createClob() {
        return new MariaDbClob();
    }

    @Override
    public Blob createBlob() {
        return new MariaDbBlob();
    }

    @Override
    public NClob createNClob() {
        return new MariaDbClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.exceptionFactory.notSupported("SQLXML type is not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("the value supplied for timeout is negative");
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.protocol.isValid(timeout * 1000);
        }
        catch (SQLException e) {
            if (this.pooledConnection != null) {
                MariaDbPooledConnection poolConnection = this.pooledConnection;
                poolConnection.fireConnectionErrorOccurred(e);
                poolConnection.close();
            }
            return false;
        }
    }

    private void checkClientClose(String name) throws SQLClientInfoException {
        if (this.protocol.isExplicitClosed()) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException("setClientInfo() is called on closed connection", failures);
        }
    }

    private void checkClientReconnect(String name) throws SQLClientInfoException {
        if (this.protocol.isClosed() && this.protocol.getProxy() != null) {
            this.lock.lock();
            try {
                this.protocol.getProxy().reconnect();
            }
            catch (SQLException sqle) {
                HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException("Connection closed", failures, (Throwable)sqle);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void checkClientValidProperty(String name) throws SQLClientInfoException {
        if (name == null || !"ApplicationName".equals(name) && !"ClientUser".equals(name) && !"ClientHostname".equals(name)) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException("setClientInfo() parameters can only be \"ApplicationName\",\"ClientUser\" or \"ClientHostname\", but was : " + name, failures);
        }
    }

    private String buildClientQuery(String name, String value) {
        StringBuilder escapeQuery = new StringBuilder("SET @").append(name).append("=");
        if (value == null) {
            escapeQuery.append("null");
        } else {
            int charsOffset;
            escapeQuery.append("'");
            int charsLength = value.length();
            if (this.protocol.noBackslashEscapes()) {
                for (charsOffset = 0; charsOffset < charsLength; ++charsOffset) {
                    char charValue = value.charAt(charsOffset);
                    if (charValue == '\'') {
                        escapeQuery.append('\'');
                    }
                    escapeQuery.append(charValue);
                }
            } else {
                while (charsOffset < charsLength) {
                    char charValue = value.charAt(charsOffset);
                    if (charValue == '\'' || charValue == '\\' || charValue == '\"' || charValue == '\u0000') {
                        escapeQuery.append('\\');
                    }
                    escapeQuery.append(charValue);
                    ++charsOffset;
                }
            }
            escapeQuery.append("'");
        }
        return escapeQuery.toString();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.checkClientClose(name);
        this.checkClientReconnect(name);
        this.checkClientValidProperty(name);
        try {
            Statement statement = this.createStatement();
            statement.execute(this.buildClientQuery(name, value));
        }
        catch (SQLException sqle) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException("unexpected error during setClientInfo", failures, (Throwable)sqle);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkConnection();
        Properties properties = new Properties();
        try (Statement statement = this.createStatement();
             ResultSet rs = statement.executeQuery("SELECT @ApplicationName, @ClientUser, @ClientHostname");){
            if (rs.next()) {
                if (rs.getString(1) != null) {
                    properties.setProperty("ApplicationName", rs.getString(1));
                }
                if (rs.getString(2) != null) {
                    properties.setProperty("ClientUser", rs.getString(2));
                }
                if (rs.getString(3) != null) {
                    properties.setProperty("ClientHostname", rs.getString(3));
                }
                Properties properties2 = properties;
                return properties2;
            }
        }
        properties.setProperty("ApplicationName", null);
        properties.setProperty("ClientUser", null);
        properties.setProperty("ClientHostname", null);
        return properties;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> propertiesExceptions = new HashMap<String, ClientInfoStatus>();
        for (String name : new String[]{"ApplicationName", "ClientUser", "ClientHostname"}) {
            try {
                this.setClientInfo(name, properties.getProperty(name));
            }
            catch (SQLClientInfoException e) {
                propertiesExceptions.putAll(e.getFailedProperties());
            }
        }
        if (!propertiesExceptions.isEmpty()) {
            String errorMsg = "setClientInfo errors : the following properties where not set : " + propertiesExceptions.keySet();
            throw new SQLClientInfoException(errorMsg, propertiesExceptions);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkConnection();
        if (!("ApplicationName".equals(name) || "ClientUser".equals(name) || "ClientHostname".equals(name))) {
            throw new SQLException("name must be \"ApplicationName\", \"ClientUser\" or \"ClientHostname\", but was \"" + name + "\"");
        }
        try (Statement statement = this.createStatement();
             ResultSet rs = statement.executeQuery("SELECT @" + name);){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw this.exceptionFactory.notSupported("Array type is not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw this.exceptionFactory.notSupported("Struct type is not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Deprecated
    public String getUsername() {
        return this.protocol.getUsername();
    }

    @Deprecated
    public String getHostname() {
        return this.protocol.getHost();
    }

    @Deprecated
    public int getPort() {
        return this.protocol.getPort();
    }

    protected boolean getPinGlobalTxToPhysicalConnection() {
        return this.protocol.getPinGlobalTxToPhysicalConnection();
    }

    public void setHostFailed() {
        if (this.protocol.getProxy() == null) {
            this.protocol.setHostFailedWithoutProxy();
        }
    }

    public int getLowercaseTableNames() throws SQLException {
        if (this.lowercaseTableNames == -1) {
            try (Statement st = this.createStatement();
                 ResultSet rs = st.executeQuery("select @@lower_case_table_names");){
                rs.next();
                this.lowercaseTableNames = rs.getInt(1);
            }
        }
        return this.lowercaseTableNames;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        SQLPermission sqlPermission = new SQLPermission("callAbort");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(sqlPermission);
        }
        if (executor == null) {
            throw this.exceptionFactory.create("Cannot abort the connection: null executor passed");
        }
        executor.execute(this.protocol::abort);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.protocol.getTimeout();
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public void setSchema(String arg0) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.isClosed()) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called on a closed connection");
        }
        if (milliseconds < 0) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called with a negative timeout");
        }
        SQLPermission sqlPermission = new SQLPermission("setNetworkTimeout");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(sqlPermission);
        }
        try {
            this.stateFlag |= 1;
            this.protocol.setTimeout(milliseconds);
        }
        catch (SocketException se) {
            throw this.exceptionFactory.create("Cannot set the network timeout", se);
        }
    }

    public long getServerThreadId() {
        return this.protocol.getServerThreadId();
    }

    public boolean canUseServerTimeout() {
        return this.canUseServerTimeout;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void reset() throws SQLException {
        boolean useComReset;
        boolean bl = useComReset = this.options.useResetConnection && this.protocol.isServerMariaDb() && (this.protocol.versionGreaterOrEqual(10, 3, 13) || this.protocol.getMajorServerVersion() == 10 && this.protocol.getMinorServerVersion() == 2 && this.protocol.versionGreaterOrEqual(10, 2, 22));
        if (useComReset) {
            this.protocol.reset();
        }
        if (this.stateFlag != 0) {
            try {
                if ((this.stateFlag & 1) != 0) {
                    this.setNetworkTimeout(null, this.options.socketTimeout);
                }
                if ((this.stateFlag & 8) != 0) {
                    this.setAutoCommit(this.options.autocommit);
                }
                if ((this.stateFlag & 2) != 0) {
                    this.protocol.resetDatabase();
                }
                if ((this.stateFlag & 4) != 0) {
                    this.setReadOnly(false);
                }
                if (!useComReset && (this.stateFlag & 0x10) != 0) {
                    this.setTransactionIsolation(this.defaultTransactionIsolation);
                }
                this.stateFlag = 0;
            }
            catch (SQLException sqle) {
                throw this.exceptionFactory.create("error resetting connection");
            }
        }
        this.warningsCleared = true;
    }

    public boolean includeDeadLockInfo() {
        return this.options.includeInnodbStatusInDeadlockExceptions;
    }

    public boolean includeThreadsTraces() {
        return this.options.includeThreadDumpInDeadlockExceptions;
    }
}

