/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.utility;

import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.seg.common.Term;
import java.util.LinkedList;
import java.util.List;

public class SentencesUtil {
    public static List<String> toSentenceList(String content) {
        return SentencesUtil.toSentenceList(content.toCharArray(), true);
    }

    public static List<String> toSentenceList(String content, boolean shortest) {
        return SentencesUtil.toSentenceList(content.toCharArray(), shortest);
    }

    public static List<String> toSentenceList(char[] chars) {
        return SentencesUtil.toSentenceList(chars, true);
    }

    public static List<String> toSentenceList(char[] chars, boolean shortest) {
        StringBuilder sb = new StringBuilder();
        LinkedList<String> sentences = new LinkedList<String>();
        block6: for (int i = 0; i < chars.length; ++i) {
            if (sb.length() == 0 && (Character.isWhitespace(chars[i]) || chars[i] == ' ')) continue;
            sb.append(chars[i]);
            switch (chars[i]) {
                case '.': {
                    if (i >= chars.length - 1 || chars[i + 1] <= '\u0080') continue block6;
                    SentencesUtil.insertIntoList(sb, sentences);
                    sb = new StringBuilder();
                    continue block6;
                }
                case '\u2026': {
                    if (i >= chars.length - 1 || chars[i + 1] != '\u2026') continue block6;
                    sb.append('\u2026');
                    ++i;
                    SentencesUtil.insertIntoList(sb, sentences);
                    sb = new StringBuilder();
                    continue block6;
                }
                case ',': 
                case ';': 
                case '\uff0c': 
                case '\uff1b': {
                    if (!shortest) continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '?': 
                case '\u00a0': 
                case '\u3002': 
                case '\uff01': 
                case '\uff1f': {
                    SentencesUtil.insertIntoList(sb, sentences);
                    sb = new StringBuilder();
                }
            }
        }
        if (sb.length() > 0) {
            SentencesUtil.insertIntoList(sb, sentences);
        }
        return sentences;
    }

    private static void insertIntoList(StringBuilder sb, List<String> sentences) {
        String content = sb.toString().trim();
        if (content.length() > 0) {
            sentences.add(content);
        }
    }

    public static boolean hasNature(List<Term> sentence, Nature nature) {
        for (Term term : sentence) {
            if (term.nature != nature) continue;
            return true;
        }
        return false;
    }
}

