/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.MDAG;

import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;

public class MDAGNode {
    private boolean isAcceptNode;
    private final TreeMap<Character, MDAGNode> outgoingTransitionTreeMap;
    private int incomingTransitionCount = 0;
    private int transitionSetBeginIndex = -1;
    private Integer storedHashCode = null;

    public MDAGNode(boolean isAcceptNode) {
        this.isAcceptNode = isAcceptNode;
        this.outgoingTransitionTreeMap = new TreeMap();
    }

    private MDAGNode(MDAGNode node) {
        this.isAcceptNode = node.isAcceptNode;
        this.outgoingTransitionTreeMap = new TreeMap<Character, MDAGNode>((SortedMap<Character, MDAGNode>)node.outgoingTransitionTreeMap);
        for (Map.Entry<Character, MDAGNode> transitionKeyValuePair : this.outgoingTransitionTreeMap.entrySet()) {
            ++transitionKeyValuePair.getValue().incomingTransitionCount;
        }
    }

    public MDAGNode clone() {
        return new MDAGNode(this);
    }

    public MDAGNode clone(MDAGNode soleParentNode, char parentToCloneTransitionLabelChar) {
        MDAGNode cloneNode = new MDAGNode(this);
        soleParentNode.reassignOutgoingTransition(parentToCloneTransitionLabelChar, this, cloneNode);
        return cloneNode;
    }

    public int getTransitionSetBeginIndex() {
        return this.transitionSetBeginIndex;
    }

    public int getOutgoingTransitionCount() {
        return this.outgoingTransitionTreeMap.size();
    }

    public int getIncomingTransitionCount() {
        return this.incomingTransitionCount;
    }

    public boolean isConfluenceNode() {
        return this.incomingTransitionCount > 1;
    }

    public boolean isAcceptNode() {
        return this.isAcceptNode;
    }

    public void setAcceptStateStatus(boolean isAcceptNode) {
        this.isAcceptNode = isAcceptNode;
    }

    public void setTransitionSetBeginIndex(int transitionSetBeginIndex) {
        this.transitionSetBeginIndex = transitionSetBeginIndex;
    }

    public boolean hasOutgoingTransition(char letter) {
        return this.outgoingTransitionTreeMap.containsKey(Character.valueOf(letter));
    }

    public boolean hasTransitions() {
        return !this.outgoingTransitionTreeMap.isEmpty();
    }

    public MDAGNode transition(char letter) {
        return this.outgoingTransitionTreeMap.get(Character.valueOf(letter));
    }

    public MDAGNode transition(String str) {
        int charCount = str.length();
        MDAGNode currentNode = this;
        for (int i = 0; i < charCount && (currentNode = currentNode.transition(str.charAt(i))) != null; ++i) {
        }
        return currentNode;
    }

    public MDAGNode transition(char[] str) {
        int charCount = str.length;
        MDAGNode currentNode = this;
        for (int i = 0; i < charCount && (currentNode = currentNode.transition(str[i])) != null; ++i) {
        }
        return currentNode;
    }

    public MDAGNode transition(char[] str, int offset) {
        int charCount = str.length - offset;
        MDAGNode currentNode = this;
        for (int i = 0; i < charCount && (currentNode = currentNode.transition(str[i + offset])) != null; ++i) {
        }
        return currentNode;
    }

    public Stack<MDAGNode> getTransitionPathNodes(String str) {
        Stack<MDAGNode> nodeStack = new Stack<MDAGNode>();
        MDAGNode currentNode = this;
        int numberOfChars = str.length();
        for (int i = 0; i < numberOfChars && currentNode != null; currentNode = currentNode.transition(str.charAt(i)), ++i) {
            nodeStack.add(currentNode);
        }
        return nodeStack;
    }

    public TreeMap<Character, MDAGNode> getOutgoingTransitions() {
        return this.outgoingTransitionTreeMap;
    }

    public void decrementTargetIncomingTransitionCounts() {
        for (Map.Entry<Character, MDAGNode> transitionKeyValuePair : this.outgoingTransitionTreeMap.entrySet()) {
            --transitionKeyValuePair.getValue().incomingTransitionCount;
        }
    }

    public void reassignOutgoingTransition(char letter, MDAGNode oldTargetNode, MDAGNode newTargetNode) {
        --oldTargetNode.incomingTransitionCount;
        ++newTargetNode.incomingTransitionCount;
        this.outgoingTransitionTreeMap.put(Character.valueOf(letter), newTargetNode);
    }

    public MDAGNode addOutgoingTransition(char letter, boolean targetAcceptStateStatus) {
        MDAGNode newTargetNode = new MDAGNode(targetAcceptStateStatus);
        ++newTargetNode.incomingTransitionCount;
        this.outgoingTransitionTreeMap.put(Character.valueOf(letter), newTargetNode);
        return newTargetNode;
    }

    public MDAGNode addOutgoingTransition(char letter, MDAGNode newTargetNode) {
        ++newTargetNode.incomingTransitionCount;
        this.outgoingTransitionTreeMap.put(Character.valueOf(letter), newTargetNode);
        return newTargetNode;
    }

    public void removeOutgoingTransition(char letter) {
        this.outgoingTransitionTreeMap.remove(Character.valueOf(letter));
    }

    public static boolean haveSameTransitions(MDAGNode node1, MDAGNode node2) {
        TreeMap<Character, MDAGNode> outgoingTransitionTreeMap1 = node1.outgoingTransitionTreeMap;
        TreeMap<Character, MDAGNode> outgoingTransitionTreeMap2 = node2.outgoingTransitionTreeMap;
        if (outgoingTransitionTreeMap1.size() == outgoingTransitionTreeMap2.size()) {
            for (Map.Entry<Character, MDAGNode> transitionKeyValuePair : outgoingTransitionTreeMap1.entrySet()) {
                Character currentCharKey = transitionKeyValuePair.getKey();
                MDAGNode currentTargetNode = transitionKeyValuePair.getValue();
                if (outgoingTransitionTreeMap2.containsKey(currentCharKey) && outgoingTransitionTreeMap2.get(currentCharKey).equals(currentTargetNode)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void clearStoredHashCode() {
        this.storedHashCode = null;
    }

    public boolean equals(Object obj) {
        boolean areEqual;
        boolean bl = areEqual = this == obj;
        if (!areEqual && obj != null && obj.getClass().equals(MDAGNode.class)) {
            MDAGNode node = (MDAGNode)obj;
            areEqual = this.isAcceptNode == node.isAcceptNode && MDAGNode.haveSameTransitions(this, node);
        }
        return areEqual;
    }

    public int hashCode() {
        if (this.storedHashCode == null) {
            int hash = 7;
            hash = 53 * hash + (this.isAcceptNode ? 1 : 0);
            hash = 53 * hash + (this.outgoingTransitionTreeMap != null ? this.outgoingTransitionTreeMap.hashCode() : 0);
            this.storedHashCode = hash;
            return hash;
        }
        return this.storedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MDAGNode{");
        sb.append("isAcceptNode=").append(this.isAcceptNode);
        sb.append(", outgoingTransitionTreeMap=").append(this.outgoingTransitionTreeMap.keySet());
        sb.append(", incomingTransitionCount=").append(this.incomingTransitionCount);
        sb.append('}');
        return sb.toString();
    }
}

