/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

public class DatabasePingLogEntry
extends DatabaseLogEntry {
    private final Calendar date;
    private final Long client;
    private final Long user;

    public DatabasePingLogEntry(Long client, Long user) {
        this.client = client;
        this.user = user;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put("day", ServerTools.getSQLDateString(this.date));
        parameters.put("created_at", ServerTools.getSQLDatetimeString(this.date));
        parameters.put("client", this.client);
        parameters.put("user_id", this.user);
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.pings";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabasePingLogEntry that = (DatabasePingLogEntry)o;
        return Objects.equals(this.client, that.client) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.client, this.user);
    }
}

