/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;

@ApiStatus.Internal
public abstract class RuleSet {
    public abstract List<Rule> allRules();

    public abstract List<Rule> rulesForSentence(AnalyzedSentence var1);

    public static RuleSet plain(List<Rule> rules) {
        final List<Rule> allRules = Collections.unmodifiableList(rules);
        return new RuleSet(){

            @Override
            public List<Rule> allRules() {
                return allRules;
            }

            @Override
            public List<Rule> rulesForSentence(AnalyzedSentence sentence) {
                return allRules;
            }
        };
    }

    public static RuleSet textLemmaHinted(List<? extends Rule> rules) {
        return RuleSet.hinted(rules, true);
    }

    public static RuleSet textHinted(List<? extends Rule> rules) {
        return RuleSet.hinted(rules, false);
    }

    private static RuleSet hinted(List<? extends Rule> rules, boolean withLemmaHints) {
        final List<? extends Rule> allRules = Collections.unmodifiableList(rules);
        final HashMap<String, BitSet> byToken = new HashMap<String, BitSet>();
        final HashMap<String, BitSet> byLemma = new HashMap<String, BitSet>();
        final BitSet unclassified = new BitSet();
        for (int i = 0; i < allRules.size(); ++i) {
            Rule rule = allRules.get(i);
            if (rule instanceof AbstractTokenBasedRule) {
                String[][] formHints;
                String[] inflectedRuleTokens = new String[]{};
                if (withLemmaHints && (inflectedRuleTokens = ((AbstractTokenBasedRule)rule).inflectedRuleTokens) != null) {
                    byLemma.computeIfAbsent(inflectedRuleTokens[0], __ -> new BitSet()).set(i);
                }
                if ((formHints = ((AbstractTokenBasedRule)rule).formHints) != null) {
                    for (String token : formHints[0]) {
                        byToken.computeIfAbsent(token, __ -> new BitSet()).set(i);
                    }
                    continue;
                }
                if (inflectedRuleTokens != null && withLemmaHints) continue;
                unclassified.set(i);
                continue;
            }
            unclassified.set(i);
        }
        return new RuleSet(){

            @Override
            public List<Rule> allRules() {
                return allRules;
            }

            @Override
            public List<Rule> rulesForSentence(AnalyzedSentence sentence) {
                BitSet set;
                BitSet included = new BitSet();
                included.or(unclassified);
                if (!byLemma.isEmpty()) {
                    for (String lemma : sentence.getLemmaSet()) {
                        set = (BitSet)byLemma.get(lemma);
                        if (set == null) continue;
                        included.or(set);
                    }
                }
                for (String token : sentence.getTokenSet()) {
                    set = (BitSet)byToken.get(token);
                    if (set == null) continue;
                    included.or(set);
                }
                return 2.filterList(included, allRules);
            }
        };
    }

    @ApiStatus.Internal
    public static <T> List<T> filterList(BitSet includedIndices, List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        int i = -1;
        while ((i = includedIndices.nextSetBit(i + 1)) >= 0) {
            result.add(list.get(i));
        }
        return result;
    }
}

