/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.junit.Assert;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.Demo;
import org.languagetool.rules.Rule;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;

public final class TestTools {
    private static final Language DEMO_LANGUAGE = new Demo();

    private TestTools() {
    }

    public static Language getDemoLanguage() {
        return DEMO_LANGUAGE;
    }

    public static Set<Language> getLanguagesExcept(String[] langCodes) {
        HashSet<Language> languages = new HashSet<Language>();
        languages.addAll(Languages.getWithDemoLanguage());
        if (langCodes != null) {
            for (String langCode : langCodes) {
                Language lang = Languages.getLanguageForShortCode((String)langCode);
                languages.remove(lang);
            }
        }
        return languages;
    }

    public static ResourceBundle getEnglishMessages() {
        return TestTools.getMessages("en");
    }

    public static ResourceBundle getMessages(String languageCode) {
        if (languageCode.length() > 3) {
            throw new RuntimeException("Use a character code (ISO-639 code), not a full language name: " + languageCode);
        }
        ResourceBundle messages = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", new Locale(languageCode));
        return messages;
    }

    public static void testSplit(String[] sentences, SentenceTokenizer sTokenizer) {
        StringBuilder inputString = new StringBuilder();
        ArrayList input = new ArrayList();
        Collections.addAll(input, sentences);
        for (String s : input) {
            inputString.append(s);
        }
        Assert.assertEquals(input, (Object)sTokenizer.tokenize(inputString.toString()));
    }

    public static void myAssert(String input, String expected, Tokenizer tokenizer, Tagger tagger) throws IOException {
        List tokens = tokenizer.tokenize(input);
        List<String> noWhitespaceTokens = TestTools.getNoWhitespaceTokens(tokens);
        List output = tagger.tag(noWhitespaceTokens);
        StringBuilder outputStr = new StringBuilder();
        Iterator iter = output.iterator();
        while (iter.hasNext()) {
            AnalyzedTokenReadings tokenReadings = (AnalyzedTokenReadings)iter.next();
            List<String> readings = TestTools.getAsStrings(tokenReadings);
            outputStr.append(String.join((CharSequence)"|", readings));
            if (!iter.hasNext()) continue;
            outputStr.append(" -- ");
        }
        Assert.assertEquals((Object)expected, (Object)outputStr.toString());
    }

    public static void myAssert(String input, String expected, Tokenizer tokenizer, SentenceTokenizer sentenceTokenizer, Tagger tagger, Disambiguator disambiguator) throws IOException {
        StringBuilder outputStr = new StringBuilder();
        List sentences = sentenceTokenizer.tokenize(input);
        for (String sentence : sentences) {
            AnalyzedToken sentenceStartToken;
            List tokens = tokenizer.tokenize(sentence);
            List<String> noWhitespaceTokens = TestTools.getNoWhitespaceTokens(tokens);
            List aTokens = tagger.tag(noWhitespaceTokens);
            AnalyzedTokenReadings[] tokenArray = new AnalyzedTokenReadings[tokens.size() + 1];
            AnalyzedToken[] startTokenArray = new AnalyzedToken[1];
            int toArrayCount = 0;
            startTokenArray[0] = sentenceStartToken = new AnalyzedToken("", "SENT_START", null);
            tokenArray[toArrayCount++] = new AnalyzedTokenReadings(startTokenArray, 0);
            int startPos = 0;
            int noWhitespaceCount = 0;
            for (String tokenStr : tokens) {
                AnalyzedTokenReadings posTag;
                if (TestTools.isWord(tokenStr)) {
                    posTag = (AnalyzedTokenReadings)aTokens.get(noWhitespaceCount);
                    posTag.setStartPos(startPos);
                    ++noWhitespaceCount;
                } else {
                    posTag = tagger.createNullToken(tokenStr, startPos);
                }
                tokenArray[toArrayCount++] = posTag;
                startPos += tokenStr.length();
            }
            AnalyzedSentence finalSentence = new AnalyzedSentence(tokenArray);
            finalSentence = disambiguator.disambiguate(finalSentence);
            AnalyzedTokenReadings[] output = finalSentence.getTokens();
            for (int i = 0; i < output.length; ++i) {
                AnalyzedTokenReadings tokenReadings = output[i];
                List<String> readings = TestTools.getAsStrings(tokenReadings);
                outputStr.append(String.join((CharSequence)"|", readings));
                if (i >= output.length - 1) continue;
                outputStr.append(' ');
            }
        }
        Assert.assertEquals((Object)expected, (Object)outputStr.toString());
    }

    public static boolean isWord(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            return true;
        }
        return false;
    }

    public static void testDictionary(BaseTagger tagger, Language language) throws IOException {
        Dictionary dictionary = Dictionary.read((URL)JLanguageTool.getDataBroker().getFromResourceDirAsUrl(tagger.getDictionaryPath()));
        DictionaryLookup lookup = new DictionaryLookup(dictionary);
        for (WordData wordData : lookup) {
            if (wordData.getTag() != null && wordData.getTag().length() != 0) continue;
            System.err.println("**** Warning: " + language + ": the word " + wordData.getWord() + "/" + wordData.getStem() + " lacks a POS tag in the dictionary.");
        }
    }

    private static List<String> getAsStrings(AnalyzedTokenReadings tokenReadings) {
        ArrayList<String> readings = new ArrayList<String>();
        for (AnalyzedToken analyzedToken : tokenReadings) {
            readings.add(TestTools.getAsString(analyzedToken));
        }
        Collections.sort(readings);
        return readings;
    }

    private static String getAsString(AnalyzedToken analyzedToken) {
        return analyzedToken.getToken() + "/[" + analyzedToken.getLemma() + ']' + analyzedToken.getPOSTag();
    }

    private static List<String> getNoWhitespaceTokens(List<String> tokens) {
        ArrayList<String> noWhitespaceTokens = new ArrayList<String>();
        for (String token : tokens) {
            if (!TestTools.isWord(token)) continue;
            noWhitespaceTokens.add(token);
        }
        return noWhitespaceTokens;
    }

    public static void disableAllRulesExcept(JLanguageTool lt, String ruleIdToActivate) {
        for (Rule rule : lt.getAllRules()) {
            lt.disableRule(rule.getId());
        }
        lt.enableRule(ruleIdToActivate);
    }
}

