/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.NgramLanguageModel;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.io.IOUtils;
import edu.berkeley.nlp.lm.io.LmReaders;
import edu.berkeley.nlp.lm.util.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class ComputeLogProbabilityOfTextStream {
    private static void usage() {
        System.err.println("Usage: <Berkeley LM binary file> <outputfile>*\nor\n-g <vocab_cs file> <Google LM Binary>");
        System.exit(1);
    }

    public static void main(String[] argv) throws FileNotFoundException, IOException {
        int i = 0;
        if (i >= argv.length) {
            ComputeLogProbabilityOfTextStream.usage();
        }
        boolean isGoogleBinary = false;
        if (argv[i].equals("-g")) {
            isGoogleBinary = true;
            ++i;
        }
        if (i >= argv.length) {
            ComputeLogProbabilityOfTextStream.usage();
        }
        String vocabFile = null;
        if (isGoogleBinary) {
            vocabFile = argv[i++];
        }
        if (i >= argv.length) {
            ComputeLogProbabilityOfTextStream.usage();
        }
        String binaryFile = argv[i++];
        List<String> files = Arrays.asList(Arrays.copyOfRange(argv, i, argv.length));
        if (files.isEmpty()) {
            files = Collections.singletonList("-");
        }
        Logger.setGlobalLogger(new Logger.SystemLogger(System.err, System.err));
        NgramLanguageModel<String> lm = ComputeLogProbabilityOfTextStream.readBinary(isGoogleBinary, vocabFile, binaryFile);
        double prob = ComputeLogProbabilityOfTextStream.computeProb(files, lm);
        System.err.print("Log probability of text is: ");
        System.out.println(prob);
    }

    private static double computeProb(List<String> files, NgramLanguageModel<String> lm) throws IOException, FileNotFoundException {
        double logProb = 0.0;
        for (String file : files) {
            Logger.startTrack("Scoring file " + file + "; current log probability is " + logProb, new Object[0]);
            InputStream is = file.equals("-") ? System.in : (file.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file));
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
            for (String line : Iterators.able(IOUtils.lineIterator(reader))) {
                List<String> words = Arrays.asList(line.trim().split("\\s+"));
                logProb += (double)lm.getLogProb(words);
            }
            Logger.endTrack();
        }
        return logProb;
    }

    private static NgramLanguageModel<String> readBinary(boolean isGoogleBinary, String vocabFile, String binaryFile) {
        NgramLanguageModel<String> lm = null;
        if (isGoogleBinary) {
            Logger.startTrack("Reading Google Binary " + binaryFile + " with vocab " + vocabFile, new Object[0]);
            lm = LmReaders.readGoogleLmBinary(binaryFile, vocabFile);
            Logger.endTrack();
        } else {
            Logger.startTrack("Reading LM Binary " + binaryFile, new Object[0]);
            lm = LmReaders.readLmBinary(binaryFile);
            Logger.endTrack();
        }
        return lm;
    }
}

