/*
 * Decompiled with CFR 0.152.
 */
package org.ictclas4j.segment;

import java.util.ArrayList;
import org.ictclas4j.bean.ContextStat;
import org.ictclas4j.bean.POS;
import org.ictclas4j.bean.SegNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegGraph {
    private boolean isRowFirst;
    private ArrayList<SegNode> snList;

    public SegGraph() {
    }

    public SegGraph(ArrayList<SegNode> snList) {
        this.snList = snList;
    }

    public SegNode getElement(int row, int col) {
        SegNode result = new SegNode();
        result.setValue(10000.0);
        int index = 0;
        if (this.snList != null) {
            SegNode sg;
            int i;
            if (this.isRowFirst) {
                i = 0;
                while (i < this.snList.size()) {
                    SegNode sg2 = this.snList.get(i);
                    if (row != -1 && sg2.getRow() < row || col != -1 && sg2.getRow() == row && sg2.getCol() < col) {
                        ++i;
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                i = 0;
                while (i < this.snList.size()) {
                    SegNode sg3 = this.snList.get(i);
                    if (col != -1 && sg3.getCol() < col || row != -1 && sg3.getCol() == col && sg3.getRow() < row) {
                        ++i;
                        ++index;
                        continue;
                    }
                    break;
                }
            }
            if (!(index >= this.snList.size() || (sg = this.snList.get(index)).getRow() != row && row != -1 || sg.getCol() != col && col != -1)) {
                result = sg;
            }
        }
        return result;
    }

    public boolean setElement(SegNode sg) {
        if (sg != null) {
            if (this.snList == null) {
                this.snList = new ArrayList();
            }
            int i = 0;
            SegNode sgTemp = null;
            if (this.isRowFirst) {
                for (i = 0; i < this.snList.size() && ((sgTemp = this.snList.get(i)).getRow() < sg.getRow() || sgTemp.getRow() == sg.getRow() && sgTemp.getCol() < sg.getCol()); ++i) {
                }
            } else {
                for (i = 0; i < this.snList.size() && ((sgTemp = this.snList.get(i)).getCol() < sg.getCol() || sgTemp.getCol() == sg.getCol() && sgTemp.getRow() < sg.getRow()); ++i) {
                }
            }
            if (sgTemp != null && sgTemp.getRow() == sg.getRow() && sgTemp.getCol() == sg.getCol()) {
                sgTemp = sg;
            } else if (i > 0) {
                this.snList.add(i - 1, sg);
            }
        }
        return false;
    }

    public ArrayList<SegNode> getNodes(int curIndex, boolean isColFirst) {
        ArrayList<SegNode> result = null;
        if (this.snList != null && this.snList.size() > 0 && curIndex >= 0) {
            result = new ArrayList<SegNode>();
            for (int i = 0; i < this.snList.size(); ++i) {
                SegNode sg = this.snList.get(i);
                if (isColFirst) {
                    if (sg.getCol() != curIndex) continue;
                    result.add(sg);
                    continue;
                }
                if (sg.getRow() != curIndex) continue;
                result.add(sg);
            }
        }
        return result;
    }

    public boolean insert(SegNode graph, boolean isRowFirst) {
        SegNode sg = null;
        if (this.snList == null) {
            this.snList = new ArrayList();
        }
        if (graph != null) {
            if (this.snList.size() == 0) {
                this.snList.add(graph);
                return true;
            }
            for (int i = 0; i < this.snList.size(); ++i) {
                sg = this.snList.get(i);
                if (isRowFirst) {
                    if (i == this.snList.size() - 1) {
                        if (graph.getRow() > sg.getRow() || graph.getRow() == sg.getRow() && graph.getCol() > sg.getCol()) {
                            this.snList.add(graph);
                        } else if (graph.getCol() == sg.getCol()) {
                            this.snList.set(i, graph);
                        } else {
                            this.snList.add(i, graph);
                        }
                        return true;
                    }
                    if (graph.getRow() > sg.getRow() || graph.getRow() == sg.getRow() && graph.getCol() > sg.getCol()) continue;
                    if (graph.getRow() == sg.getRow() && graph.getCol() == sg.getCol()) {
                        this.snList.set(i, graph);
                    } else {
                        this.snList.add(i, graph);
                    }
                    return true;
                }
                if (i == this.snList.size() - 1) {
                    if (graph.getCol() > sg.getCol() || graph.getCol() == sg.getCol() && graph.getRow() > sg.getRow()) {
                        this.snList.add(graph);
                    } else if (graph.getRow() == sg.getRow() && graph.getCol() == sg.getCol()) {
                        this.snList.set(i, graph);
                    } else {
                        this.snList.add(i, graph);
                    }
                    return true;
                }
                if (graph.getCol() > sg.getCol() || graph.getCol() == sg.getCol() && graph.getRow() > sg.getRow()) continue;
                if (graph.getRow() == sg.getRow()) {
                    this.snList.set(i, graph);
                } else {
                    this.snList.add(i, graph);
                }
                return true;
            }
        }
        return false;
    }

    public SegNode delete(int row, int col) {
        SegNode result = null;
        if (this.snList != null && this.snList.size() > 0) {
            for (SegNode sn : this.snList) {
                if (sn.getRow() != row || sn.getCol() != col) continue;
                this.snList.remove(sn);
                return sn;
            }
        }
        return result;
    }

    public ArrayList<SegNode> getNextElements(int curIndex) {
        ArrayList<SegNode> result = null;
        if (this.snList != null && this.snList.size() > 0 && curIndex >= 0 && curIndex < this.snList.size()) {
            result = new ArrayList<SegNode>();
            SegNode curSg = this.snList.get(curIndex);
            for (int i = curIndex + 1; i < this.snList.size(); ++i) {
                SegNode sg = this.snList.get(i);
                if (sg.getRow() != curSg.getCol()) continue;
                result.add(sg);
            }
        }
        return result;
    }

    public boolean isRowFirst() {
        return this.isRowFirst;
    }

    public void setRowFirst(boolean isRowFirst) {
        this.isRowFirst = isRowFirst;
    }

    public ArrayList<SegNode> getSnList() {
        return this.snList;
    }

    public void setSnList(ArrayList<SegNode> sgs) {
        this.snList = sgs;
    }

    public int getSize() {
        if (this.snList != null) {
            return this.snList.size();
        }
        return -1;
    }

    public int getMaxRow() {
        int result = -1;
        if (this.snList != null && this.snList.size() > 0) {
            int size = this.snList.size();
            SegNode sn = this.snList.get(size - 1);
            result = sn.getRow();
        }
        return result;
    }

    public int getMaxCol() {
        int result = -1;
        if (this.snList != null && this.snList.size() > 0) {
            int size = this.snList.size();
            SegNode sn = this.snList.get(size - 1);
            result = sn.getCol();
        }
        return result;
    }

    public void getBestPrev(ContextStat context) {
        if (this.snList != null) {
            SegNode sn = null;
            ArrayList<POS> posList = null;
            for (int i = 1; i < this.snList.size(); ++i) {
                sn = this.snList.get(i);
                posList = sn.getAllPos();
                for (int j = 0; posList != null && j < posList.size(); ++j) {
                    double minFee = 1000000.0;
                    int minPrev = 100000;
                    POS pos = posList.get(j);
                    SegNode psn = this.snList.get(i - 1);
                    ArrayList<POS> pposList = psn.getAllPos();
                    for (int k = 0; pposList != null && k < pposList.size(); ++k) {
                        double temp = -Math.log(context.getPossibility(0, pposList.get(k).getTag(), pos.getTag()));
                        if (!((temp += pposList.get(k).getFreq()) < minFee)) continue;
                        minFee = temp;
                        minPrev = k;
                    }
                    pos.setPrev(minPrev);
                    pos.setFreq(pos.getFreq() + minFee);
                }
            }
        }
    }

    public SegNode getLast() {
        if (this.snList != null && this.snList.size() > 0) {
            return this.snList.get(this.snList.size() - 1);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NextElementIndex {
        ArrayList<ArrayList<SegNode>> _index = new ArrayList();

        public ArrayList<SegNode> getNextElements(int curIndex) {
            if (SegGraph.this.snList != null && SegGraph.this.snList.size() > 0 && curIndex >= 0 && curIndex < SegGraph.this.snList.size()) {
                SegNode curSg = (SegNode)SegGraph.this.snList.get(curIndex);
                int row = curSg.getCol();
                if (row >= 0 && row < this._index.size()) {
                    return this._index.get(row);
                }
                return new ArrayList<SegNode>();
            }
            return null;
        }

        private void allocate_index_space() {
            if (SegGraph.this.snList == null) {
                return;
            }
            int nMaxRow = -1;
            int nLen = SegGraph.this.snList.size();
            for (int i = 0; i < nLen; ++i) {
                SegNode sg = (SegNode)SegGraph.this.snList.get(i);
                int row = sg.getRow();
                if (row <= nMaxRow) continue;
                nMaxRow = row;
            }
            for (int j = 0; j <= nMaxRow; ++j) {
                this._index.add(new ArrayList());
            }
        }

        public NextElementIndex() {
            if (SegGraph.this.snList == null) {
                return;
            }
            this.allocate_index_space();
            int nLen = SegGraph.this.snList.size();
            for (int i = 0; i < nLen; ++i) {
                SegNode sg = (SegNode)SegGraph.this.snList.get(i);
                int row = sg.getRow();
                ArrayList<SegNode> next_eles = this._index.get(row);
                next_eles.add(sg);
            }
        }
    }
}

