/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.mapcss.CSSColors;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetListEntry;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class Combo
extends ComboMultiSelect {
    public boolean editable = true;
    public short length;
    protected JosmComboBox<PresetListEntry> combobox;

    public Combo() {
        this.delimiter = (char)44;
    }

    @Override
    protected void addToPanelAnchor(JPanel p, String def, boolean presetInitiallyMatches) {
        AutoCompletionList acList;
        if (!this.usage.unused()) {
            for (String s : this.usage.values) {
                this.presetListEntries.add(new PresetListEntry(s));
            }
        }
        if (def != null) {
            this.presetListEntries.add(new PresetListEntry(def));
        }
        this.presetListEntries.add(new PresetListEntry(""));
        this.component = this.combobox = new JosmComboBox<PresetListEntry>(this.presetListEntries.toArray(new PresetListEntry[0]));
        this.combobox.setRenderer(this.getListCellRenderer());
        this.combobox.setEditable(true);
        this.combobox.reinitialize(this.presetListEntries);
        this.combobox.setEditable(this.editable);
        AutoCompletingTextField tf = new AutoCompletingTextField();
        this.initAutoCompletionField(tf, this.key);
        if (Config.getPref().getBoolean("taggingpreset.display-keys-as-hint", true)) {
            tf.setHint(this.key);
        }
        if (this.length > 0) {
            tf.setMaxChars(Integer.valueOf(this.length));
        }
        if ((acList = tf.getAutoCompletionList()) != null) {
            acList.add(this.getDisplayValues(), AutoCompletionPriority.IS_IN_STANDARD);
        }
        this.combobox.setEditor(tf);
        this.combobox.setSelectedItem(this.getItemToSelect(def, presetInitiallyMatches));
        if (this.key != null && ("colour".equals(this.key) || this.key.startsWith("colour:") || this.key.endsWith(":colour"))) {
            p.add(this.combobox, GBC.std().fill(2));
            JButton button = new JButton(new ChooseColorAction());
            button.setOpaque(true);
            button.setBorderPainted(false);
            button.setCursor(Cursor.getPredefinedCursor(12));
            p.add((Component)button, GBC.eol().fill(3));
            ActionListener updateColor = ignore -> button.setBackground(this.getColor());
            updateColor.actionPerformed(null);
            this.combobox.addActionListener(updateColor);
        } else {
            p.add(this.combobox, GBC.eol().fill(2));
        }
    }

    protected void setColor(Color color) {
        if (color != null) {
            this.combobox.setSelectedItem(ColorHelper.color2html(color));
        }
    }

    protected Color getColor() {
        String colorString = String.valueOf(this.getSelectedValue());
        return colorString.startsWith("#") ? ColorHelper.html2color(colorString) : CSSColors.get(colorString);
    }

    @Override
    protected Object getSelectedItem() {
        return this.combobox.getSelectedItem();
    }

    @Override
    protected String getDisplayIfNull() {
        if (this.combobox.isEditable()) {
            return this.combobox.getEditor().getItem().toString();
        }
        return null;
    }

    class ChooseColorAction
    extends AbstractAction {
        ChooseColorAction() {
            this.putValue("ShortDescription", I18n.tr("Choose a color", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = Combo.this.getColor();
            color = JColorChooser.showDialog(MainApplication.getMainPanel(), I18n.tr("Choose a color", new Object[0]), color);
            Combo.this.setColor(color);
        }
    }
}

