/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs3.auxiliary.remote.server.RegistryKeepAliveRunner;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceAdmin;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.OptionConverter;
import org.apache.commons.jcs3.utils.config.PropertySetter;
import org.apache.commons.jcs3.utils.threadpool.DaemonThreadFactory;

public class RemoteCacheServerFactory
implements IRemoteCacheConstants {
    private static final Log log = LogManager.getLog(RemoteCacheServerFactory.class);
    private static RemoteCacheServer<?, ?> remoteCacheServer;
    private static String serviceName;
    private static ScheduledExecutorService keepAliveDaemon;
    private static Registry registry;

    private RemoteCacheServerFactory() {
    }

    public static <K, V> RemoteCacheServer<K, V> getRemoteCacheServer() {
        return remoteCacheServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String host, int port, Properties props) throws IOException {
        if (remoteCacheServer != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (host == null) {
                host = "";
            }
            RemoteCacheServerAttributes rcsa = RemoteCacheServerFactory.configureRemoteCacheServerAttributes(props);
            rcsa.setRemoteLocation(host, port);
            log.info("Creating server with these attributes: {0}", rcsa);
            RemoteCacheServerFactory.setServiceName(rcsa.getRemoteServiceName());
            RMISocketFactory customRMISocketFactory = RemoteCacheServerFactory.configureObjectSpecificCustomFactory(props);
            RemoteUtils.configureGlobalCustomSocketFactory(rcsa.getRmiSocketFactoryTimeoutMillis());
            ICacheEventLogger cacheEventLogger = RemoteCacheServerFactory.configureCacheEventLogger(props);
            remoteCacheServer = customRMISocketFactory != null ? new RemoteCacheServer(rcsa, props, customRMISocketFactory) : new RemoteCacheServer(rcsa, props);
            remoteCacheServer.setCacheEventLogger(cacheEventLogger);
            registry = RemoteUtils.createRegistry(port);
            RemoteCacheServerFactory.registerServer(serviceName, remoteCacheServer);
            if (rcsa.isUseRegistryKeepAlive()) {
                if (keepAliveDaemon == null) {
                    keepAliveDaemon = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("JCS-RemoteCacheServerFactory-"));
                }
                RegistryKeepAliveRunner runner = new RegistryKeepAliveRunner(host, port, serviceName);
                runner.setCacheEventLogger(cacheEventLogger);
                keepAliveDaemon.scheduleAtFixedRate(runner, 0L, rcsa.getRegistryKeepAliveDelayMillis(), TimeUnit.MILLISECONDS);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected static ICacheEventLogger configureCacheEventLogger(Properties props) {
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotecache");
        if (cacheEventLogger == null) {
            cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "remote");
        }
        return cacheEventLogger;
    }

    protected static RMISocketFactory configureObjectSpecificCustomFactory(Properties props) {
        RMISocketFactory customRMISocketFactory = OptionConverter.instantiateByKey(props, "jcs.remotecache.customrmisocketfactory", null);
        if (customRMISocketFactory != null) {
            PropertySetter.setProperties(customRMISocketFactory, props, "jcs.remotecache.customrmisocketfactory.");
            log.info("Will use server specific custom socket factory. {0}", customRMISocketFactory);
        } else {
            log.info("No server specific custom socket factory defined.");
        }
        return customRMISocketFactory;
    }

    protected static void registerServer(String serviceName, Remote server) throws RemoteException {
        if (server == null) {
            throw new RemoteException("Cannot register the server until it is created.");
        }
        if (registry == null) {
            throw new RemoteException("Cannot register the server: Registry is null.");
        }
        log.info("Binding server to {0}", serviceName);
        registry.rebind(serviceName, server);
    }

    protected static RemoteCacheServerAttributes configureRemoteCacheServerAttributes(Properties prop) {
        RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotecache.serverattributes.");
        RemoteCacheServerFactory.configureManuallyIfValuesArePresent(prop, rcsa);
        return rcsa;
    }

    private static void configureManuallyIfValuesArePresent(Properties prop, RemoteCacheServerAttributes rcsa) {
        String acgStr;
        String lccStr;
        String socketTimeoutMillisStr;
        String servicePortStr = prop.getProperty("remote.cache.service.port");
        if (servicePortStr != null) {
            try {
                int servicePort = Integer.parseInt(servicePortStr);
                rcsa.setServicePort(servicePort);
                log.debug("Remote cache service uses port number {0}", servicePort);
            }
            catch (NumberFormatException ignore) {
                log.debug("Remote cache service port property {0} not specified. An anonymous port will be used.", "remote.cache.service.port");
            }
        }
        if ((socketTimeoutMillisStr = prop.getProperty("remote.cache.rmiSocketFactoryTimeoutMillis")) != null) {
            try {
                int rmiSocketFactoryTimeoutMillis = Integer.parseInt(socketTimeoutMillisStr);
                rcsa.setRmiSocketFactoryTimeoutMillis(rmiSocketFactoryTimeoutMillis);
                log.debug("Remote cache socket timeout {0} ms.", rmiSocketFactoryTimeoutMillis);
            }
            catch (NumberFormatException ignore) {
                log.debug("Remote cache socket timeout property {0} not specified. The default will be used.", "remote.cache.rmiSocketFactoryTimeoutMillis");
            }
        }
        if ((lccStr = prop.getProperty("remote.cluster.LocalClusterConsistency")) != null) {
            boolean lcc = Boolean.parseBoolean(lccStr);
            rcsa.setLocalClusterConsistency(lcc);
        }
        if ((acgStr = prop.getProperty("remote.cluster.AllowClusterGet")) != null) {
            boolean acg = Boolean.parseBoolean(lccStr);
            rcsa.setAllowClusterGet(acg);
        }
        rcsa.setRemoteServiceName(prop.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownImpl(String host, int port) throws IOException {
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            log.info("Unbinding host={0}, port={1}, serviceName={2}", host, port, RemoteCacheServerFactory.getServiceName());
            try {
                Naming.unbind(RemoteUtils.getNamingURL(host, port, RemoteCacheServerFactory.getServiceName()));
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port + ", serviceName=" + RemoteCacheServerFactory.getServiceName());
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
            remoteCacheServer.release();
            remoteCacheServer = null;
            if (keepAliveDaemon != null) {
                keepAliveDaemon.shutdownNow();
                keepAliveDaemon = null;
            }
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
                registry = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        String host;
        ICacheServiceAdmin admin;
        int port;
        Properties prop = args.length > 0 ? RemoteUtils.loadProps(args[args.length - 1]) : new Properties();
        try {
            port = Integer.parseInt(prop.getProperty("registry.port"));
        }
        catch (NumberFormatException ex) {
            port = 1099;
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-shutdown") != -1) {
            try {
                admin = RemoteCacheServerFactory.lookupCacheServiceAdmin(prop, port);
                admin.shutdown();
            }
            catch (Exception ex) {
                log.error("Problem calling shutdown.", ex);
            }
            log.debug("done.");
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-stats") != -1) {
            log.debug("getting cache stats");
            try {
                admin = RemoteCacheServerFactory.lookupCacheServiceAdmin(prop, port);
                try {
                    log.debug(admin.getStats());
                }
                catch (IOException es) {
                    log.error(es);
                }
            }
            catch (Exception ex) {
                log.error("Problem getting stats.", ex);
            }
            log.debug("done.");
            System.exit(0);
        }
        if ((host = prop.getProperty("registry.host")) == null || host.trim().equals("") || host.trim().equals("localhost")) {
            log.debug("main> creating registry on the localhost");
            RemoteUtils.createRegistry(port);
        }
        log.debug("main> starting up RemoteCacheServer");
        RemoteCacheServerFactory.startup(host, port, prop);
        log.debug("main> done");
    }

    private static ICacheServiceAdmin lookupCacheServiceAdmin(Properties config, int port) throws Exception {
        String remoteServiceName = config.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim();
        String registry = RemoteUtils.getNamingURL("", port, remoteServiceName);
        log.debug("looking up server {0}", registry);
        Remote obj = Naming.lookup(registry);
        log.debug("server found");
        return (ICacheServiceAdmin)((Object)obj);
    }

    protected static void setServiceName(String serviceName) {
        RemoteCacheServerFactory.serviceName = serviceName;
    }

    protected static String getServiceName() {
        return serviceName;
    }

    static {
        serviceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
        registry = null;
    }
}

