/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.I18n;
import ch.poole.openinghoursparser.Util;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RuleModifier
extends Element {
    Modifier modifier = null;
    String comment = null;

    public RuleModifier() {
    }

    public RuleModifier(@NotNull RuleModifier rm) {
        this.modifier = rm.modifier;
        this.comment = rm.comment;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.modifier != null) {
            b.append((Object)this.modifier);
        }
        if (this.comment != null) {
            if (this.modifier != null) {
                b.append(" ");
            }
            b.append("\"" + this.comment + "\"");
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RuleModifier) {
            RuleModifier o = (RuleModifier)other;
            return Util.equals((Object)this.modifier, (Object)o.modifier) && Util.equals(this.comment, o.comment);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.modifier == null ? 0 : this.modifier.hashCode());
        result = 37 * result + (this.comment == null ? 0 : this.comment.hashCode());
        return result;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public String getComment() {
        return this.comment;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = Modifier.getValue(modifier);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public RuleModifier copy() {
        return new RuleModifier(this);
    }

    public static enum Modifier {
        OPEN("open"),
        CLOSED("closed"),
        OFF("off"),
        UNKNOWN("unknown");

        private final String name;

        private Modifier(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Modifier getValue(String modifier) {
            for (Modifier m : Modifier.values()) {
                if (!m.toString().equals(modifier)) continue;
                return m;
            }
            throw new IllegalArgumentException(I18n.tr("invalid_modifier", modifier));
        }

        public static List<String> nameValues() {
            ArrayList<String> result = new ArrayList<String>();
            for (Modifier m : Modifier.values()) {
                result.add(m.toString());
            }
            return result;
        }
    }
}

