/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public abstract class AbstractAuxiliaryCacheMonitor
extends Thread {
    protected final Log log = LogManager.getLog(this.getClass());
    protected static long idlePeriod = 20000L;
    protected AtomicBoolean allright = new AtomicBoolean(true);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition trigger = this.lock.newCondition();

    public AbstractAuxiliaryCacheMonitor(String name) {
        super(name);
    }

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > AbstractAuxiliaryCacheMonitor.idlePeriod) {
            AbstractAuxiliaryCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    public void notifyError() {
        if (this.allright.compareAndSet(true, false)) {
            this.signalTrigger();
        }
    }

    public void notifyShutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.signalTrigger();
        }
    }

    private void signalTrigger() {
        try {
            this.lock.lock();
            this.trigger.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void dispose();

    protected abstract void doWork();

    @Override
    public void run() {
        while (true) {
            if (this.allright.get()) {
                this.log.debug("ERROR DRIVEN MODE: allright = true, cache monitor will wait for an error.");
            } else {
                this.log.debug("ERROR DRIVEN MODE: allright = false cache monitor running.");
            }
            if (this.allright.get()) {
                try {
                    this.lock.lock();
                    this.trigger.await();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.shutdown.get()) {
                this.log.info("Shutting down cache monitor");
                this.dispose();
                return;
            }
            this.allright.set(true);
            this.log.debug("Cache monitor running.");
            this.doWork();
            try {
                this.log.debug("Cache monitor sleeping for {0} between runs.", idlePeriod);
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

