/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class MultipleNameVisitor
extends NameVisitor {
    public static final IntegerProperty MULTIPLE_NAME_MAX_LENGTH = new IntegerProperty("multiple.name.max.length", 140);
    private static final String MULTI_CLASS_NAME = "object";
    private static final Icon MULTI_CLASS_ICON = ImageProvider.get("data", "object");
    private String displayName;

    public void visit(Collection<? extends OsmPrimitive> data) {
        StringBuilder multipleName = new StringBuilder();
        String multiplePluralClassname = null;
        int size = data.size();
        String multipleClassname = null;
        for (OsmPrimitive osmPrimitive : data) {
            String name = osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance());
            if (!Utils.isEmpty(name) && multipleName.length() <= MULTIPLE_NAME_MAX_LENGTH.get()) {
                if (multipleName.length() > 0) {
                    multipleName.append(", ");
                }
                multipleName.append(name);
            }
            osmPrimitive.accept(this);
            if (multipleClassname == null) {
                multipleClassname = this.className;
                multiplePluralClassname = this.classNamePlural;
                continue;
            }
            if (multipleClassname.equals(this.className)) continue;
            multipleClassname = MULTI_CLASS_NAME;
            multiplePluralClassname = I18n.trn(MULTI_CLASS_NAME, "objects", 2L, new Object[0]);
        }
        if (size <= 1) {
            this.displayName = this.name;
        } else {
            if (MULTI_CLASS_NAME.equals(multipleClassname)) {
                this.icon = MULTI_CLASS_ICON;
            }
            StringBuilder sb = new StringBuilder().append(size).append(' ').append(I18n.trn(multipleClassname, multiplePluralClassname, size, new Object[0]));
            if (multipleName.length() > 0) {
                sb.append(": ");
                if (multipleName.length() <= MULTIPLE_NAME_MAX_LENGTH.get()) {
                    sb.append((CharSequence)multipleName);
                } else {
                    sb.append(multipleName.substring(0, MULTIPLE_NAME_MAX_LENGTH.get())).append("...");
                }
            }
            this.displayName = sb.toString();
        }
    }

    @Override
    public JLabel toLabel() {
        return new JLabel(this.getText(), this.getIcon(), 0);
    }

    public String getText() {
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        return this.getText();
    }
}

