/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.street_level;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;

public interface IImageEntry<I extends IImageEntry<I>> {
    default public void selectNextImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getNextImage());
    }

    public I getNextImage();

    default public void selectPreviousImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getPreviousImage());
    }

    public I getPreviousImage();

    default public void selectFirstImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getFirstImage());
    }

    public I getFirstImage();

    default public void selectLastImage(ImageViewerDialog imageViewerDialog) {
        this.selectImage(imageViewerDialog, (IImageEntry<?>)this.getLastImage());
    }

    default public void selectImage(ImageViewerDialog imageViewerDialog, IImageEntry<?> entry) {
        imageViewerDialog.displayImage(entry);
    }

    public I getLastImage();

    default public boolean remove() {
        throw new UnsupportedOperationException("remove is not supported for " + this.getClass().getSimpleName());
    }

    default public boolean isRemoveSupported() {
        return false;
    }

    default public boolean delete() {
        throw new UnsupportedOperationException("remove is not supported for " + this.getClass().getSimpleName());
    }

    default public boolean isDeleteSupported() {
        return false;
    }

    public String getDisplayName();

    public BufferedImage read(Dimension var1) throws IOException;

    public void setWidth(int var1);

    public void setHeight(int var1);

    public File getFile();

    default public URI getImageURI() {
        return this.getFile().toURI();
    }

    public ILatLon getPos();

    public Double getSpeed();

    public Double getElevation();

    public Double getExifImgDir();

    public boolean hasExifTime();

    public Instant getExifInstant();

    public boolean hasGpsTime();

    public Instant getGpsInstant();

    public String getIptcCaption();

    public String getIptcHeadline();

    public List<String> getIptcKeywords();

    public String getIptcObjectName();

    default public Projections getProjectionType() {
        return Projections.PERSPECTIVE;
    }
}

