/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class OsmTileSource {

    public static class TransportMap
    extends AbstractOsmTileSource {
        public TransportMap() {
            super("Public Transport", "https://tile.memomaps.de/tilegen", "public_transport_oepnv");
        }

        @Override
        public int getMaxZoom() {
            return 18;
        }

        @Override
        public String getAttributionText(int zoom, ICoordinate topLeft, ICoordinate botRight) {
            return "\u00a9 OpenStreetMap contributors, CC-BY-SA";
        }

        @Override
        public String getAttributionLinkURL() {
            return "https://\u00f6pnvkarte.de/<";
        }
    }

    public static abstract class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "https://%s.tile.thunderforest.com/cycle";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int serverNum;

        public CycleMap() {
            super("OpenCycleMap", PATTERN, "opencyclemap");
        }

        @Override
        public String getBaseUrl() {
            String url = String.format(this.baseUrl, SERVER[this.serverNum]);
            this.serverNum = (this.serverNum + 1) % SERVER.length;
            return url;
        }

        protected abstract String getApiKey();

        @Override
        public int getMaxZoom() {
            return 18;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) throws IOException {
            return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley) + "?apikey=" + this.getApiKey();
        }

        @Override
        public String getTermsOfUseText() {
            return "Maps \u00a9 Thunderforest";
        }

        @Override
        public String getTermsOfUseURL() {
            return "https://thunderforest.com/terms/";
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        private static final String PATTERN = "https://%s.tile.openstreetmap.org";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int serverNum;

        public Mapnik() {
            super("OpenStreetMap Carto", PATTERN, "standard");
            this.modTileFeatures = true;
        }

        @Override
        public String getBaseUrl() {
            String url = String.format(this.baseUrl, SERVER[this.serverNum]);
            this.serverNum = (this.serverNum + 1) % SERVER.length;
            return url;
        }
    }
}

