/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.search;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class SearchSetting {
    public String text;
    public SearchMode mode;
    public boolean caseSensitive;
    public boolean regexSearch;
    public boolean mapCSSSearch;
    public boolean allElements;

    public SearchSetting() {
        this.text = "";
        this.mode = SearchMode.replace;
    }

    public SearchSetting(SearchSetting original) {
        this.text = original.text;
        this.mode = original.mode;
        this.caseSensitive = original.caseSensitive;
        this.regexSearch = original.regexSearch;
        this.mapCSSSearch = original.mapCSSSearch;
        this.allElements = original.allElements;
    }

    public String toString() {
        return Utils.shortenString(this.text, 100);
    }

    public String toStringEx() {
        String cs = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
        String rx = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
        String css = this.mapCSSSearch ? ", " + I18n.trc("search", "CSS") : "";
        String all = this.allElements ? ", " + I18n.trc("search", "A") : "";
        return '\"' + this.text + "\" (" + cs + rx + css + all + ", " + (Object)((Object)this.mode) + ')';
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SearchSetting that = (SearchSetting)other;
        return this.caseSensitive == that.caseSensitive && this.regexSearch == that.regexSearch && this.mapCSSSearch == that.mapCSSSearch && this.allElements == that.allElements && this.mode == that.mode && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.mode, this.caseSensitive, this.regexSearch, this.mapCSSSearch, this.allElements});
    }

    public static SearchSetting readFromString(String s) {
        if (s.isEmpty()) {
            return null;
        }
        SearchSetting result = new SearchSetting();
        int index = 1;
        result.mode = SearchMode.fromCode(s.charAt(0));
        if (result.mode == null) {
            result.mode = SearchMode.replace;
            index = 0;
        }
        while (index < s.length()) {
            if (s.charAt(index) == 'C') {
                result.caseSensitive = true;
            } else if (s.charAt(index) == 'R') {
                result.regexSearch = true;
            } else if (s.charAt(index) == 'A') {
                result.allElements = true;
            } else if (s.charAt(index) == 'M') {
                result.mapCSSSearch = true;
            } else {
                if (s.charAt(index) == ' ') break;
                Logging.warn("Unknown char in SearchSettings: " + s);
                break;
            }
            ++index;
        }
        if (index < s.length() && s.charAt(index) == ' ') {
            ++index;
        }
        result.text = s.substring(index);
        return result;
    }

    public static SearchSetting fromString(String s) {
        if (s.isEmpty()) {
            return null;
        }
        SearchSetting result = new SearchSetting();
        result.text = s;
        return result;
    }

    public String writeToString() {
        if (this.text == null || this.text.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.mode.getCode());
        if (this.caseSensitive) {
            result.append('C');
        }
        if (this.regexSearch) {
            result.append('R');
        }
        if (this.mapCSSSearch) {
            result.append('M');
        }
        if (this.allElements) {
            result.append('A');
        }
        result.append(' ').append(this.text);
        return result.toString();
    }
}

