//  DateLineAppDelegate.h
//  DateLine
//
//  Created by Alex Clarke on 6/05/05.
//  Copyright CocoaLab 2005 . All rights reserved.

#import <Cocoa/Cocoa.h>
#import "CLTimelineWindow.h"
#import "CLHorizontalMonthView.h"

@class CLBoundView;

@interface DateLineAppDelegate : NSObject 
{
	IBOutlet NSArrayController * graphicsController;
	IBOutlet NSArrayController * monthController;
	IBOutlet CLTimelineWindow *window;
	IBOutlet CLHorizontalMonthView * daysView;
	IBOutlet CLBoundView * monthNameView;
	IBOutlet NSButton * closeButton;
	IBOutlet NSPopUpButton * windowLevelPopup;
	
	id month;
	
	NSAppleScript * iCalDateScript;
	NSAppleScript * iCalMonthScript;
	NSTimer * updateTimer;

	NSArray * dateDescriptorsArray;
    
	NSManagedObjectModel *managedObjectModel;
	NSManagedObjectContext *managedObjectContext;
}

+ (void) initialiseValueTransformers;
+(void) registerDefaults;
+(void) initializeColorPanel;

- (id)month;
- (void)setMonth:(id)aMonth;
- (NSArray *)days;

- (void) resetDays:(id)sender;

- (void) setUpBindings;
- (void) initialiseSortDescriptors;
- (void) refreshDateElements:(id)sender;

- (NSManagedObjectModel *)managedObjectModel;
- (NSManagedObjectContext *)managedObjectContext;

- (IBAction) saveAction:sender;
- (IBAction) setElementColor:(id)sender;
- (IBAction) setTextColor:(id)sender;
- (IBAction) setLineColor:(id)sender;
- (IBAction) setTodayTextColor:(id)sender;
- (IBAction) setTodayMarkColor:(id)sender;
- (IBAction) setDayMarkColor:(id)sender;

- (IBAction) setDateLineWindowLevel:(id)sender;

- (int)tagForLevel:(int) level;

@end

@interface DateLineAppDelegate (Licensing) 

- (void) launchCheck;
- (IBAction) showLicensingWindow:(id)sender;
- (BOOL) verifyLicense;

@end
