/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitorToResolvedFileVisitorAdapter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedFileVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scopes.BuildSession.class})
public class ArtifactSetToFileCollectionFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskDependencyFactory taskDependencyFactory;

    public ArtifactSetToFileCollectionFactory(TaskDependencyFactory taskDependencyFactory, BuildOperationExecutor buildOperationExecutor) {
        this.taskDependencyFactory = taskDependencyFactory;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public ResolutionHost resolutionHost(String displayName) {
        return new NameBackedResolutionHost(displayName);
    }

    public ResolutionBackedFileCollection asFileCollection(String displayName, boolean lenient, List<?> elements) {
        return new ResolutionBackedFileCollection(new PartialSelectedArtifactProvider(elements), lenient, new NameBackedResolutionHost(displayName), this.taskDependencyFactory);
    }

    public ResolvedArtifactSet asResolvedArtifactSet(Throwable failure) {
        return new BrokenResolvedArtifactSet(failure);
    }

    public ResolvedArtifactSet asResolvedArtifactSet(final ComponentArtifactIdentifier id, final AttributeContainer variantAttributes, final ImmutableCapabilities capabilities, final DisplayName variantDisplayName, final File file) {
        return new ResolvedArtifactSet(){

            @Override
            public void visit(ResolvedArtifactSet.Visitor visitor) {
                visitor.visitArtifacts(new ResolvedArtifactSet.Artifacts(){

                    @Override
                    public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
                    }

                    @Override
                    public void visit(ArtifactVisitor visitor) {
                        if (visitor.prepareForVisit(FileCollectionInternal.OTHER) == FileCollectionStructureVisitor.VisitType.Visit) {
                            visitor.visitArtifact(variantDisplayName, variantAttributes, capabilities, new ResolvableArtifact(){

                                @Override
                                public ComponentArtifactIdentifier getId() {
                                    return id;
                                }

                                @Override
                                public boolean isResolveSynchronously() {
                                    return true;
                                }

                                @Override
                                public IvyArtifactName getArtifactName() {
                                    return DefaultIvyArtifactName.forFile(file, null);
                                }

                                @Override
                                public File getFile() {
                                    return file;
                                }

                                @Override
                                public CalculatedValue<File> getFileSource() {
                                    throw new UnsupportedOperationException();
                                }

                                @Override
                                public ResolvableArtifact transformedTo(File file) {
                                    throw new UnsupportedOperationException();
                                }

                                @Override
                                public ResolvedArtifact toPublicView() {
                                    throw new UnsupportedOperationException();
                                }

                                public void visitDependencies(TaskDependencyResolveContext context) {
                                }
                            });
                            visitor.endVisitCollection(FileCollectionInternal.OTHER);
                        }
                    }
                });
            }

            @Override
            public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
                throw new UnsupportedOperationException();
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<ResolvedArtifactResult> asResolvedArtifacts(ResolvedArtifactSet artifacts, boolean lenient) {
        ResolvedArtifactCollectingVisitor collectingVisitor = new ResolvedArtifactCollectingVisitor();
        ParallelResolveArtifactSet.wrap(artifacts, this.buildOperationExecutor).visit(collectingVisitor);
        if (!lenient && !collectingVisitor.getFailures().isEmpty()) {
            throw UncheckedException.throwAsUncheckedException((Throwable)collectingVisitor.getFailures().iterator().next());
        }
        return collectingVisitor.getArtifacts();
    }

    private class PartialSelectedArtifactProvider
    implements ResolutionResultProvider<SelectedArtifactSet> {
        private final List<?> elements;

        public PartialSelectedArtifactProvider(List<?> elements) {
            this.elements = elements;
        }

        @Override
        public SelectedArtifactSet getTaskDependencyValue() {
            return this.getValue();
        }

        @Override
        public SelectedArtifactSet getValue() {
            return new PartialSelectedArtifactSet(this.elements, ArtifactSetToFileCollectionFactory.this.buildOperationExecutor);
        }
    }

    private static class PartialSelectedArtifactSet
    implements SelectedArtifactSet {
        private final List<?> elements;
        private final BuildOperationExecutor buildOperationExecutor;

        public PartialSelectedArtifactSet(List<?> elements, BuildOperationExecutor buildOperationExecutor) {
            this.elements = elements;
            this.buildOperationExecutor = buildOperationExecutor;
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
            ArrayList<ResolvedArtifactSet> artifactSets = new ArrayList<ResolvedArtifactSet>();
            for (Object element : this.elements) {
                if (element instanceof ResolvedArtifactSet) {
                    artifactSets.add((ResolvedArtifactSet)element);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            ParallelResolveArtifactSet.wrap(CompositeResolvedArtifactSet.of(artifactSets), this.buildOperationExecutor).visit(visitor);
        }

        @Override
        public void visitFiles(ResolvedFileVisitor visitor, boolean continueOnSelectionFailure) {
            ArrayList<ResolvedArtifactSet> artifactSets = new ArrayList<ResolvedArtifactSet>();
            for (Object element : this.elements) {
                if (element instanceof ResolvedArtifactSet) {
                    artifactSets.add((ResolvedArtifactSet)element);
                    continue;
                }
                File file = (File)element;
                artifactSets.add(new FileBackedArtifactSet(file));
            }
            ParallelResolveArtifactSet.wrap(CompositeResolvedArtifactSet.of(artifactSets), this.buildOperationExecutor).visit(new ArtifactVisitorToResolvedFileVisitorAdapter(visitor));
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
        }
    }

    private static class FileBackedArtifactSet
    implements ResolvedArtifactSet {
        private final File file;

        public FileBackedArtifactSet(File file) {
            this.file = file;
        }

        @Override
        public void visit(ResolvedArtifactSet.Visitor visitor) {
            visitor.visitArtifacts(new ResolvedArtifactSet.Artifacts(){

                @Override
                public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
                }

                @Override
                public void visit(ArtifactVisitor visitor) {
                    if (visitor.prepareForVisit(FileCollectionInternal.OTHER) == FileCollectionStructureVisitor.VisitType.Visit) {
                        ((ArtifactVisitorToResolvedFileVisitorAdapter)visitor).visitFile(file);
                        visitor.endVisitCollection(FileCollectionInternal.OTHER);
                    }
                }
            });
        }

        @Override
        public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
            throw new UnsupportedOperationException();
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            throw new UnsupportedOperationException();
        }
    }

    private static class NameBackedResolutionHost
    implements ResolutionHost {
        private final String displayName;

        public NameBackedResolutionHost(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public DisplayName displayName(String type) {
            return Describables.of((Object)this.getDisplayName(), (Object)type);
        }

        @Override
        public Optional<? extends RuntimeException> mapFailure(String type, Collection<Throwable> failures) {
            if (failures.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new DefaultLenientConfiguration.ArtifactResolveException(type, this.getDisplayName(), failures));
        }
    }
}

