/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.event;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.event.CoreEventRegistration;
import org.xmind.core.internal.event.CoreEventRegistrationList;

public class CoreEventSupport
implements ICoreEventSupport {
    private ICoreEventSupport parent;
    private Map<ICoreEventSource, CoreEventManager> managers;
    private CoreEventManager globalManager;

    public ICoreEventSupport getParent() {
        return this.parent;
    }

    public void setParent(ICoreEventSupport parent) {
        this.parent = parent;
    }

    public ICoreEventRegistration registerCoreEventListener(ICoreEventSource source, String eventType, ICoreEventListener listener) {
        return this.registerListener(source, eventType, listener, false);
    }

    private ICoreEventRegistration registerListener(ICoreEventSource source, String eventType, ICoreEventListener listener, boolean once) {
        CoreEventManager manager;
        CoreEventRegistration reg = new CoreEventRegistration(this, source, eventType, listener, once);
        if (this.managers == null) {
            this.managers = new HashMap<ICoreEventSource, CoreEventManager>();
        }
        if ((manager = this.managers.get(source)) == null) {
            manager = new CoreEventManager();
            this.managers.put(source, manager);
        }
        manager.add(reg);
        return reg;
    }

    public ICoreEventRegistration registerGlobalListener(String eventType, ICoreEventListener listener) {
        return this.registerGlobalListener(eventType, listener, false);
    }

    private ICoreEventRegistration registerGlobalListener(String eventType, ICoreEventListener listener, boolean once) {
        CoreEventRegistration reg = new CoreEventRegistration(this, null, eventType, listener, once);
        if (this.globalManager == null) {
            this.globalManager = new CoreEventManager();
        }
        this.globalManager.add(reg);
        return reg;
    }

    public ICoreEventRegistration registerOnceCoreEventListener(ICoreEventSource source, String eventType, ICoreEventListener listener) {
        ICoreEventRegistration reg = this.registerListener(source, eventType, listener, true);
        this.dispatch(source, eventType, new CoreEvent(source, eventType, null, listener), false);
        return reg;
    }

    public ICoreEventRegistration registerOnceGlobalListener(String eventType, ICoreEventListener listener) {
        ICoreEventRegistration reg = this.registerGlobalListener(eventType, listener, true);
        if (this.managers != null) {
            for (Map.Entry<ICoreEventSource, CoreEventManager> entry : this.managers.entrySet()) {
                if (!entry.getValue().hasListeners(eventType)) continue;
                ICoreEventSource source = entry.getKey();
                this.dispatch(source, eventType, new CoreEvent(source, eventType, listener), false);
            }
        }
        return reg;
    }

    protected void unregister(CoreEventRegistration reg) {
        ICoreEventSource source = reg.getSource();
        if (source == null) {
            this.unregisterGlobalRegistration(reg);
            return;
        }
        if (this.managers == null || this.managers.isEmpty()) {
            return;
        }
        CoreEventManager manager = this.managers.get(source);
        if (manager == null) {
            return;
        }
        manager.remove(reg);
        if (manager.isEmpty()) {
            this.managers.remove(source);
        }
        if (this.managers.isEmpty()) {
            this.managers = null;
        }
        if (reg.isOnce()) {
            String eventType = reg.getEventType();
            ICoreEventListener listener = reg.getListener();
            this.dispatch(source, eventType, new CoreEvent(source, eventType, (Object)listener, null), false);
        }
    }

    private void unregisterGlobalRegistration(CoreEventRegistration reg) {
        if (this.globalManager != null) {
            this.globalManager.remove(reg);
        }
        if (this.globalManager.isEmpty()) {
            this.globalManager = null;
        }
    }

    public void dispatchValueChange(ICoreEventSource source, String eventType, Object oldValue, Object newValue) {
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.dispatch(source, eventType, new CoreEvent(source, eventType, oldValue, newValue), true);
    }

    public void dispatchIndexedValueChange(ICoreEventSource source, String eventType, Object oldValue, Object newValue, int index) {
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.dispatch(source, eventType, new CoreEvent(source, eventType, oldValue, newValue, index), true);
    }

    public void dispatchIndexedTargetChange(ICoreEventSource source, String eventType, Object target, int index) {
        this.dispatch(source, eventType, new CoreEvent(source, eventType, target, index), true);
    }

    public void dispatchTargetChange(ICoreEventSource source, String eventType, Object target) {
        this.dispatch(source, eventType, new CoreEvent(source, eventType, target), true);
    }

    public void dispatchTargetValueChange(ICoreEventSource source, String eventType, Object target, Object oldValue, Object newValue) {
        this.dispatch(source, eventType, new CoreEvent(source, eventType, target, oldValue, newValue), true);
    }

    public void dispatch(ICoreEventSource source, CoreEvent event) {
        String eventType = event.getType();
        this.dispatch(source, eventType, event, true);
    }

    private void dispatch(ICoreEventSource source, String eventType, CoreEvent event, boolean notifyOnceListeners) {
        this.dispatchBySource(source, eventType, event, notifyOnceListeners);
        this.dispatchGlobal(eventType, event, notifyOnceListeners);
    }

    private void dispatchBySource(ICoreEventSource source, String eventType, CoreEvent event, boolean notifyOnceListeners) {
        if (this.managers == null || this.managers.isEmpty()) {
            return;
        }
        CoreEventManager manager = this.managers.get(source);
        if (manager == null || manager.isEmpty()) {
            return;
        }
        if (notifyOnceListeners) {
            manager.dispatchCoreEvent(eventType, event);
        } else {
            manager.dispatchCoreEvent(eventType, event, 2);
        }
    }

    private void dispatchGlobal(String eventType, CoreEvent event, boolean notifyOnceListeners) {
        if (this.globalManager != null) {
            if (notifyOnceListeners) {
                this.globalManager.dispatchCoreEvent(eventType, event);
            } else {
                this.globalManager.dispatchCoreEvent(eventType, event, 2);
            }
        }
        if (this.getParent() != null && this.getParent() instanceof CoreEventSupport) {
            ((CoreEventSupport)this.getParent()).dispatchGlobal(eventType, event, notifyOnceListeners);
        }
    }

    public void dispose() {
        if (this.managers != null) {
            this.managers.clear();
            this.managers = null;
        }
    }

    public boolean hasListeners(ICoreEventSource source, String eventType) {
        if (this.managers == null) {
            return false;
        }
        CoreEventManager manager = this.managers.get(source);
        return manager != null && manager.hasListeners(eventType);
    }

    public boolean hasOnceListeners(ICoreEventSource source, String eventType) {
        if (this.managers == null) {
            return false;
        }
        CoreEventManager manager = this.managers.get(source);
        return manager != null && manager.hasOnceListeners(eventType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CoreEventManager {
        private Map<String, CoreEventRegistrationList> regs;

        private CoreEventManager() {
        }

        public void add(CoreEventRegistration reg) {
            this.regs = this.addListener(reg.getEventType(), reg, this.regs);
        }

        private Map<String, CoreEventRegistrationList> addListener(String type, CoreEventRegistration reg, Map<String, CoreEventRegistrationList> map) {
            CoreEventRegistrationList list;
            if (map == null) {
                map = new HashMap<String, CoreEventRegistrationList>();
            }
            if ((list = map.get(type)) == null) {
                list = new CoreEventRegistrationList();
                map.put(type, list);
            }
            list.add(reg);
            return map;
        }

        public void remove(CoreEventRegistration reg) {
            this.regs = this.removeListener(reg.getEventType(), reg, this.regs);
        }

        private Map<String, CoreEventRegistrationList> removeListener(String type, CoreEventRegistration reg, Map<String, CoreEventRegistrationList> map) {
            if (map != null) {
                CoreEventRegistrationList list = map.get(type);
                if (list != null) {
                    list.remove(reg);
                    if (list.isEmpty()) {
                        map.remove(type);
                    }
                }
                if (map.isEmpty()) {
                    map = null;
                }
            }
            return map;
        }

        public boolean isEmpty() {
            return this.regs == null || this.regs.isEmpty();
        }

        public void dispatchCoreEvent(String type, CoreEvent event) {
            CoreEventRegistrationList list;
            if (this.regs != null && (list = this.regs.get(type)) != null) {
                if (list.hasOnceRegistration()) {
                    list.fireCoreEvent(event, 1);
                } else {
                    list.fireCoreEvent(event, 3);
                }
            }
        }

        public void dispatchCoreEvent(String type, CoreEvent event, int eventGroup) {
            this.dispatchCoreEvent(type, event, eventGroup, this.regs);
        }

        private Map<String, CoreEventRegistrationList> dispatchCoreEvent(String type, CoreEvent event, int eventGroup, Map<String, CoreEventRegistrationList> map) {
            CoreEventRegistrationList list;
            if (map != null && (list = map.get(type)) != null) {
                list.fireCoreEvent(event, eventGroup);
            }
            return map;
        }

        public boolean hasListeners(String type) {
            return this.regs != null && this.regs.containsKey(type);
        }

        public boolean hasOnceListeners(String type) {
            if (this.regs == null) {
                return false;
            }
            CoreEventRegistrationList list = this.regs.get(type);
            return list != null && list.hasOnceRegistration();
        }
    }
}

