/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class DateInfo {
    public Calendar date = DateInfo.today();
    public boolean allDay;

    public DateInfo() {
        this.allDay = true;
    }

    public DateInfo(Calendar date, boolean allDay) {
        this.date.setTimeInMillis(date.getTimeInMillis());
        this.date.set(14, 0);
        this.allDay = allDay;
        if (allDay) {
            this.setTime(date.get(11), date.get(12), 0);
        }
    }

    public DateInfo setDate(Calendar date) {
        return this.setDate(date.get(1), date.get(2), date.get(5), date.get(11), date.get(12));
    }

    public DateInfo setDate(int year, int month, int date) {
        this.date.set(1, year);
        this.date.set(2, month);
        this.date.set(5, date);
        return this;
    }

    public DateInfo setDate(int year, int month, int date, int hour, int minutes) {
        this.date.set(1, year);
        this.date.set(2, month);
        this.date.set(5, date);
        this.date.set(11, hour);
        this.date.set(12, minutes);
        return this;
    }

    public DateInfo setTime(Calendar time) {
        return this.setTime(time.get(11), time.get(12), time.get(13));
    }

    public DateInfo setTime(int hours, int minutes, int seconds) {
        this.date.set(11, hours);
        this.date.set(12, minutes);
        this.date.set(13, seconds);
        return this;
    }

    public DateInfo add(DurationInfo duration) {
        duration.addTo(this);
        return this;
    }

    public DateInfo remove(DurationInfo duration) {
        duration.removeFrom(this);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateInfo)) {
            return false;
        }
        DateInfo that = (DateInfo)obj;
        if (this.allDay != that.allDay) {
            return false;
        }
        if (this.date == null || that.date == null) {
            return this.date == that.date;
        }
        if (this.allDay) {
            return this.date.get(1) == that.date.get(1) && this.date.get(2) == that.date.get(2) && this.date.get(5) == that.date.get(5);
        }
        return this.date.equals(that.date);
    }

    public int hashCode() {
        return this.allDay ? this.date.hashCode() : -this.date.hashCode();
    }

    public String toString() {
        return TaskInfoUtils.format(this);
    }

    public static Calendar today() {
        return new GregorianCalendar();
    }
}

