/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.core.usagedata.IUsageDataSampler;
import org.xmind.core.usagedata.IUsageDataUploader;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;
import org.xmind.ui.resources.ColorUtils;

public class StartupPreferencePageSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    private Composite container;
    private Button startupActionButton;
    private LocalResourceManager resources;

    protected Control createContents(Composite parent) {
        if (this.container == null) {
            this.container = parent;
        }
        return super.createContents(parent);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CathyPlugin.getDefault().getPreferenceStore();
    }

    protected void initialize() {
        super.initialize();
        int startupAction = this.getPreferenceStore().getInt("startupAction2");
        this.startupActionButton.setSelection(startupAction == 3);
    }

    public void createControl(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        super.createControl(parent);
    }

    protected void createFieldEditors() {
        this.addStartupGroup(this.container);
        if (this.isShowUploadDataCheck()) {
            this.addSendUsageDataGroup(this.container);
        }
        this.initialize();
    }

    private void addStartupGroup(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().indent(25, 0).applyTo((Control)container);
        this.startupActionButton = new Button(container, 32);
        this.startupActionButton.setText(WorkbenchMessages.RestoreLastSession_label);
        if (this.isShowUploadDataCheck()) {
            this.addField((FieldEditor)new BooleanFieldEditor("checkUpdatesOnStartup", WorkbenchMessages.CheckUpdates_label, container));
        }
    }

    private boolean isShowUploadDataCheck() {
        return !Boolean.getBoolean("org.xmind.cathy.notShowUploadDataCheck");
    }

    private void addSendUsageDataGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(25, 0).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(5, 0).applyTo(composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        GridLayoutFactory.fillDefaults().applyTo(composite2);
        this.addField((FieldEditor)new BooleanFieldEditor("usageDataUploadingEnabled", WorkbenchMessages.GeneralPrefPage_usageData_text, composite2));
        Hyperlink privacyHyperlink = new Hyperlink(composite, 0);
        privacyHyperlink.setBackground(composite.getBackground());
        privacyHyperlink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        privacyHyperlink.setText(WorkbenchMessages.GeneralPrefPage_seePolicy_link);
        privacyHyperlink.setUnderlined(true);
        privacyHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#006CF9")));
        privacyHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/privacy/usage/"));
            }
        });
        composite.setFocus();
        if (CathyPlugin.getDefault().isDebugging("/debug/udc/showUploadButton")) {
            Button uploadButton = new Button(composite, 8);
            GridDataFactory.fillDefaults().align(1, 0x1000000).span(2, 0).indent(10, 0).minSize(100, 0).applyTo((Control)uploadButton);
            uploadButton.setBackground(composite.getBackground());
            uploadButton.setText("Upload Now");
            uploadButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    IUsageDataSampler sampler = CathyPlugin.getDefault().getUsageDataCollector();
                    if (sampler instanceof IUsageDataUploader) {
                        ((IUsageDataUploader)sampler).forceUpload();
                    }
                }
            });
        }
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        if (this.startupActionButton.getSelection()) {
            this.getPreferenceStore().setValue("startupAction2", 3);
        } else {
            this.getPreferenceStore().setValue("startupAction2", 0);
        }
        return true;
    }
}

