/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.cell;

import com.aspose.cells.Cell;
import com.aspose.cells.CellArea;
import com.aspose.cells.Cells;
import com.aspose.cells.Color;
import com.aspose.cells.Comment;
import com.aspose.cells.CommentCollection;
import com.aspose.cells.Encoding;
import com.aspose.cells.Font;
import com.aspose.cells.License;
import com.aspose.cells.Style;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.cell.ExcelExportPageBase;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.ExportUtils;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends Exporter {
    public static final int EXCEL_97_2003 = 5;
    public static final int EXCEL_2007 = 6;
    public static final int CSV = 1;
    public static final int ODS = 14;
    private static int rowIndex = 2;
    private static int columnIndex = 0;
    private static int columnMaxIndex = 0;
    private int version;
    private String targetPath;
    private Workbook workbook;

    public ExcelExporter(ISheet sheet, ITopic centralTopic, String targetPath, int version) {
        super(sheet, centralTopic);
        this.targetPath = targetPath;
        this.version = version;
    }

    public void init() {
        rowIndex = 2;
        columnIndex = 0;
        columnMaxIndex = 0;
        List sheets = this.getSheet().getOwnedWorkbook().getSheets();
        int i = 0;
        while (i < sheets.size()) {
            this.appendTopic(((ISheet)sheets.get(i)).getRootTopic(), 0, i);
            this.append((IExportPart)new HeaderPart(this, i));
            this.appendTaskInfo(i);
            ++i;
        }
    }

    private void appendTopic(ITopic topic, int level, int sheetIndex) {
        this.append(this.getTitlePart(topic, level, sheetIndex));
        this.appendTopicContent(topic, level, sheetIndex);
        this.appendFloatingTopic(topic, level, sheetIndex);
    }

    private IExportPart getTitlePart(ITopic topic, int level, int sheetIndex) {
        String excelLayout = this.getString("excelType", ExcelExportPageBase.ExcelType.MergedCell.getKey());
        if (ExcelExportPageBase.ExcelType.Pivot.getKey().equals(excelLayout)) {
            return new PivotTitlePart(this, topic, level, sheetIndex);
        }
        if (ExcelExportPageBase.ExcelType.Outline.getKey().equals(excelLayout)) {
            return new OutlineTitlePart(this, topic, level, sheetIndex);
        }
        return new MergedCellTitlePart(this, topic, level, sheetIndex);
    }

    private void appendTopicContent(ITopic topic, int level, int sheetIndex) {
        int nextLevel = level + 1;
        for (ITopic sub : topic.getChildren("attached")) {
            this.appendTopic(sub, nextLevel, sheetIndex);
        }
    }

    private void appendFloatingTopic(ITopic topic, int level, int sheetIndex) {
        if (this.getBoolean("includeFloatingTopics")) {
            int nextLevel = level + 1;
            for (ITopic sub : topic.getChildren("detached")) {
                this.appendTopic(sub, nextLevel, sheetIndex);
            }
        }
    }

    private void appendTaskInfo(int sheetIndex) {
        if (this.getBoolean("includeTaskInfo")) {
            this.append(this.getTaskInfoPart(sheetIndex));
        }
    }

    private IExportPart getTaskInfoPart(int sheetIndex) {
        String excelLayout = this.getString("excelType", ExcelExportPageBase.ExcelType.MergedCell.getKey());
        if (ExcelExportPageBase.ExcelType.Pivot.getKey().equals(excelLayout)) {
            return new PivotTaskInfoPart(this, null, sheetIndex);
        }
        if (ExcelExportPageBase.ExcelType.Outline.getKey().equals(excelLayout)) {
            return new OutlineTaskInfoPart(this, null, sheetIndex);
        }
        return new MergedTaskInfoPart(this, null, sheetIndex);
    }

    public void start(Display display, Shell shell) throws InvocationTargetException {
        super.start(display, shell);
        this.setLicense();
        this.workbook = new Workbook();
        int i = 1;
        while (i < this.getSheet().getOwnedWorkbook().getSheets().size()) {
            this.workbook.getWorksheets().add();
            ++i;
        }
    }

    private void setLicense() {
        new License().setLicense((InputStream)new ByteArrayInputStream(AsposePlugin.getAsposeLicense()));
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (part instanceof ExcelExportPart) {
            ((ExcelExportPart)part).write(this.workbook);
        }
    }

    public void end() throws InvocationTargetException {
        try {
            this.workbook.getSettings().setEncoding(Encoding.getUTF8());
            this.workbook.save(this.targetPath, this.version);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        super.end();
    }

    private static List<ITopic> getAllTopics(ISheet sheet, boolean includeFloatingTopic, boolean includeSummary, boolean includeCallout) {
        ArrayList<ITopic> topics = new ArrayList<ITopic>();
        if (sheet != null && sheet.getRootTopic() != null) {
            ExcelExporter.fillTopics(topics, sheet.getRootTopic(), includeFloatingTopic, includeSummary, includeCallout);
        }
        return topics;
    }

    private static void fillTopics(List<ITopic> topics, ITopic topic, boolean includeFloatingTopic, boolean includeSummary, boolean includeCallout) {
        if (topics == null || topic == null) {
            return;
        }
        topics.add(topic);
        List children = topic.getChildren("attached");
        if (includeFloatingTopic) {
            children.addAll(topic.getChildren("detached"));
        }
        if (includeSummary) {
            children.addAll(topic.getChildren("summary"));
        }
        if (includeCallout) {
            children.addAll(topic.getChildren("callout"));
        }
        if (children == null || children.size() == 0) {
            return;
        }
        for (ITopic child : children) {
            ExcelExporter.fillTopics(topics, child, includeFloatingTopic, includeSummary, includeCallout);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ExcelExportPart
    extends ExportPart {
        protected Workbook workbook;
        protected Worksheet sheet;
        protected int sheetIndex;

        public ExcelExportPart(ExcelExporter exporter, Object element, int sheetIndex) {
            super((IExporter)exporter, element);
            this.sheetIndex = sheetIndex;
        }

        public void write(Workbook workbook) {
            this.workbook = workbook;
            this.write();
        }

        protected abstract void write();

        protected Worksheet getWorksheet() {
            if (this.sheet != null) {
                return this.sheet;
            }
            return this.workbook.getWorksheets().get(this.sheetIndex);
        }

        protected Cell getCell(int rowIndex, int colIndex) {
            return this.getCells().get(rowIndex, colIndex);
        }

        protected Cells getCells() {
            return this.getWorksheet().getCells();
        }

        protected void mergedCell(Cell firstCell, int totalRows, int totalCols) {
            this.getCells().merge(firstCell.getRow(), firstCell.getColumn(), totalRows, totalCols);
        }

        protected CellArea getCellArea(Cell cell) {
            for (CellArea area : this.getWorksheet().getCells().getMergedCells()) {
                if (area.EndRow != cell.getRow() || area.EndColumn != cell.getColumn()) continue;
                return area;
            }
            return null;
        }

        protected Cell setCellValue(int rowIndex, int colIndex, String value) {
            Cell cell = this.getCell(rowIndex, colIndex);
            if ("linux".equals(Platform.getOS()) && value != null) {
                value = value.replaceAll("\\r\\n|\\n|\\r", " ");
            }
            if (value != null) {
                cell.setValue((Object)value);
            }
            this.setCellStyle(cell);
            return cell;
        }

        protected void setCellStyle(Cell cell) {
            int defaultStyle = 1;
            this.setCellStyle(cell, defaultStyle);
        }

        protected void setCellStyle(Cell cell, int styleLevel) {
            Style style = cell.getStyle();
            style.setVerticalAlignment(1);
            style.setHorizontalAlignment(7);
            this.setFontStyle(style, styleLevel);
            cell.setStyle(style);
            this.setAutoFitCell(cell);
        }

        protected void setAutoFitCell(Cell cell) {
            try {
                this.getWorksheet().autoFitColumn(cell.getColumn());
                this.getWorksheet().autoFitRow(cell.getRow());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void setFontStyle(Style style, int styleLevel) {
            Font font = style.getFont();
            font.setName("Calibri");
            font.setSize(12);
            if (styleLevel == 0) {
                style.setHorizontalAlignment(1);
                style.setForegroundColor(Color.fromArgb((int)218, (int)238, (int)243));
                style.setPattern(1);
                font.setSize(14);
                font.setBold(true);
            } else if (styleLevel == -1) {
                style.setForegroundColor(Color.fromArgb((int)218, (int)238, (int)243));
                style.setPattern(1);
                this.setTitleBorder(style);
                font.setBold(true);
            }
        }

        private void setTitleBorder(Style style) {
            style.setBorder(8, 1, Color.fromArgb((int)0, (int)0, (int)0));
            style.setBorder(1, 1, Color.fromArgb((int)0, (int)0, (int)0));
            style.setBorder(2, 1, Color.fromArgb((int)0, (int)0, (int)0));
            style.setBorder(4, 1, Color.fromArgb((int)0, (int)0, (int)0));
        }

        protected boolean isCentralTopicAsTitle() {
            String position = this.getExporter().getString("positionType", null);
            if (position != null) {
                if (position.equals(ExcelExportPageBase.CentralTopicPosition.Row.name())) {
                    return true;
                }
                if (position.equals(ExcelExportPageBase.CentralTopicPosition.Column.name())) {
                    return false;
                }
            }
            return true;
        }

        protected int getAllBeforeRows(int sheetIndex, boolean isOutline) {
            int size = 0;
            int i = 1;
            while (i <= sheetIndex) {
                size += this.getTopicRows(i, isOutline);
                ++i;
            }
            return size;
        }

        protected int getBeforeTopicRows(int sheetIndex, boolean isOutline) {
            return this.getTopicRows(sheetIndex, isOutline);
        }

        private int getTopicRows(int sheetIndex, boolean isOutline) {
            int size = 0;
            if (sheetIndex > 0) {
                ISheet sheet = (ISheet)this.getExporter().getSheet().getOwnedWorkbook().getSheets().get(sheetIndex - 1);
                List topicsWithAttached = ExcelExporter.getAllTopics(sheet, false, false, false);
                size = size + topicsWithAttached.size() - 1;
                if (!isOutline) {
                    size -= this.getWithChildren(topicsWithAttached);
                }
                if (this.getExporter().getBoolean("includeFloatingTopics")) {
                    List allFloatingTopic = MindMapUtils.getAllFloatingTopics((ISheet)sheet);
                    size += allFloatingTopic.size();
                    if (!isOutline) {
                        size = size - this.getWithChildren(allFloatingTopic) + 1;
                    }
                }
            }
            return size;
        }

        private int getWithChildren(List<ITopic> topics) {
            int size = 0;
            for (ITopic topic : topics) {
                if (topic.getAllChildren().isEmpty()) continue;
                ++size;
            }
            return size;
        }

        protected int getAllBeforeDetachedRows() {
            int size = 0;
            int i = 0;
            while (i < this.sheetIndex) {
                size += this.getDetachedSize(i);
                ++i;
            }
            return size;
        }

        protected int getBeforeDetachedRows() {
            if (this.sheetIndex > 0) {
                return this.getDetachedSize(this.sheetIndex - 1);
            }
            return 0;
        }

        private int getDetachedSize(int i) {
            int size = 0;
            ISheet sheet = (ISheet)this.getExporter().getSheet().getOwnedWorkbook().getSheets().get(i);
            if (sheet != null) {
                size += sheet.getRootTopic().getChildren("detached").size();
            }
            return size;
        }

        protected boolean hasFloatingTopic() {
            ISheet sheet = (ISheet)this.getExporter().getSheet().getOwnedWorkbook().getSheets().get(this.sheetIndex - 1);
            List allFloatingTopic = MindMapUtils.getAllFloatingTopics((ISheet)sheet);
            if (allFloatingTopic == null || allFloatingTopic.isEmpty()) {
                return false;
            }
            if (allFloatingTopic != null && !allFloatingTopic.isEmpty()) {
                allFloatingTopic.remove(sheet.getRootTopic());
                return !allFloatingTopic.isEmpty();
            }
            return false;
        }
    }

    private static class HeaderPart
    extends ExcelExportPart {
        public HeaderPart(ExcelExporter exporter, int sheetIndex) {
            super(exporter, null, sheetIndex);
        }

        protected void write() {
            this.writeLevelHeader();
            if (this.isCentralTopicAsTitle()) {
                this.mergedTitleCell();
            }
            if (this.getExporter().getBoolean("includeTaskInfo")) {
                this.writeTaskInfoHeader();
            }
        }

        private void writeLevelHeader() {
            int maxLevel;
            int headerStyle = -1;
            int row = 1;
            if (!this.isCentralTopicAsTitle()) {
                columnMaxIndex = columnMaxIndex + 1;
                --row;
            }
            if ((maxLevel = columnMaxIndex) > 0) {
                int i = 0;
                while (i < maxLevel) {
                    String value = "Level " + (i + 1);
                    this.setCellStyle(this.setCellValue(row, i, value), headerStyle);
                    ++i;
                }
            }
            if (this.isCentralTopicAsTitle() && this.getExporter().getBoolean("includeTaskInfo")) {
                columnMaxIndex = columnMaxIndex + TaskInfoTag.values().length;
            }
        }

        private void writeTaskInfoHeader() {
            rowIndex = 0;
            if (this.isCentralTopicAsTitle()) {
                rowIndex = 1;
                columnMaxIndex = columnMaxIndex - TaskInfoTag.values().length;
            }
            columnIndex = columnMaxIndex - 1;
            TaskInfoTag[] taskInfoTagArray = TaskInfoTag.values();
            int n = taskInfoTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                TaskInfoTag task = taskInfoTagArray[n2];
                int headerStyle = -1;
                int n3 = rowIndex;
                int n4 = columnMaxIndex;
                columnMaxIndex = n4 + 1;
                this.setCellStyle(this.setCellValue(n3, n4, task.getValue()), headerStyle);
                ++n2;
            }
            rowIndex = rowIndex + 1;
        }

        private void mergedTitleCell() {
            Cell titleCell = this.getCell(0, 0);
            if (columnMaxIndex > 0) {
                this.mergedCell(titleCell, 1, columnMaxIndex);
            }
            this.setCellStyle(titleCell, 0);
        }
    }

    private static class MergedCellTitlePart
    extends TitlePart {
        public MergedCellTitlePart(ExcelExporter exporter, ITopic topic, int level, int sheetIndex) {
            super(exporter, topic, level, sheetIndex);
        }

        protected void write() {
            if (this.level == 0) {
                columnIndex = 0;
                rowIndex = 2;
                columnMaxIndex = 0;
                if (this.isCentralTopicAsTitle()) {
                    this.setCellValue(0, columnIndex, this.topic);
                    return;
                }
            }
            int row = rowIndex;
            row -= this.isCentralTopicAsTitle() ? 0 : 1;
            if (this.hasParent() && columnIndex == 0) {
                this.mergedParent(row);
                columnIndex = this.isCentralTopicAsTitle() ? this.getTopicLevel() - 1 : this.getTopicLevel();
            }
            int n = columnIndex;
            columnIndex = n + 1;
            this.setCellValue(row, n, this.topic);
            if (this.isEnding()) {
                if (!this.isCentralTopicAsTitle()) {
                    columnIndex = columnIndex - 1;
                }
                this.setTopicMaxLevel(columnIndex);
                rowIndex = rowIndex + 1;
                columnIndex = 0;
            }
        }

        protected void mergedParent(int row) {
            int column = this.isCentralTopicAsTitle() ? this.getTopicLevel() - 1 : this.getTopicLevel();
            int i = 0;
            while (i < column) {
                Cell parentCell = this.getCell(row - 1, i);
                if (!parentCell.isMerged()) {
                    this.mergedCell(parentCell, 2, 1);
                } else {
                    CellArea area = this.getCellArea(parentCell);
                    Cell firstCell = this.getCell(area.StartRow, area.StartColumn);
                    int rowDistance = row - area.StartRow + 1;
                    this.mergedCell(firstCell, rowDistance, 1);
                }
                ++i;
            }
        }
    }

    private static class MergedTaskInfoPart
    extends TaskInfoPart {
        public MergedTaskInfoPart(ExcelExporter exporter, Object element, int sheetIndex) {
            super(exporter, element, sheetIndex);
        }

        protected void write() {
            if (this.isCentralTopicAsTitle()) {
                columnMaxIndex = columnMaxIndex + TaskInfoTag.values().length;
            }
            Iterator<ITopic> iterator = this.getTopicsWithoutRoot().iterator();
            while (iterator.hasNext()) {
                ITopic topic;
                this.topic = topic = iterator.next();
                this.taskColIndex = columnIndex;
                if (topic.getAllChildren().size() != 0) continue;
                this.writeContents();
            }
        }
    }

    private static class OutlineTaskInfoPart
    extends TaskInfoPart {
        public OutlineTaskInfoPart(ExcelExporter exporter, Object element, int sheetIndex) {
            super(exporter, element, sheetIndex);
        }

        protected void write() {
            if (this.isCentralTopicAsTitle()) {
                columnMaxIndex = columnMaxIndex + TaskInfoTag.values().length;
            }
            Iterator<ITopic> iterator = this.getTopicsWithoutRoot().iterator();
            while (iterator.hasNext()) {
                ITopic topic;
                this.topic = topic = iterator.next();
                this.taskColIndex = columnIndex;
                this.writeContents();
            }
        }
    }

    private static class OutlineTitlePart
    extends TitlePart {
        public OutlineTitlePart(ExcelExporter exporter, ITopic topic, int level, int sheetIndex) {
            super(exporter, topic, level, sheetIndex);
        }

        protected void write() {
            boolean includeTaskInfo = this.getExporter().getBoolean("includeTaskInfo");
            if (this.level == 0) {
                columnMaxIndex = 0;
                if (this.isCentralTopicAsTitle()) {
                    this.setCellValue(0, 0, this.topic);
                } else {
                    this.setCellValue(1, 0, this.topic);
                }
                return;
            }
            columnIndex = this.isCentralTopicAsTitle() ? this.getTopicLevel() - 1 : this.getTopicLevel();
            int row = rowIndex;
            boolean includeFloatingTopics = this.getExporter().getBoolean("includeFloatingTopics");
            if (this.sheetIndex > 0) {
                if (!includeTaskInfo) {
                    row -= this.getAllBeforeRows(this.sheetIndex, true);
                    if (includeFloatingTopics) {
                        row += this.sheetIndex;
                        if (this.hasFloatingTopic()) {
                            row -= this.getAllBeforeDetachedRows();
                        }
                    }
                } else {
                    row = row - this.getBeforeTopicRows(this.sheetIndex, true) + 1;
                    if (includeFloatingTopics) {
                        ++row;
                        if (this.hasFloatingTopic()) {
                            row -= this.getBeforeDetachedRows();
                        }
                    }
                }
            }
            rowIndex = rowIndex + 1;
            int n = columnIndex;
            columnIndex = n + 1;
            this.setCellValue(row, n, this.topic);
            if (this.isEnding()) {
                if (!this.isCentralTopicAsTitle()) {
                    columnIndex = columnIndex - 1;
                }
                this.setTopicMaxLevel(columnIndex);
            }
        }
    }

    private static class PivotTaskInfoPart
    extends TaskInfoPart {
        public PivotTaskInfoPart(ExcelExporter exporter, Object element, int sheetIndex) {
            super(exporter, element, sheetIndex);
        }

        protected void write() {
            if (this.isCentralTopicAsTitle()) {
                columnMaxIndex = columnMaxIndex + TaskInfoTag.values().length;
            }
            Iterator<ITopic> iterator = this.getTopicsWithoutRoot().iterator();
            while (iterator.hasNext()) {
                ITopic topic;
                this.topic = topic = iterator.next();
                this.taskColIndex = columnIndex;
                if (topic.getAllChildren().size() != 0) continue;
                this.writeContents();
            }
        }
    }

    private static class PivotTitlePart
    extends TitlePart {
        public PivotTitlePart(ExcelExporter exporter, ITopic topic, int level, int sheetIndex) {
            super(exporter, topic, level, sheetIndex);
        }

        protected void write() {
            if (this.level == 0) {
                columnIndex = 0;
                columnMaxIndex = 0;
                this.setCellValue(0, columnIndex, this.topic);
                return;
            }
            int row = rowIndex;
            boolean includeTaskInfo = this.getExporter().getBoolean("includeTaskInfo");
            boolean includeFloatingTopics = this.getExporter().getBoolean("includeFloatingTopics");
            if (this.sheetIndex > 0) {
                if (!includeTaskInfo) {
                    row -= this.getAllBeforeRows(this.sheetIndex, false);
                    row = !includeFloatingTopics ? (row -= this.sheetIndex) : (row -= this.getAllBeforeDetachedRows());
                } else {
                    row -= this.getBeforeTopicRows(this.sheetIndex, false);
                    if (includeFloatingTopics) {
                        if (this.hasFloatingTopic()) {
                            row -= this.getBeforeDetachedRows();
                        }
                    } else {
                        --row;
                    }
                }
            }
            row -= this.isCentralTopicAsTitle() ? 0 : 1;
            if (this.hasParent()) {
                this.writeParent(row);
            }
            int n = columnIndex;
            columnIndex = n + 1;
            this.setCellValue(row, n, this.topic);
            if (this.isEnding()) {
                if (!this.isCentralTopicAsTitle()) {
                    columnIndex = columnIndex - 1;
                }
                this.setTopicMaxLevel(columnIndex);
                rowIndex = rowIndex + 1;
                columnIndex = 0;
            }
        }

        private void writeParent(int row) {
            int topicIndex = this.isCentralTopicAsTitle() ? this.getTopicLevel() - 1 : this.getTopicLevel();
            List topics = this.topic.getPath().toTopicList();
            int column = 0;
            while (column < topicIndex) {
                int col = this.isCentralTopicAsTitle() ? column + 1 : column;
                this.setCellValue(row, column, (ITopic)topics.get(col));
                ++column;
            }
            columnIndex = topicIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskInfoPart
    extends ExcelExportPart {
        protected ITopic topic;
        protected Integer taskColIndex;
        private static final String MARKER_FLAG_ID = "flagMakers";
        private static final String MARKER_STAR_ID = "starMakers";
        private static final String MARKER_PEOPLE_ID = "peopleMakers";
        private static final String MARKER_PROGRESS_ID = "taskMakers";
        private static final String MARKER_PRIORITY_ID = "priorityMarkers";

        public TaskInfoPart(ExcelExporter exporter, Object element, int sheetIndex) {
            super(exporter, element, sheetIndex);
        }

        @Override
        protected void write() {
        }

        protected void writeContents() {
            this.writeAssigned();
            this.writePriority();
            this.writeStartDate();
            this.writeDuration();
            this.writeEndDate();
            this.writeProgress();
            this.writeCheckPoint();
            this.writeMarker();
            rowIndex = rowIndex + 1;
        }

        protected void writeAssigned() {
            String assignedTo = TaskInfoUtils.getContent((ITopic)this.topic, (String)"assigned-to");
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, assignedTo);
        }

        protected void writePriority() {
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, this.getPriorityMarker());
        }

        protected void writeStartDate() {
            DateInfo dateInfo = TaskInfoUtils.calculateStartDateInfo((ITopic)this.topic);
            String startDate = dateInfo == null ? null : dateInfo.toString();
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, startDate);
        }

        protected void writeDuration() {
            if (TaskInfoUtils.calculateStartDateInfo((ITopic)this.topic) == null && TaskInfoUtils.calculateEndDateInfo((ITopic)this.topic) == null) {
                this.taskColIndex = this.taskColIndex + 1;
                return;
            }
            DurationInfo info = TaskInfoUtils.calculateDurationExcludeWeekends((ITopic)this.topic);
            String duration = info == null ? null : info.toString();
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, duration);
        }

        protected void writeEndDate() {
            DateInfo dateInfo = TaskInfoUtils.calculateEndDateInfo((ITopic)this.topic);
            String endDate = dateInfo == null ? null : dateInfo.toString();
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, endDate);
        }

        protected void writeProgress() {
            String progress;
            int progressNum = TaskInfoUtils.getProgress((ITopic)this.topic);
            String string = progress = progressNum == 0 ? null : String.valueOf(progressNum) + "%";
            if (progress == null) {
                Set markers = this.topic.getMarkerRefs();
                if (markers.size() == 0) {
                    return;
                }
                for (IMarkerRef marker : markers) {
                    String groupId;
                    if (marker.getMarker() == null || !(groupId = marker.getMarker().getParent().getId()).equals(MARKER_PROGRESS_ID)) continue;
                    progress = marker.getMarker().getName();
                }
            }
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, progress);
        }

        protected void writeCheckPoint() {
            boolean hasCheckPoint = TaskInfoUtils.getCheckPoint((ITopic)this.topic);
            String checkPoint = hasCheckPoint ? "*" : null;
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, checkPoint);
        }

        protected void writeMarker() {
            String marker = this.getExtraMarkerName();
            if (marker != null) {
                this.setMarkerHeader();
            }
            this.taskColIndex = this.taskColIndex + 1;
            this.setCellValue(rowIndex, this.taskColIndex, marker);
        }

        protected void setMarkerHeader() {
            Cell cell = this.getCell(0, this.taskColIndex + 1);
            String markerHeader = (String)cell.getValue();
            String taskMarterHeader = ExportMessages.ExcelExporter_TaskInfo_Marker;
            if (markerHeader == null || !markerHeader.equals(taskMarterHeader)) {
                cell.setValue((Object)taskMarterHeader);
                int headerStyle = -1;
                this.setCellStyle(cell, headerStyle);
            }
        }

        protected String getPriorityMarker() {
            IMarker marker = TaskInfoUtils.findMarker((ITopic)this.topic, (String)MARKER_PRIORITY_ID);
            String priority = marker == null ? null : marker.getName();
            return priority;
        }

        protected List<ITopic> getTopicsWithoutRoot() {
            List topics = ExcelExporter.getAllTopics((ISheet)this.getExporter().getSheet().getOwnedWorkbook().getSheets().get(this.sheetIndex), this.getExporter().getBoolean("includeFloatingTopics"), false, false);
            topics.remove(0);
            return topics;
        }

        private String getExtraMarkerName() {
            Set markers = this.topic.getMarkerRefs();
            if (markers.size() == 0) {
                return null;
            }
            StringBuilder extraMarkerName = null;
            for (IMarkerRef marker : markers) {
                if (marker.getMarker() == null) continue;
                String groupId = marker.getMarker().getParent().getId();
                String markerName = groupId.equals(MARKER_FLAG_ID) || groupId.equals(MARKER_PEOPLE_ID) || groupId.equals(MARKER_STAR_ID) ? String.valueOf(marker.getMarker().getParent().getName()) + "(" + marker.getMarker().getName() + ")" : marker.getMarker().getName();
                if (!this.isExtraMarker(groupId)) continue;
                if (extraMarkerName == null) {
                    extraMarkerName = new StringBuilder();
                } else {
                    extraMarkerName.append(",");
                }
                extraMarkerName.append(markerName);
            }
            return extraMarkerName == null ? null : extraMarkerName.toString();
        }

        private boolean isExtraMarker(String groupId) {
            return !groupId.equals(MARKER_PRIORITY_ID) && !groupId.equals(MARKER_PROGRESS_ID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskInfoTag {
        ASSIGNED_TO(TaskMessages.AssignedTo_label),
        PRIORITY(TaskMessages.Priority_label),
        START(TaskMessages.StartDate_label),
        DURATION(TaskMessages.Duration_label),
        END(TaskMessages.EndDate_label),
        PROGRESS(TaskMessages.Progress_label),
        CHECK_POINT(TaskMessages.CheckPoint_label);

        private String value;

        private TaskInfoTag(String value) {
            this.value = value;
        }

        public String getValue() {
            int endIndex = this.value.lastIndexOf(":");
            if (endIndex > 0) {
                return this.value.substring(0, endIndex);
            }
            return this.value;
        }
    }

    private static abstract class TitlePart
    extends ExcelExportPart {
        protected ITopic topic;
        protected int level;

        public TitlePart(ExcelExporter exporter, ITopic topic, int level, int sheetIndex) {
            super(exporter, topic, sheetIndex);
            this.topic = topic;
            this.level = level;
        }

        private boolean hasChildren() {
            return this.topic.getAllChildren().size() != 0;
        }

        protected boolean isEnding() {
            return !this.hasChildren();
        }

        protected boolean hasParent() {
            return this.topic.getParent() != null;
        }

        protected int getTopicLevel() {
            List topics = this.topic.getPath().toTopicList();
            return topics.indexOf(this.topic);
        }

        protected void setTopicMaxLevel(int colIndex) {
            if (columnMaxIndex < colIndex) {
                columnMaxIndex = colIndex;
            }
        }

        protected Cell setCellValue(int row, int column, ITopic topic) {
            if (topic == null) {
                return this.setCellValue(row, column, "");
            }
            String title = topic.getTitleText().replaceAll("\r|\n|\r\n", "  ");
            String numbering = ExportUtils.getNumberingText((ITopic)topic, (ITopic)this.getExporter().getCentralTopic());
            if (numbering != null) {
                title = String.valueOf(numbering) + " " + title;
            }
            Cell cell = this.setCellValue(row, column, title);
            int styleLevel = ((ISheet)this.getExporter().getSheet().getOwnedWorkbook().getSheets().get(this.sheetIndex)).getRootTopic().equals(topic) ? this.getTopicLevel() + 1 : this.getTopicLevel();
            this.setCellStyle(cell, styleLevel);
            Set labels = topic.getLabels();
            if (labels.size() != 0) {
                StringBuffer sb = new StringBuffer();
                String sp = "";
                for (String str : topic.getLabels()) {
                    sb.append(sp);
                    sb.append(str);
                    sp = ", ";
                }
                this.setComment(cell, sb.toString());
            }
            return cell;
        }

        protected void setComment(Cell cell, String value) {
            CommentCollection comments = cell.getWorksheet().getComments();
            Comment comment = comments.get(comments.add(cell.getRow(), cell.getColumn()));
            if (comment == null) {
                return;
            }
            comment.setAutoSize(true);
            comment.setNote(value);
        }
    }
}

