/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.command;

import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.Disposable;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandStackBase
extends Disposable
implements ICommandStack {
    public static int DEFAULT_UNDO_LIMIT = 20;
    private List<ICommandStackListener> commandStackListeners = null;
    private List<ICommandStackListener> pendingCommandStackListeners = null;
    private List<ICommandStackListener> toBeRemovedCommandStackListeners = null;
    private boolean inTransaction = false;
    private int undoLimit;

    public CommandStackBase(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    public CommandStackBase() {
        this(DEFAULT_UNDO_LIMIT);
    }

    @Override
    public void addCSListener(ICommandStackListener listener) {
        if (this.inTransaction) {
            if (this.pendingCommandStackListeners == null) {
                this.pendingCommandStackListeners = new ArrayList<ICommandStackListener>();
            }
            this.pendingCommandStackListeners.add(listener);
        } else {
            if (this.commandStackListeners == null) {
                this.commandStackListeners = new ArrayList<ICommandStackListener>();
            }
            this.commandStackListeners.add(listener);
        }
    }

    @Override
    public void removeCSListener(ICommandStackListener listener) {
        if (this.inTransaction) {
            if (this.toBeRemovedCommandStackListeners == null) {
                this.toBeRemovedCommandStackListeners = new ArrayList<ICommandStackListener>();
            }
            this.toBeRemovedCommandStackListeners.add(listener);
        } else if (this.commandStackListeners != null) {
            this.commandStackListeners.remove(listener);
        }
    }

    protected void beginTransaction() {
        this.inTransaction = true;
    }

    protected void endTransaction(Command command, int preStatus) {
        this.inTransaction = false;
        if (this.pendingCommandStackListeners != null && this.commandStackListeners != null) {
            this.commandStackListeners.addAll(this.pendingCommandStackListeners);
        }
        if (this.toBeRemovedCommandStackListeners != null) {
            for (ICommandStackListener toBeRemovedListener : this.toBeRemovedCommandStackListeners) {
                if (this.commandStackListeners != null) {
                    this.commandStackListeners.remove(toBeRemovedListener);
                }
                if (this.pendingCommandStackListeners == null) continue;
                this.pendingCommandStackListeners.remove(toBeRemovedListener);
            }
            this.toBeRemovedCommandStackListeners.clear();
            this.toBeRemovedCommandStackListeners = null;
        }
        if (this.pendingCommandStackListeners != null) {
            this.fireEvent(command, preStatus, this.pendingCommandStackListeners);
            this.pendingCommandStackListeners.clear();
            this.pendingCommandStackListeners = null;
        }
    }

    private void fireEvent(Command command, int preStatus, List<ICommandStackListener> pendingCommandStackListeners) {
        Object[] objectArray = pendingCommandStackListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ICommandStackListener)listener).handleCommandStackEvent(new CommandStackEvent(this, command, preStatus));
            ++n2;
        }
    }

    protected void fireEvent(int status) {
        if (this.commandStackListeners == null) {
            return;
        }
        this.fireEvent(new CommandStackEvent(this, status));
    }

    protected void fireEvent(Command cmd, int status) {
        if (this.commandStackListeners == null) {
            return;
        }
        this.fireEvent(new CommandStackEvent(this, cmd, status));
    }

    protected void fireEvent(CommandStackEvent event) {
        if (this.commandStackListeners == null) {
            return;
        }
        Object[] objectArray = this.commandStackListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ICommandStackListener)listener).handleCommandStackEvent(event);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        if (this.commandStackListeners != null) {
            this.commandStackListeners.clear();
            this.commandStackListeners = null;
        }
        this.clear();
        super.dispose();
    }

    @Override
    public int getUndoLimit() {
        return this.undoLimit;
    }

    @Override
    public void setUndoLimit(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    @Override
    public String getRepeatLabel() {
        return this.getUndoLabel();
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void repeat() {
    }

    @Override
    public void markSaved() {
    }

    @Override
    public boolean isDirty() {
        return this.canUndo();
    }
}

