/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.biggerplate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.program.Program;
import org.osgi.framework.Bundle;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.internal.XMindNetRequest;
import org.xmind.ui.biggerplate.BiggerplatePlugin;
import org.xmind.ui.internal.biggerplate.BiggerplateAPI;
import org.xmind.ui.internal.biggerplate.Info;
import org.xmind.ui.internal.biggerplate.jobs.CancelableJob;
import org.xmind.ui.internal.biggerplate.jobs.IJobClosedListener;
import org.xmind.ui.internal.biggerplate.utils.UrlUtils;

public final class BiggerplateOauth {
    public static final String PREFERENCE_STORE_REFRESH_TOKEN_KEY = "org.xmind.ui.biggerplate.preference.refreshToken";
    public static final String PREFERENCE_STORE_USERNAME_KEY = "org.xmind.ui.biggerplate.preference.username";
    private static final String AUTH_URL = "https://accounts.biggerplate.com/oauth/auth";
    private static final String TOKEN_URL = "https://accounts.biggerplate.com/oauth/token";
    private static final String CLIENT_ID = "AzdnpEQti5wqHQhoMj7JQn6D5gVmNvCdl5SiU2oN";
    private static final String CLIENT_SECRET = "XyDWoxJGJ8RZYocuE41MyVvYMF0uvYvUmVIRYfmN";
    private static final String DATA_ACCESS_TOKEN_KEY = "access_token";
    private static final String DATA_REFRESH_TOKEN_KEY = "refresh_token";
    private static final int REDIRECT_URI_PORT = 13524;
    private static final String REDIRECT_URI = "http://localhost:13524/";
    private static final String PATH = "pages/";
    private static ServerSocket server;

    public static String getAccessToken(Info info, CancelableJob job) {
        String refreshToken = BiggerplateOauth.getPreferenceStore().getString(PREFERENCE_STORE_REFRESH_TOKEN_KEY);
        if (refreshToken == null || refreshToken.equals("")) {
            BiggerplateOauth.generateAccessToken(info, job);
        } else {
            BiggerplateOauth.refreshAccessToken(refreshToken, info, job);
        }
        return info.getString("accessToken");
    }

    private static String getCode(final Info info, final CancelableJob job) {
        if (BiggerplateOauth.isJobCanceled(job)) {
            info.setBoolean("canceled", true);
            return null;
        }
        Program.launch((String)"https://accounts.biggerplate.com/oauth/auth?client_id=AzdnpEQti5wqHQhoMj7JQn6D5gVmNvCdl5SiU2oN&redirect_uri=http://localhost:13524/&response_type=code&scope=account+maps");
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (!BiggerplateOauth.prepare("https://accounts.biggerplate.com/oauth/auth?client_id=AzdnpEQti5wqHQhoMj7JQn6D5gVmNvCdl5SiU2oN&redirect_uri=http://localhost:13524/&response_type=code&scope=account+maps", job, info) && server != null && !server.isClosed()) {
                    try {
                        server.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (BiggerplateOauth.isJobCanceled(job)) {
            info.setBoolean("canceled", true);
            return null;
        }
        String code = null;
        Socket socket = null;
        BufferedReader br = null;
        try {
            server = new ServerSocket(13524);
            t.setDaemon(true);
            t.start();
            if (job != null) {
                job.addJobClosedListener(new IJobClosedListener(){

                    public void jobClosed() {
                        if (server != null && !server.isClosed()) {
                            try {
                                info.setBoolean("canceled", true);
                                server.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        job.removeJobClosedListener(this);
                    }
                });
            }
            socket = server.accept();
            br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String url = br.readLine();
            while (url != null) {
                code = UrlUtils.getParameter(url, "code");
                if (code != null) break;
                url = br.readLine();
            }
            BiggerplateOauth.writePageContent(socket);
            String string = code;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = code;
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                    br = null;
                }
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
                if (server != null) {
                    server.close();
                    server = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void writePageContent(Socket socket) {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(BiggerplateOauth.getFullFilePath("pages/info.html"))));
                bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                String line = br.readLine();
                while (line != null) {
                    bw.write(line);
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (bw != null) {
                        bw.flush();
                        bw.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.flush();
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean prepare(String permalink, final CancelableJob job, final Info info) {
        final XMindNetRequest request = new XMindNetRequest();
        request.uri(permalink);
        if (job != null) {
            job.addJobClosedListener(new IJobClosedListener(){

                public void jobClosed() {
                    if (request != null && request.isRunning()) {
                        info.setBoolean("canceled", true);
                        request.abort();
                    }
                    job.removeJobClosedListener(this);
                }
            });
        }
        request.get();
        int code = request.getStatusCode();
        return code == 200;
    }

    public static String generateAccessToken(Info info) {
        BiggerplateOauth.generateAccessToken(info, null);
        return info.getString("accessToken");
    }

    private static void generateAccessToken(final Info info, final CancelableJob job) {
        IDataStore data;
        String code = BiggerplateOauth.getCode(info, job);
        if (code == null) {
            if (!info.getBoolean("canceled")) {
                Program.launch((String)BiggerplateOauth.getFullFilePath("pages/fail.html"));
            }
            return;
        }
        if (BiggerplateOauth.isJobCanceled(job)) {
            info.setBoolean("canceled", true);
            return;
        }
        final XMindNetRequest request = new XMindNetRequest();
        request.uri(TOKEN_URL);
        request.addParameter("grant_type", (Object)"authorization_code");
        request.addParameter("code", (Object)code);
        request.addParameter("redirect_uri", (Object)REDIRECT_URI);
        request.addParameter("client_id", (Object)CLIENT_ID);
        request.addParameter("scope", (Object)"account+maps");
        request.addParameter("client_secret", (Object)CLIENT_SECRET);
        if (job != null) {
            job.addJobClosedListener(new IJobClosedListener(){

                public void jobClosed() {
                    if (request != null && request.isRunning()) {
                        info.setBoolean("canceled", true);
                        request.abort();
                    }
                    job.removeJobClosedListener(this);
                }
            });
        }
        request.post();
        Throwable e = request.getError();
        if (e != null) {
            e.printStackTrace();
        }
        if ((data = request.getData()) != null) {
            info.setProperty("accessToken", data.getString(DATA_ACCESS_TOKEN_KEY));
            String refreshToken = data.getString(DATA_REFRESH_TOKEN_KEY);
            if (refreshToken != null && !refreshToken.equals("")) {
                BiggerplateOauth.getPreferenceStore().setValue(PREFERENCE_STORE_REFRESH_TOKEN_KEY, data.getString(DATA_REFRESH_TOKEN_KEY));
                BiggerplateOauth.getPreferenceStore().setValue(PREFERENCE_STORE_USERNAME_KEY, BiggerplateAPI.getUsername(info));
            }
        }
        if (!info.getBoolean("canceled")) {
            String accessToken = info.getString("accessToken");
            if (accessToken != null && !accessToken.equals("")) {
                Program.launch((String)BiggerplateOauth.getFullFilePath("pages/success.html"));
            } else {
                Program.launch((String)BiggerplateOauth.getFullFilePath("pages/fail.html"));
            }
        }
    }

    private static String getFullFilePath(String path) {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui.biggerplate");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {}
        File file = new Path(url.getPath()).toFile();
        return file.getAbsolutePath();
    }

    private static void refreshAccessToken(String refreshToken, final Info info, final CancelableJob job) {
        if (BiggerplateOauth.isJobCanceled(job)) {
            info.setBoolean("canceled", true);
            return;
        }
        final XMindNetRequest request = new XMindNetRequest();
        request.uri(TOKEN_URL);
        request.addParameter("client_id", (Object)CLIENT_ID);
        request.addParameter("redirect_uri", (Object)REDIRECT_URI);
        request.addParameter("grant_type", (Object)DATA_REFRESH_TOKEN_KEY);
        request.addParameter("scope", (Object)"account+maps");
        request.addParameter("client_secret", (Object)CLIENT_SECRET);
        request.addParameter(DATA_REFRESH_TOKEN_KEY, (Object)refreshToken);
        if (job != null) {
            job.addJobClosedListener(new IJobClosedListener(){

                public void jobClosed() {
                    if (request != null && request.isRunning()) {
                        info.setBoolean("canceled", true);
                        request.abort();
                    }
                    job.removeJobClosedListener(this);
                }
            });
        }
        request.post();
        IDataStore data = request.getData();
        if (data != null) {
            String accessToken = data.getString(DATA_ACCESS_TOKEN_KEY);
            info.setProperty("accessToken", accessToken);
            if (accessToken != null && !accessToken.equals("")) {
                String newRefreshToken = data.getString(DATA_REFRESH_TOKEN_KEY);
                if (newRefreshToken != null && !newRefreshToken.equals("")) {
                    BiggerplateOauth.getPreferenceStore().setValue(PREFERENCE_STORE_REFRESH_TOKEN_KEY, newRefreshToken);
                    BiggerplateOauth.getPreferenceStore().setValue(PREFERENCE_STORE_USERNAME_KEY, BiggerplateAPI.getUsername(info));
                }
            } else {
                BiggerplateOauth.getPreferenceStore().setValue(PREFERENCE_STORE_REFRESH_TOKEN_KEY, "");
                BiggerplateOauth.getPreferenceStore().setValue(PREFERENCE_STORE_USERNAME_KEY, "");
                BiggerplateOauth.generateAccessToken(info, job);
            }
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return BiggerplatePlugin.getDefault().getPreferenceStore();
    }

    private static boolean isJobCanceled(CancelableJob job) {
        return job != null ? job.isCanceled() : false;
    }
}

