/* mgcFullength.h was originally generated by the autoSql program, which also 
 * generated mgcFullength.c and mgcFullength.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef MGCFULLENGTH_H
#define MGCFULLENGTH_H

#define MGCFULLENGTH_NUM_COLS 29

struct mgcFullength
/* table of fullength purified clones */
    {
    struct mgcFullength *next;  /* Next in singly linked list. */
    int id_clone;	/* MGC clone id */
    int id_vendor;	/* id of clone arrayer */
    char *plate;	/* plate id of clone */
    char *row;	/* row of clone */
    int col;	/* col of clone */
    int id_parent;	/* id of parent clone */
    char *clone_sent;	/* date sent out for sequencing */
    char *seq_back;	/* date sequence received */
    int id_sequencer;	/* id of clone sequencer */
    signed char seq_verified;	/* 5' and 3` sequence confirm 2=yes; 0=unknown, 1 = no, 3 = ambiguous */
    signed char colony_pure;	/* 1=no, 2=yes */
    int id_purif;	/* id of clone purifier */
    signed char full_length;	/* 1=no, 2=yes, 0 = unknown */
    char *gb_acc;	/* genbank accession */
    char *why_full;	/* reason for deciding if full length */
    signed char known;	/* known gene? 1=no 2 = yes */
    int cdstart;	/* start of coding region negative means incomplete; 0 at both start and stop means couldn't choose a CDS */
    int cdstop;	/* end of coding region */
    char *pr_acc;	/* protein accession */
    signed char dump_seq;	/* flag to dump entry, 1 = no, 2=dump to lukas in FASTA; 3 = dump to ASN.1 with CDS - complete, 4 = dump to ASN.1 with CDS - incomplete; 5 = dump to ASN.1 problem file without CDS */
    char *series;	/* plate series */
    char *organism;	/* organism name */
    signed char orient;	/* strand of CDS 1 = +ve, 0 = -ve */
    char *defline;	/* GenBank definition line */
    int locuslink;	/* locus link id for dbxref */
    signed char commnt;	/* comment about clone */
    signed char pass;	/* sequence quality */
    char *genesymbol;	/* NM accession */
    signed char by_indexer;	/* flag for hand annotation; 1=yes, null= no */
    };

void mgcFullengthStaticLoad(char **row, struct mgcFullength *ret);
/* Load a row from mgcFullength table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct mgcFullength *mgcFullengthLoad(char **row);
/* Load a mgcFullength from row fetched with select * from mgcFullength
 * from database.  Dispose of this with mgcFullengthFree(). */

struct mgcFullength *mgcFullengthLoadAll(char *fileName);
/* Load all mgcFullength from whitespace-separated file.
 * Dispose of this with mgcFullengthFreeList(). */

struct mgcFullength *mgcFullengthCommaIn(char **pS, struct mgcFullength *ret);
/* Create a mgcFullength out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mgcFullength */

void mgcFullengthFree(struct mgcFullength **pEl);
/* Free a single dynamically allocated mgcFullength such as created
 * with mgcFullengthLoad(). */

void mgcFullengthFreeList(struct mgcFullength **pList);
/* Free a list of dynamically allocated mgcFullength's */

void mgcFullengthOutput(struct mgcFullength *el, FILE *f, char sep, char lastSep);
/* Print out mgcFullength.  Separate fields with sep. Follow last field with lastSep. */

#define mgcFullengthTabOut(el,f) mgcFullengthOutput(el,f,'\t','\n');
/* Print out mgcFullength as a line in a tab-separated file. */

#define mgcFullengthCommaOut(el,f) mgcFullengthOutput(el,f,',',',');
/* Print out mgcFullength as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* MGCFULLENGTH_H */

