/* cogs.h was originally generated by the autoSql program, which also 
 * generated cogs.c and cogs.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef COGS_H
#define COGS_H

#define COG_NUM_COLS 3

struct COG
/* Clusters of Orthologous Genes */
    {
    struct COG *next;  /* Next in singly linked list. */
    char *name;	/* Name of item */
    char *COG;	/* COG name */
    char *code;	/* COG code */
    };

void COGStaticLoad(char **row, struct COG *ret);
/* Load a row from COG table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct COG *COGLoad(char **row);
/* Load a COG from row fetched with select * from COG
 * from database.  Dispose of this with COGFree(). */

struct COG *COGLoadAll(char *fileName);
/* Load all COG from whitespace-separated file.
 * Dispose of this with COGFreeList(). */

struct COG *COGLoadAllByChar(char *fileName, char chopper);
/* Load all COG from chopper separated file.
 * Dispose of this with COGFreeList(). */

#define COGLoadAllByTab(a) COGLoadAllByChar(a, '\t');
/* Load all COG from tab separated file.
 * Dispose of this with COGFreeList(). */

struct COG *COGCommaIn(char **pS, struct COG *ret);
/* Create a COG out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new COG */

void COGFree(struct COG **pEl);
/* Free a single dynamically allocated COG such as created
 * with COGLoad(). */

void COGFreeList(struct COG **pList);
/* Free a list of dynamically allocated COG's */

void COGOutput(struct COG *el, FILE *f, char sep, char lastSep);
/* Print out COG.  Separate fields with sep. Follow last field with lastSep. */

#define COGTabOut(el,f) COGOutput(el,f,'\t','\n');
/* Print out COG as a line in a tab-separated file. */

#define COGCommaOut(el,f) COGOutput(el,f,',',',');
/* Print out COG as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* COGS_H */

