/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.queue;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.installer.downloader.DownloadListener;
import org.netbeans.installer.downloader.Pumping;
import org.netbeans.installer.downloader.PumpingsQueue;
import org.netbeans.installer.downloader.impl.PumpingImpl;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.exceptions.UnexpectedExceptionError;
import org.netbeans.installer.utils.xml.DomUtil;
import org.netbeans.installer.utils.xml.visitors.RecursiveDomVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class QueueBase
implements PumpingsQueue {
    private static final WeakReference<DownloadListener>[] EMPTY_ARRAY = new WeakReference[0];
    private final List<WeakReference<DownloadListener>> listeners;
    protected final Map<String, PumpingImpl> id2Pumping = new HashMap<String, PumpingImpl>();
    protected File stateFile;

    protected QueueBase(File stateFile) {
        this.stateFile = stateFile;
        if (stateFile.exists()) {
            this.load();
            LogManager.log("queue state was load from file: " + stateFile);
        } else {
            LogManager.log("file not exist, queue is empty!");
        }
        this.listeners = new ArrayList<WeakReference<DownloadListener>>(3);
    }

    @Override
    public synchronized void addListener(DownloadListener listener) {
        if (!this.contains(listener)) {
            this.listeners.add(new WeakReference<DownloadListener>(listener));
        }
    }

    private boolean contains(DownloadListener listener) {
        for (WeakReference<DownloadListener> weak : this.listeners) {
            DownloadListener listen = (DownloadListener)weak.get();
            if (listen == null || !listen.equals(listener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Pumping getById(String id) {
        return this.id2Pumping.get(id);
    }

    @Override
    public Pumping[] toArray() {
        return this.id2Pumping.values().toArray(new Pumping[0]);
    }

    public void fire(String methodName, Object ... args) {
        ArrayList argsClasses = new ArrayList(args.length);
        for (Object arg : args) {
            argsClasses.add(arg.getClass());
        }
        try {
            Method method = DownloadListener.class.getMethod(methodName, argsClasses.toArray(new Class[0]));
            this.notifyListeners(method, args);
        }
        catch (NoSuchMethodException ex) {
            throw new UnexpectedExceptionError("Listener contract was changed", ex);
        }
    }

    private synchronized void notifyListeners(Method mehtod, Object ... args) {
        WeakReference<DownloadListener>[] stub;
        for (WeakReference<DownloadListener> ref : stub = this.listeners.toArray(EMPTY_ARRAY)) {
            DownloadListener listener = (DownloadListener)ref.get();
            if (listener == null) continue;
            try {
                mehtod.invoke((Object)listener, args);
            }
            catch (IllegalAccessException ignored) {
                LogManager.log(ignored);
            }
            catch (InvocationTargetException ignored) {
                LogManager.log(ignored);
            }
        }
    }

    protected void load() {
        try {
            Document queueState = DomUtil.parseXmlFile(this.stateFile);
            RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

                @Override
                public void visit(Element element) {
                    if ("pumping".equals(element.getNodeName())) {
                        PumpingImpl newOne = new PumpingImpl(QueueBase.this);
                        newOne.readXML(element);
                        QueueBase.this.id2Pumping.put(newOne.getId(), newOne);
                    } else {
                        super.visit(element);
                    }
                }
            };
            visitor.visit(queueState);
        }
        catch (ParseException ex) {
            LogManager.log("fail to load queue state - parsing error occurs");
        }
        catch (IOException ex) {
            LogManager.log("I/O error during loading. queue is empty now");
        }
    }

    public synchronized void dump() {
        try {
            Document document = DomUtil.parseXmlFile("<queueState/>");
            Element root = document.getDocumentElement();
            for (Pumping puming : this.toArray()) {
                DomUtil.addChild(root, (PumpingImpl)puming);
            }
            DomUtil.writeXmlFile(document, this.stateFile);
        }
        catch (ParseException wontHappend) {
            LogManager.log(wontHappend);
        }
        catch (IOException io) {
            LogManager.log("fail to dump - i/o error occures");
            LogManager.log(io);
        }
    }
}

