/*
 * Decompiled with CFR 0.152.
 */
package spin.over;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import spin.over.EDTRuleViolation;

public class CheckingRepaintManager
extends RepaintManager {
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkEDTRule(component);
        super.addInvalidComponent(component);
    }

    public synchronized void addDirtyRegion(JComponent component, int x, int y, int w, int h2) {
        this.checkEDTRule(component);
        super.addDirtyRegion(component, x, y, w, h2);
    }

    protected void checkEDTRule(Component component) {
        if (this.violatesEDTRule(component)) {
            EDTRuleViolation violation = new EDTRuleViolation(component);
            StackTraceElement[] stackTrace = violation.getStackTrace();
            try {
                for (int e = stackTrace.length - 1; e >= 0; --e) {
                    if (!this.isLiableToEDTRule(stackTrace[e])) continue;
                    StackTraceElement[] subStackTrace = new StackTraceElement[stackTrace.length - e];
                    System.arraycopy(stackTrace, e, subStackTrace, 0, subStackTrace.length);
                    violation.setStackTrace(subStackTrace);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.indicate(violation);
        }
    }

    protected boolean violatesEDTRule(Component component) {
        return !SwingUtilities.isEventDispatchThread() && component.isShowing();
    }

    protected boolean isLiableToEDTRule(StackTraceElement element) throws Exception {
        return Component.class.isAssignableFrom(Class.forName(element.getClassName()));
    }

    protected void indicate(EDTRuleViolation violation) throws EDTRuleViolation {
        throw violation;
    }
}

