/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import org.reactfx.Subscription;
import org.reactfx.value.ValBase;

class ValWrapper<T, D extends ObservableValue<T>>
extends ValBase<T> {
    private final D delegate;

    ValWrapper(D delegate) {
        this.delegate = delegate;
    }

    D getDelegate() {
        return this.delegate;
    }

    @Override
    protected Subscription connect() {
        InvalidationListener listener = obs -> this.invalidate();
        this.delegate.addListener(listener);
        return () -> this.delegate.removeListener(listener);
    }

    @Override
    protected T computeValue() {
        return (T)this.delegate.getValue();
    }
}

