/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.model.metadata.ContentSelector;

public class ContentSelectors {
    private final List<ContentSelector> contentSelectors = new ArrayList<ContentSelector>();

    public void addContentSelector(ContentSelector contentSelector) {
        Objects.requireNonNull(contentSelector);
        this.contentSelectors.add(contentSelector);
    }

    public List<String> getSelectorValuesForField(String fieldName) {
        for (ContentSelector selector : this.contentSelectors) {
            if (!selector.getFieldName().equals(fieldName)) continue;
            return selector.getValues();
        }
        return Collections.emptyList();
    }

    public void removeSelector(String fieldName) {
        ContentSelector toRemove = null;
        for (ContentSelector selector : this.contentSelectors) {
            if (!selector.getFieldName().equals(fieldName)) continue;
            toRemove = selector;
            break;
        }
        if (toRemove != null) {
            this.contentSelectors.remove(toRemove);
        }
    }

    public List<ContentSelector> getContentSelectors() {
        return Collections.unmodifiableList(this.contentSelectors);
    }

    public static ContentSelector parse(String key, String values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(values);
        List<String> valueList = Arrays.asList(values.split(";"));
        return new ContentSelector(key, valueList);
    }

    public List<String> getFieldNamesWithSelectors() {
        ArrayList<String> result = new ArrayList<String>(this.contentSelectors.size());
        for (ContentSelector selector : this.contentSelectors) {
            result.add(selector.getFieldName());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentSelectors that = (ContentSelectors)o;
        return Objects.equals(this.contentSelectors, that.contentSelectors);
    }

    public int hashCode() {
        return Objects.hash(this.contentSelectors);
    }
}

