/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Properties;
import org.jabref.logic.util.Version;

public class BuildInfo {
    public static final String UNKNOWN_VERSION = "*unknown*";
    public static final String OS = System.getProperty("os.name", "*unknown*");
    public static final String OS_VERSION = System.getProperty("os.version", "*unknown*").toLowerCase(Locale.ROOT);
    public static final String OS_ARCH = System.getProperty("os.arch", "*unknown*").toLowerCase(Locale.ROOT);
    public static final String JAVA_VERSION = System.getProperty("java.version", "*unknown*").toLowerCase(Locale.ROOT);
    private final Version version;
    private final String authors;
    private final String developers;
    private final String year;
    private final String azureInstrumentationKey;
    private final String minRequiredJavaVersion;
    private final boolean allowJava9;

    public BuildInfo() {
        this("/build.properties");
    }

    public BuildInfo(String path) {
        Properties properties;
        block13: {
            properties = new Properties();
            try (InputStream stream = BuildInfo.class.getResourceAsStream(path);){
                if (stream == null) break block13;
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.version = Version.parse(properties.getProperty("version"));
        this.authors = properties.getProperty("authors", "");
        this.year = properties.getProperty("year", "");
        this.developers = properties.getProperty("developers", "");
        this.azureInstrumentationKey = properties.getProperty("azureInstrumentationKey", "");
        this.minRequiredJavaVersion = properties.getProperty("minRequiredJavaVersion", "1.8");
        this.allowJava9 = "true".equals(properties.getProperty("allowJava9", ""));
    }

    public Version getVersion() {
        return this.version;
    }

    public String getAuthors() {
        return this.authors;
    }

    public String getDevelopers() {
        return this.developers;
    }

    public String getYear() {
        return this.year;
    }

    public String getAzureInstrumentationKey() {
        return this.azureInstrumentationKey;
    }

    public String getMinRequiredJavaVersion() {
        return this.minRequiredJavaVersion;
    }

    public boolean isAllowJava9() {
        return this.allowJava9;
    }
}

