/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class BibtexKeyDuplicationChecker
implements IntegrityCheck.Checker {
    private final BibDatabase database;

    public BibtexKeyDuplicationChecker(BibDatabase database) {
        this.database = Objects.requireNonNull(database);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        boolean isDuplicate = this.database.getDuplicationChecker().isDuplicateCiteKeyExisting(entry);
        if (isDuplicate) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("Duplicate BibTeX key", new String[0]), entry, "key"));
        }
        return Collections.emptyList();
    }
}

