/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;

public class BibStringChecker
implements IntegrityCheck.Checker {
    private static final Pattern UNESCAPED_HASH = Pattern.compile("(?<!\\\\)#|^#");

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> results = new ArrayList<IntegrityMessage>();
        Map<String, String> fields = entry.getFieldMap();
        for (Map.Entry<String, String> field2 : fields.entrySet()) {
            if (InternalBibtexFields.getFieldProperties(field2.getKey()).contains((Object)FieldProperty.VERBATIM)) continue;
            Matcher hashMatcher = UNESCAPED_HASH.matcher(field2.getValue());
            int hashCount = 0;
            while (hashMatcher.find()) {
                ++hashCount;
            }
            if ((hashCount & 1) != 1) continue;
            results.add(new IntegrityMessage(Localization.lang("odd number of unescaped '#'", new String[0]), entry, field2.getKey()));
        }
        return results;
    }
}

