/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;

public class OvidImporter
extends Importer {
    private static final Pattern OVID_SOURCE_PATTERN = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+)\\(([\\w\\-]+)\\):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern OVID_SOURCE_PATTERN_NO_ISSUE = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern OVID_SOURCE_PATTERN_2 = Pattern.compile("([ \\w&\\-,]+)\\. Vol ([0-9]+)\\(([\\w\\-]+)\\) ([A-Za-z]+) ([0-9][0-9][0-9][0-9]), ([0-9]+\\-?[0-9]+)");
    private static final Pattern INCOLLECTION_PATTERN = Pattern.compile("(.+)\\(([0-9][0-9][0-9][0-9])\\)\\. ([ \\w&\\-,:]+)\\.[ ]+\\(pp. ([0-9]+\\-?[0-9]+?)\\).[A-Za-z0-9, ]+pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final Pattern BOOK_PATTERN = Pattern.compile("\\(([0-9][0-9][0-9][0-9])\\)\\. [A-Za-z, ]+([0-9]+) pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final String OVID_PATTERN_STRING = "<[0-9]+>";
    private static final Pattern OVID_PATTERN = Pattern.compile("<[0-9]+>");
    private static final int MAX_ITEMS = 50;

    @Override
    public String getName() {
        return "Ovid";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getDescription() {
        return "Imports an Ovid file.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
            if (!OVID_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String line;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (!line.isEmpty() && line.charAt(0) != ' ') {
                sb.append("__NEWFIELD__");
            }
            sb.append(line);
            sb.append('\n');
        }
        String[] items = sb.toString().split(OVID_PATTERN_STRING);
        for (int i = 1; i < items.length; ++i) {
            String[] fields;
            HashMap<String, String> h2 = new HashMap<String, String>();
            for (String field2 : fields = items[i].split("__NEWFIELD__")) {
                boolean isAuthor;
                int linebreak = field2.indexOf(10);
                String fieldName = field2.substring(0, linebreak).trim();
                String content = field2.substring(linebreak).trim();
                boolean bl = isAuthor = fieldName.indexOf("Author") == 0 && !fieldName.contains("Author Keywords") && !fieldName.contains("Author e-mail");
                if (!isAuthor && content.endsWith(".")) {
                    content = content.substring(0, content.length() - 1);
                }
                if (isAuthor) {
                    h2.put("author", content);
                    continue;
                }
                if (fieldName.startsWith("Title")) {
                    if ((content = content.replaceAll("\\[.+\\]", "").trim()).endsWith(".")) {
                        content = content.substring(0, content.length() - 1);
                    }
                    h2.put("title", content);
                    continue;
                }
                if (fieldName.startsWith("Chapter Title")) {
                    h2.put("chaptertitle", content);
                    continue;
                }
                if (fieldName.startsWith("Source")) {
                    Matcher matcher = OVID_SOURCE_PATTERN.matcher(content);
                    if (matcher.find()) {
                        h2.put("journal", matcher.group(1));
                        h2.put("volume", matcher.group(2));
                        h2.put("issue", matcher.group(3));
                        h2.put("pages", matcher.group(4));
                        h2.put("year", matcher.group(5));
                    } else {
                        matcher = OVID_SOURCE_PATTERN_NO_ISSUE.matcher(content);
                        if (matcher.find()) {
                            h2.put("journal", matcher.group(1));
                            h2.put("volume", matcher.group(2));
                            h2.put("pages", matcher.group(3));
                            h2.put("year", matcher.group(4));
                        } else {
                            matcher = OVID_SOURCE_PATTERN_2.matcher(content);
                            if (matcher.find()) {
                                h2.put("journal", matcher.group(1));
                                h2.put("volume", matcher.group(2));
                                h2.put("issue", matcher.group(3));
                                h2.put("month", matcher.group(4));
                                h2.put("year", matcher.group(5));
                                h2.put("pages", matcher.group(6));
                            } else {
                                matcher = INCOLLECTION_PATTERN.matcher(content);
                                if (matcher.find()) {
                                    h2.put("editor", matcher.group(1).replace(" (Ed)", ""));
                                    h2.put("year", matcher.group(2));
                                    h2.put("booktitle", matcher.group(3));
                                    h2.put("pages", matcher.group(4));
                                    h2.put("address", matcher.group(5));
                                    h2.put("publisher", matcher.group(6));
                                } else {
                                    matcher = BOOK_PATTERN.matcher(content);
                                    if (matcher.find()) {
                                        h2.put("year", matcher.group(1));
                                        h2.put("pages", matcher.group(2));
                                        h2.put("address", matcher.group(3));
                                        h2.put("publisher", matcher.group(4));
                                    }
                                }
                            }
                        }
                    }
                    if (h2.get("pages") == null) continue;
                    h2.put("pages", ((String)h2.get("pages")).replace("-", "--"));
                    continue;
                }
                if ("Abstract".equals(fieldName)) {
                    h2.put("abstract", content);
                    continue;
                }
                if ("Publication Type".equals(fieldName)) {
                    if (content.contains("Book")) {
                        h2.put("entrytype", "book");
                        continue;
                    }
                    if (content.contains("Journal")) {
                        h2.put("entrytype", "article");
                        continue;
                    }
                    if (!content.contains("Conference Paper")) continue;
                    h2.put("entrytype", "inproceedings");
                    continue;
                }
                if (fieldName.startsWith("Language")) {
                    h2.put("language", content);
                    continue;
                }
                if (fieldName.startsWith("Author Keywords")) {
                    content = content.replace(";", ",").replace("  ", " ");
                    h2.put("keywords", content);
                    continue;
                }
                if (fieldName.startsWith("ISSN")) {
                    h2.put("issn", content);
                    continue;
                }
                if (!fieldName.startsWith("DOI Number")) continue;
                h2.put("doi", content);
            }
            String auth = (String)h2.get("author");
            if (auth != null && auth.contains(" [Ed]")) {
                h2.remove("author");
                h2.put("editor", auth.replace(" [Ed]", ""));
            }
            if ((auth = (String)h2.get("author")) != null) {
                h2.put("author", OvidImporter.fixNames(auth));
            }
            if ((auth = (String)h2.get("editor")) != null) {
                h2.put("editor", OvidImporter.fixNames(auth));
            }
            String entryType = h2.containsKey("entrytype") ? (String)h2.get("entrytype") : "misc";
            h2.remove("entrytype");
            if ("book".equals(entryType) && h2.containsKey("chaptertitle")) {
                entryType = "incollection";
                h2.put("title", (String)h2.remove("chaptertitle"));
            }
            BibEntry b = new BibEntry(entryType);
            b.setField(h2);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }

    private static String fixNames(String content) {
        String names;
        if (content.indexOf(59) > 0) {
            names = content.replaceAll("[^\\.A-Za-z,;\\- ]", "").replace(";", " and");
        } else if (content.indexOf("  ") > 0) {
            String[] sNames = content.split("  ");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sNames.length; ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                sb.append(sNames[i].replaceFirst(" ", ", "));
            }
            names = sb.toString();
        } else {
            names = content;
        }
        return AuthorList.fixAuthorLastNameFirst(names);
    }
}

