/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;

public class CopacImporter
extends Importer {
    private static final Pattern COPAC_PATTERN = Pattern.compile("^\\s*TI- ");

    @Override
    public String getName() {
        return "Copac";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getId() {
        return "cpc";
    }

    @Override
    public String getDescription() {
        return "Importer for COPAC format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!COPAC_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        Objects.requireNonNull(reader);
        LinkedList<String> entries = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 4) continue;
            String code = str.substring(0, 4);
            if ("    ".equals(code)) {
                sb.append(' ').append(str.trim());
                continue;
            }
            if ("TI- ".equals(str.substring(0, 4))) {
                if (sb.length() > 0) {
                    entries.add(sb.toString());
                }
                sb = new StringBuilder();
            }
            sb.append('\n').append(str);
        }
        if (sb.length() > 0) {
            entries.add(sb.toString());
        }
        LinkedList<BibEntry> results = new LinkedList<BibEntry>();
        for (String entry : entries) {
            String[] lines;
            BibEntry b = new BibEntry("book");
            for (String line1 : lines = entry.split("\n")) {
                String line = line1.trim();
                if (line.length() < 4) continue;
                String code = line.substring(0, 4);
                if ("TI- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "title", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("AU- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "author", line.substring(4).trim(), " and ");
                    continue;
                }
                if ("PY- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "year", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("PU- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "publisher", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("SE- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "series", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("IS- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "isbn", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("KW- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "keywords", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("NT- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "note", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("PD- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "physicaldimensions", line.substring(4).trim(), ", ");
                    continue;
                }
                if ("DT- ".equals(code)) {
                    CopacImporter.setOrAppend(b, "documenttype", line.substring(4).trim(), ", ");
                    continue;
                }
                CopacImporter.setOrAppend(b, code.substring(0, 2), line.substring(4).trim(), ", ");
            }
            results.add(b);
        }
        return new ParserResult(results);
    }

    private static void setOrAppend(BibEntry b, String field2, String value, String separator) {
        if (b.hasField(field2)) {
            b.setField(field2, b.getField(field2).get() + separator + value);
        } else {
            b.setField(field2, value);
        }
    }
}

