/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.scene.text.Text;

public class TooltipTextUtil {
    public static Text createText(String textString, TextType textType) {
        Text text = new Text(textString);
        switch (textType) {
            case BOLD: {
                text.getStyleClass().setAll((Object[])new String[]{"tooltip-text-bold"});
                break;
            }
            case ITALIC: {
                text.getStyleClass().setAll((Object[])new String[]{"tooltip-text-italic"});
                break;
            }
            case MONOSPACED: {
                text.getStyleClass().setAll((Object[])new String[]{"tooltip-text-monospaced"});
                break;
            }
        }
        return text;
    }

    public static Text createText(String textString) {
        return TooltipTextUtil.createText(textString, TextType.NORMAL);
    }

    public static String textToHTMLString(Text text) {
        String textString = text.getText();
        textString = textString.replace("\n", "<br>");
        if (text.getStyleClass().toString().contains("tooltip-text-monospaced")) {
            textString = String.format("<kbd>%s</kbd>", textString);
        }
        if (text.getStyleClass().toString().contains("tooltip-text-bold")) {
            textString = String.format("<b>%s</b>", textString);
        }
        if (text.getStyleClass().toString().contains("tooltip-text-italic")) {
            textString = String.format("<i>%s</i>", textString);
        }
        return textString;
    }

    public static List<Text> formatToTexts(String original, TextReplacement ... replacements) {
        ArrayList<Text> textList = new ArrayList<Text>();
        textList.add(new Text(original));
        for (TextReplacement replacement : replacements) {
            TooltipTextUtil.splitReplace(textList, replacement);
        }
        return textList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void splitReplace(List<Text> textList, TextReplacement replacement) {
        Optional<Text> textContainingReplacement = textList.stream().filter(it -> it.getText().contains(replacement.toReplace)).findFirst();
        if (!textContainingReplacement.isPresent()) throw new IllegalStateException("It is not allowed that the toReplace string: '" + replacement.toReplace + "' does not exist in the original string");
        int index = textList.indexOf(textContainingReplacement.get());
        String original = textContainingReplacement.get().getText();
        textList.remove(index);
        String[] textParts = original.split(replacement.toReplace);
        if (textParts.length == 2) {
            if (textParts[0].equals("")) {
                textList.add(index, TooltipTextUtil.createText(replacement.replacement, replacement.textType));
                textList.add(index + 1, TooltipTextUtil.createText(textParts[1], TextType.NORMAL));
                return;
            } else {
                textList.add(index, TooltipTextUtil.createText(textParts[0], TextType.NORMAL));
                textList.add(index + 1, TooltipTextUtil.createText(replacement.replacement, replacement.textType));
                textList.add(index + 2, TooltipTextUtil.createText(textParts[1], TextType.NORMAL));
            }
            return;
        } else {
            if (textParts.length != 1) throw new IllegalStateException("It is not allowed that the toReplace string: '" + replacement.toReplace + "' exists multiple times in the original string");
            textList.add(index, TooltipTextUtil.createText(textParts[0], TextType.NORMAL));
            textList.add(index + 1, TooltipTextUtil.createText(replacement.replacement, replacement.textType));
        }
    }

    public static class TextReplacement {
        private final String toReplace;
        private final String replacement;
        private final TextType textType;

        public TextReplacement(String toReplace, String replacement, TextType textType) {
            this.toReplace = toReplace;
            this.replacement = replacement;
            this.textType = textType;
        }
    }

    public static enum TextType {
        NORMAL,
        BOLD,
        ITALIC,
        MONOSPACED;

    }
}

