/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyExistException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.SidePaneComponent;
import org.jabref.gui.SidePaneManager;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.openoffice.AdvancedCiteDialog;
import org.jabref.gui.openoffice.BibEntryNotFoundException;
import org.jabref.gui.openoffice.CitationManager;
import org.jabref.gui.openoffice.ConnectionLostException;
import org.jabref.gui.openoffice.CreationException;
import org.jabref.gui.openoffice.DetectOpenOfficeInstallation;
import org.jabref.gui.openoffice.NoDocumentException;
import org.jabref.gui.openoffice.OOBibBase;
import org.jabref.gui.openoffice.OpenOfficeSidePanel;
import org.jabref.gui.openoffice.StyleSelectDialog;
import org.jabref.gui.openoffice.UndefinedCharacterFormatException;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableKeyChange;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.bibtexkeypattern.BibtexKeyPatternPreferences;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.OOBibStyle;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.openoffice.StyleLoader;
import org.jabref.logic.openoffice.UndefinedParagraphFormatException;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.Defaults;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficePanel
extends AbstractWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenOfficePanel.class);
    private OpenOfficeSidePanel sidePane;
    private JDialog diag;
    private final JButton connect;
    private final JButton manualConnect;
    private final JButton selectDocument;
    private final JButton setStyleFile = new JButton(Localization.lang("Select style", new String[0]));
    private final JButton pushEntries = new JButton(Localization.lang("Cite", new String[0]));
    private final JButton pushEntriesInt = new JButton(Localization.lang("Cite in-text", new String[0]));
    private final JButton pushEntriesEmpty = new JButton(Localization.lang("Insert empty citation", new String[0]));
    private final JButton pushEntriesAdvanced = new JButton(Localization.lang("Cite special", new String[0]));
    private final JButton update;
    private final JButton merge = new JButton(Localization.lang("Merge citations", new String[0]));
    private final JButton manageCitations = new JButton(Localization.lang("Manage citations", new String[0]));
    private final JButton exportCitations = new JButton(Localization.lang("Export cited", new String[0]));
    private final JButton settingsB = new JButton(Localization.lang("Settings", new String[0]));
    private final JButton help = new HelpAction(Localization.lang("OpenOffice/LibreOffice integration", new String[0]), HelpFile.OPENOFFICE_LIBREOFFICE).getHelpButton();
    private OOBibBase ooBase;
    private JabRefFrame frame;
    private OOBibStyle style;
    private StyleSelectDialog styleDialog;
    private boolean dialogOkPressed;
    private IOException connectException;
    private final OpenOfficePreferences preferences;
    private final StyleLoader loader;

    public OpenOfficePanel(JabRefFrame jabRefFrame, SidePaneManager spManager) {
        IconTheme.FontBasedIcon connectImage = IconTheme.JabRefIcon.CONNECT_OPEN_OFFICE.getSmallIcon();
        this.connect = new JButton(connectImage);
        this.manualConnect = new JButton(connectImage);
        this.connect.setToolTipText(Localization.lang("Connect", new String[0]));
        this.manualConnect.setToolTipText(Localization.lang("Manual connect", new String[0]));
        this.connect.setPreferredSize(new Dimension(24, 24));
        this.manualConnect.setPreferredSize(new Dimension(24, 24));
        this.selectDocument = new JButton(IconTheme.JabRefIcon.OPEN.getSmallIcon());
        this.selectDocument.setToolTipText(Localization.lang("Select Writer document", new String[0]));
        this.selectDocument.setPreferredSize(new Dimension(24, 24));
        this.update = new JButton(IconTheme.JabRefIcon.REFRESH.getSmallIcon());
        this.update.setToolTipText(Localization.lang("Sync OpenOffice/LibreOffice bibliography", new String[0]));
        this.update.setPreferredSize(new Dimension(24, 24));
        this.preferences = Globals.prefs.getOpenOfficePreferences();
        this.loader = new StyleLoader(this.preferences, Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader), Globals.prefs.getDefaultEncoding());
        this.frame = jabRefFrame;
        this.sidePane = new OpenOfficeSidePanel(spManager, IconTheme.getImage("openoffice"), "OpenOffice/LibreOffice", this.preferences);
        this.initPanel();
        spManager.register(this.sidePane);
    }

    private void initPanel() {
        this.connect.addActionListener(e -> this.connect(true));
        this.manualConnect.addActionListener(e -> this.connect(false));
        this.selectDocument.setToolTipText(Localization.lang("Select which open Writer document to work on", new String[0]));
        this.selectDocument.addActionListener(e -> {
            try {
                this.ooBase.selectDocument();
                this.frame.output(Localization.lang("Connected to document", new String[0]) + ": " + this.ooBase.getCurrentDocumentTitle().orElse(""));
            }
            catch (UnknownPropertyException | NoSuchElementException | WrappedTargetException | IndexOutOfBoundsException | NoDocumentException ex) {
                JOptionPane.showMessageDialog(this.frame, ex.getMessage(), Localization.lang("Error", new String[0]), 0);
                LOGGER.warn("Problem connecting", ex);
            }
        });
        this.setStyleFile.addActionListener(event -> {
            if (this.styleDialog == null) {
                this.styleDialog = new StyleSelectDialog(this.frame, this.preferences, this.loader);
            }
            this.styleDialog.setVisible(true);
            this.styleDialog.getStyle().ifPresent(selectedStyle -> {
                this.style = selectedStyle;
                try {
                    this.style.ensureUpToDate();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to reload style file '" + this.style.getPath() + "'", e);
                }
                this.frame.setStatus(Localization.lang("Current style is '%0'", this.style.getName()));
            });
        });
        this.pushEntries.setToolTipText(Localization.lang("Cite selected entries between parenthesis", new String[0]));
        this.pushEntries.addActionListener(e -> this.pushEntries(true, true, false));
        this.pushEntriesInt.setToolTipText(Localization.lang("Cite selected entries with in-text citation", new String[0]));
        this.pushEntriesInt.addActionListener(e -> this.pushEntries(false, true, false));
        this.pushEntriesEmpty.setToolTipText(Localization.lang("Insert a citation without text (the entry will appear in the reference list)", new String[0]));
        this.pushEntriesEmpty.addActionListener(e -> this.pushEntries(false, false, false));
        this.pushEntriesAdvanced.setToolTipText(Localization.lang("Cite selected entries with extra information", new String[0]));
        this.pushEntriesAdvanced.addActionListener(e -> this.pushEntries(false, true, true));
        this.update.setToolTipText(Localization.lang("Ensure that the bibliography is up-to-date", new String[0]));
        AbstractAction updateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (OpenOfficePanel.this.style == null) {
                        OpenOfficePanel.this.style = OpenOfficePanel.this.loader.getUsedStyle();
                    } else {
                        OpenOfficePanel.this.style.ensureUpToDate();
                    }
                    OpenOfficePanel.this.ooBase.updateSortedReferenceMarks();
                    List databases = OpenOfficePanel.this.getBaseList();
                    List<String> unresolvedKeys = OpenOfficePanel.this.ooBase.refreshCiteMarkers(databases, OpenOfficePanel.this.style);
                    OpenOfficePanel.this.ooBase.rebuildBibTextSection(databases, OpenOfficePanel.this.style);
                    if (!unresolvedKeys.isEmpty()) {
                        JOptionPane.showMessageDialog(OpenOfficePanel.this.frame, Localization.lang("Your OpenOffice/LibreOffice document references the BibTeX key '%0', which could not be found in your current library.", unresolvedKeys.get(0)), Localization.lang("Unable to synchronize bibliography", new String[0]), 0);
                    }
                }
                catch (UndefinedCharacterFormatException ex) {
                    OpenOfficePanel.this.reportUndefinedCharacterFormat(ex);
                }
                catch (UndefinedParagraphFormatException ex) {
                    OpenOfficePanel.this.reportUndefinedParagraphFormat(ex);
                }
                catch (ConnectionLostException ex) {
                    OpenOfficePanel.this.showConnectionLostErrorMessage();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(OpenOfficePanel.this.frame, Localization.lang("You must select either a valid style file, or use one of the default styles.", new String[0]), Localization.lang("No valid style file defined", new String[0]), 0);
                    LOGGER.warn("Problem with style file", ex);
                }
                catch (BibEntryNotFoundException ex) {
                    JOptionPane.showMessageDialog(OpenOfficePanel.this.frame, Localization.lang("Your OpenOffice/LibreOffice document references the BibTeX key '%0', which could not be found in your current library.", ex.getBibtexKey()), Localization.lang("Unable to synchronize bibliography", new String[0]), 0);
                    LOGGER.debug("BibEntry not found", ex);
                }
                catch (PropertyVetoException | UnknownPropertyException | NoSuchElementException | IllegalArgumentException | WrappedTargetException | CreationException ex) {
                    LOGGER.warn("Could not update bibliography", ex);
                }
            }
        };
        this.update.addActionListener(updateAction);
        this.merge.setToolTipText(Localization.lang("Combine pairs of citations that are separated by spaces only", new String[0]));
        this.merge.addActionListener(e -> {
            try {
                this.ooBase.combineCiteMarkers(this.getBaseList(), this.style);
            }
            catch (UndefinedCharacterFormatException ex) {
                this.reportUndefinedCharacterFormat(ex);
            }
            catch (PropertyVetoException | UnknownPropertyException | NoSuchElementException | IllegalArgumentException | WrappedTargetException | IOException | BibEntryNotFoundException | CreationException ex) {
                LOGGER.warn("Problem combining cite markers", ex);
            }
        });
        this.settingsB.addActionListener(e -> this.showSettingsPopup());
        this.manageCitations.addActionListener(e -> {
            try {
                CitationManager cm = new CitationManager(this.frame, this.ooBase);
                cm.showDialog();
            }
            catch (UnknownPropertyException | NoSuchElementException | WrappedTargetException ex) {
                LOGGER.warn("Problem showing citation manager", ex);
            }
        });
        this.exportCitations.addActionListener(event -> this.exportEntries());
        this.selectDocument.setEnabled(false);
        this.pushEntries.setEnabled(false);
        this.pushEntriesInt.setEnabled(false);
        this.pushEntriesEmpty.setEnabled(false);
        this.pushEntriesAdvanced.setEnabled(false);
        this.update.setEnabled(false);
        this.merge.setEnabled(false);
        this.manageCitations.setEnabled(false);
        this.exportCitations.setEnabled(false);
        this.diag = new JDialog((Frame)null, "OpenOffice/LibreOffice panel", false);
        FormBuilder mainBuilder = FormBuilder.create().layout(new FormLayout("fill:pref:grow", "p,p,p,p,p,p,p,p,p,p,p"));
        FormBuilder topRowBuilder = FormBuilder.create().layout(new FormLayout("fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref", "pref"));
        topRowBuilder.add(this.connect).xy(1, 1);
        topRowBuilder.add(this.manualConnect).xy(3, 1);
        topRowBuilder.add(this.selectDocument).xy(5, 1);
        topRowBuilder.add(this.update).xy(7, 1);
        topRowBuilder.add(this.help).xy(9, 1);
        mainBuilder.add(topRowBuilder.getPanel()).xy(1, 1);
        mainBuilder.add(this.setStyleFile).xy(1, 2);
        mainBuilder.add(this.pushEntries).xy(1, 3);
        mainBuilder.add(this.pushEntriesInt).xy(1, 4);
        mainBuilder.add(this.pushEntriesAdvanced).xy(1, 5);
        mainBuilder.add(this.pushEntriesEmpty).xy(1, 6);
        mainBuilder.add(this.merge).xy(1, 7);
        mainBuilder.add(this.manageCitations).xy(1, 8);
        mainBuilder.add(this.exportCitations).xy(1, 9);
        mainBuilder.add(this.settingsB).xy(1, 10);
        JPanel content = new JPanel();
        this.sidePane.setContentContainer(content);
        content.setLayout(new BorderLayout());
        content.add((Component)mainBuilder.getPanel(), "Center");
        this.frame.getTabbedPane().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.REFRESH_OO), "Refresh OO");
        this.frame.getTabbedPane().getActionMap().put("Refresh OO", updateAction);
    }

    private void exportEntries() {
        try {
            if (this.style == null) {
                this.style = this.loader.getUsedStyle();
            } else {
                this.style.ensureUpToDate();
            }
            this.ooBase.updateSortedReferenceMarks();
            List<BibDatabase> databases = this.getBaseList();
            List<String> unresolvedKeys = this.ooBase.refreshCiteMarkers(databases, this.style);
            BibDatabase newDatabase = this.ooBase.generateDatabase(databases);
            if (!unresolvedKeys.isEmpty()) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Your OpenOffice/LibreOffice document references the BibTeX key '%0', which could not be found in your current library.", unresolvedKeys.get(0)), Localization.lang("Unable to generate new library", new String[0]), 0);
            }
            Defaults defaults = new Defaults(Globals.prefs.getDefaultBibDatabaseMode());
            BibDatabaseContext databaseContext = new BibDatabaseContext(newDatabase, defaults);
            this.frame.addTab(databaseContext, true);
        }
        catch (BibEntryNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Your OpenOffice/LibreOffice document references the BibTeX key '%0', which could not be found in your current library.", ex.getBibtexKey()), Localization.lang("Unable to synchronize bibliography", new String[0]), 0);
            LOGGER.debug("BibEntry not found", ex);
        }
        catch (PropertyVetoException | UnknownPropertyException | NoSuchElementException | IllegalArgumentException | WrappedTargetException | IOException | CreationException | UndefinedCharacterFormatException e) {
            LOGGER.warn("Problem generating new database.", e);
        }
    }

    private List<BibDatabase> getBaseList() {
        ArrayList<BibDatabase> databases = new ArrayList<BibDatabase>();
        if (this.preferences.getUseAllDatabases().booleanValue()) {
            for (BasePanel basePanel : this.frame.getBasePanelList()) {
                databases.add(basePanel.getDatabase());
            }
        } else {
            databases.add(this.frame.getCurrentBasePanel().getDatabase());
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(boolean autoDetect) {
        if (autoDetect) {
            DetectOpenOfficeInstallation officeInstallation = new DetectOpenOfficeInstallation(this.diag, this.preferences);
            if (!officeInstallation.isInstalled()) {
                JOptionPane.showMessageDialog(this.diag, Localization.lang("Autodetection failed", new String[0]), Localization.lang("Autodetection failed", new String[0]), 0);
                return;
            }
            this.diag.dispose();
        } else {
            this.showManualConnectionDialog();
            if (!this.dialogOkPressed) {
                return;
            }
        }
        Window progressDialog = null;
        try {
            this.loadOpenOfficeJars(Paths.get(this.preferences.getInstallationPath(), new String[0]));
            progressDialog = new DetectOpenOfficeInstallation(this.diag, this.preferences).showProgressDialog(this.diag, Localization.lang("Connecting", new String[0]), Localization.lang("Please wait...", new String[0]));
            this.getWorker().run();
            progressDialog.dispose();
            this.diag.dispose();
            if (this.ooBase == null) {
                throw this.connectException;
            }
            if (this.ooBase.isConnectedToDocument()) {
                this.frame.output(Localization.lang("Connected to document", new String[0]) + ": " + this.ooBase.getCurrentDocumentTitle().orElse(""));
            }
            this.selectDocument.setEnabled(true);
            this.pushEntries.setEnabled(true);
            this.pushEntriesInt.setEnabled(true);
            this.pushEntriesEmpty.setEnabled(true);
            this.pushEntriesAdvanced.setEnabled(true);
            this.update.setEnabled(true);
            this.merge.setEnabled(true);
            this.manageCitations.setEnabled(true);
            this.exportCitations.setEnabled(true);
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Could not connect to running OpenOffice/LibreOffice", e);
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Unable to connect. One possible reason is that JabRef and OpenOffice/LibreOffice are not both running in either 32 bit mode or 64 bit mode.", new String[0]));
        }
        catch (IOException e) {
            LOGGER.warn("Could not connect to running OpenOffice/LibreOffice", e);
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not connect to running OpenOffice/LibreOffice.", new String[0]) + "\n" + Localization.lang("Make sure you have installed OpenOffice/LibreOffice with Java support.", new String[0]) + "\n" + Localization.lang("If connecting manually, please verify program and library paths.", new String[0]) + "\n\n" + Localization.lang("Error message:", new String[0]) + " " + e.getMessage());
        }
        finally {
            if (progressDialog != null) {
                progressDialog.dispose();
            }
        }
    }

    private void loadOpenOfficeJars(Path configurationPath) throws IOException {
        List filePaths = OpenOfficePreferences.OO_JARS.stream().map(jar -> FileUtil.find(jar, configurationPath)).collect(Collectors.toList());
        if (!filePaths.stream().allMatch(Optional::isPresent)) {
            throw new IOException("(Not all) required Open Office Jars were found inside installation path.");
        }
        ArrayList<URL> jarURLs = new ArrayList<URL>(OpenOfficePreferences.OO_JARS.size());
        for (Optional jarPath : filePaths) {
            jarURLs.add(((Path)jarPath.get()).toUri().toURL());
        }
        OpenOfficePanel.addURL(jarURLs);
    }

    @Override
    public void run() {
        try {
            this.ooBase = new OOBibBase(this.preferences.getExecutablePath(), true);
        }
        catch (UnknownPropertyException | BootstrapException | NoSuchElementException | WrappedTargetException | IOException | IllegalAccessException | InvocationTargetException | CreationException | NoDocumentException e) {
            this.ooBase = null;
            this.connectException = new IOException(e.getMessage());
        }
    }

    private static void addURL(List<URL> jarList) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL anU : jarList) {
                method.invoke((Object)sysloader, anU);
            }
        }
        catch (IllegalAccessException | java.lang.IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error("Could not add URL to system classloader", e);
            throw new IOException("Error, could not add URL to system classloader", e);
        }
    }

    private void showManualConnectionDialog() {
        this.dialogOkPressed = false;
        JDialog cDiag = new JDialog(this.frame, Localization.lang("Set connection parameters", new String[0]), true);
        NativeDesktop nativeDesktop = JabRefDesktop.getNativeDesktop();
        FXDialogService dirDialog = new FXDialogService();
        DirectoryDialogConfiguration dirDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(nativeDesktop.getApplicationDirectory()).build();
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(nativeDesktop.getApplicationDirectory()).build();
        FXDialogService fileDialog = new FXDialogService();
        JTextField ooPath = new JTextField(30);
        JButton browseOOPath = new JButton(Localization.lang("Browse", new String[0]));
        ooPath.setText(this.preferences.getInstallationPath());
        browseOOPath.addActionListener(e -> DefaultTaskExecutor.runInJavaFXThread(() -> dirDialog.showDirectorySelectionDialog(dirDialogConfiguration)).ifPresent(f -> ooPath.setText(f.toAbsolutePath().toString())));
        JTextField ooExec = new JTextField(30);
        JButton browseOOExec = new JButton(Localization.lang("Browse", new String[0]));
        ooExec.setText(this.preferences.getExecutablePath());
        browseOOExec.addActionListener(e -> DefaultTaskExecutor.runInJavaFXThread(() -> fileDialog.showFileOpenDialog(fileDialogConfiguration)).ifPresent(f -> ooExec.setText(f.toAbsolutePath().toString())));
        JTextField ooJars = new JTextField(30);
        ooJars.setText(this.preferences.getJarsPath());
        JButton browseOOJars = new JButton(Localization.lang("Browse", new String[0]));
        browseOOJars.addActionListener(e -> DefaultTaskExecutor.runInJavaFXThread(() -> dirDialog.showDirectorySelectionDialog(dirDialogConfiguration)).ifPresent(f -> ooJars.setText(f.toAbsolutePath().toString())));
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:pref:grow, 4dlu, fill:pref", "pref"));
        if (OS.WINDOWS || OS.OS_X) {
            builder.add(Localization.lang("Path to OpenOffice/LibreOffice directory", new String[0]), new Object[0]).xy(1, 1);
            builder.add(ooPath).xy(3, 1);
            builder.add(browseOOPath).xy(5, 1);
        } else {
            builder.add(Localization.lang("Path to OpenOffice/LibreOffice executable", new String[0]), new Object[0]).xy(1, 1);
            builder.add(ooExec).xy(3, 1);
            builder.add(browseOOExec).xy(5, 1);
            builder.appendRows("4dlu, pref", new Object[0]);
            builder.add(Localization.lang("Path to OpenOffice/LibreOffice library dir", new String[0]), new Object[0]).xy(1, 3);
            builder.add(ooJars).xy(3, 3);
            builder.add(browseOOJars).xy(5, 3);
        }
        builder.padding("5dlu, 5dlu, 5dlu, 5dlu", new Object[0]);
        cDiag.getContentPane().add((Component)builder.getPanel(), "Center");
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        ok.addActionListener(e -> {
            if (OS.WINDOWS || OS.OS_X) {
                this.preferences.updateConnectionParams(ooPath.getText(), ooPath.getText(), ooPath.getText());
            } else {
                this.preferences.updateConnectionParams(ooPath.getText(), ooExec.getText(), ooJars.getText());
            }
            this.dialogOkPressed = true;
            cDiag.dispose();
        });
        cancel.addActionListener(e -> cDiag.dispose());
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addRelatedGap();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.padding("5dlu, 5dlu, 5dlu, 5dlu", new Object[0]);
        cDiag.getContentPane().add((Component)bb.getPanel(), "South");
        cDiag.pack();
        cDiag.setLocationRelativeTo(this.frame);
        cDiag.setVisible(true);
    }

    private void pushEntries(boolean inParenthesisIn, boolean withText, boolean addPageInfo) {
        BasePanel panel;
        if (!this.ooBase.isConnectedToDocument()) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Not connected to any Writer document. Please make sure a document is open, and use the 'Select Writer document' button to connect to it.", new String[0]), Localization.lang("Error", new String[0]), 0);
            return;
        }
        Boolean inParenthesis = inParenthesisIn;
        String pageInfo = null;
        if (addPageInfo) {
            AdvancedCiteDialog citeDialog = new AdvancedCiteDialog(this.frame);
            citeDialog.showDialog();
            if (citeDialog.canceled()) {
                return;
            }
            if (!citeDialog.getPageInfo().isEmpty()) {
                pageInfo = citeDialog.getPageInfo();
            }
            inParenthesis = citeDialog.isInParenthesisCite();
        }
        if ((panel = this.frame.getCurrentBasePanel()) != null) {
            BibDatabase database = panel.getDatabase();
            List<BibEntry> entries = panel.getSelectedEntries();
            if (!entries.isEmpty() && this.checkThatEntriesHaveKeys(entries)) {
                try {
                    if (this.style == null) {
                        this.style = this.loader.getUsedStyle();
                    }
                    this.ooBase.insertEntry(entries, database, this.getBaseList(), this.style, inParenthesis, withText, pageInfo, this.preferences.getSyncWhenCiting());
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(this.frame, Localization.lang("You must select either a valid style file, or use one of the default styles.", new String[0]), Localization.lang("No valid style file defined", new String[0]), 0);
                    LOGGER.warn("Problem with style file", ex);
                }
                catch (ConnectionLostException ex) {
                    this.showConnectionLostErrorMessage();
                }
                catch (UndefinedCharacterFormatException ex) {
                    this.reportUndefinedCharacterFormat(ex);
                }
                catch (UndefinedParagraphFormatException ex) {
                    this.reportUndefinedParagraphFormat(ex);
                }
                catch (IllegalTypeException | NotRemoveableException | PropertyExistException | PropertyVetoException | UnknownPropertyException | NoSuchElementException | IllegalArgumentException | WrappedTargetException | IOException | BibEntryNotFoundException | CreationException ex) {
                    LOGGER.warn("Could not insert entry", ex);
                }
            }
        }
    }

    private boolean checkThatEntriesHaveKeys(List<BibEntry> entries) {
        boolean emptyKeys = false;
        for (BibEntry entry : entries) {
            if (entry.getCiteKeyOptional().isPresent()) continue;
            emptyKeys = true;
            break;
        }
        if (!emptyKeys) {
            return true;
        }
        Object[] options = new String[]{Localization.lang("Generate keys", new String[0]), Localization.lang("Cancel", new String[0])};
        int answer = JOptionPane.showOptionDialog(this.frame, Localization.lang("Cannot cite entries without BibTeX keys. Generate keys now?", new String[0]), Localization.lang("Cite", new String[0]), 2, -1, null, options, null);
        BasePanel panel = this.frame.getCurrentBasePanel();
        if (answer == 0 && panel != null) {
            BibtexKeyPatternPreferences prefs = Globals.prefs.getBibtexKeyPatternPreferences();
            NamedCompound undoCompound = new NamedCompound(Localization.lang("Cite", new String[0]));
            for (BibEntry entry : entries) {
                if (entry.getCiteKeyOptional().isPresent()) continue;
                new BibtexKeyGenerator(panel.getBibDatabaseContext(), prefs).generateAndSetKey(entry).ifPresent(change -> undoCompound.addEdit(new UndoableKeyChange((FieldChange)change)));
            }
            undoCompound.end();
            panel.getUndoManager().addEdit(undoCompound);
            return true;
        }
        return false;
    }

    private void showConnectionLostErrorMessage() {
        JOptionPane.showMessageDialog(this.frame, Localization.lang("Connection to OpenOffice/LibreOffice has been lost. Please make sure OpenOffice/LibreOffice is running, and try to reconnect.", new String[0]), Localization.lang("Connection lost", new String[0]), 0);
    }

    private void reportUndefinedParagraphFormat(UndefinedParagraphFormatException ex) {
        JOptionPane.showMessageDialog(this.frame, "<html>" + Localization.lang("Your style file specifies the paragraph format '%0', which is undefined in your current OpenOffice/LibreOffice document.", ex.getFormatName()) + "<br>" + Localization.lang("The paragraph format is controlled by the property 'ReferenceParagraphFormat' or 'ReferenceHeaderParagraphFormat' in the style file.", new String[0]) + "</html>", "", 0);
    }

    private void reportUndefinedCharacterFormat(UndefinedCharacterFormatException ex) {
        JOptionPane.showMessageDialog(this.frame, "<html>" + Localization.lang("Your style file specifies the character format '%0', which is undefined in your current OpenOffice/LibreOffice document.", ex.getFormatName()) + "<br>" + Localization.lang("The character format is controlled by the citation property 'CitationCharacterFormat' in the style file.", new String[0]) + "</html>", "", 0);
    }

    private void showSettingsPopup() {
        JPopupMenu menu = new JPopupMenu();
        JCheckBoxMenuItem autoSync = new JCheckBoxMenuItem(Localization.lang("Automatically sync bibliography when inserting citations", new String[0]), this.preferences.getSyncWhenCiting());
        JRadioButtonMenuItem useActiveBase = new JRadioButtonMenuItem(Localization.lang("Look up BibTeX entries in the active tab only", new String[0]));
        JRadioButtonMenuItem useAllBases = new JRadioButtonMenuItem(Localization.lang("Look up BibTeX entries in all open libraries", new String[0]));
        JMenuItem clearConnectionSettings = new JMenuItem(Localization.lang("Clear connection settings", new String[0]));
        ButtonGroup lookupButtonGroup = new ButtonGroup();
        lookupButtonGroup.add(useActiveBase);
        lookupButtonGroup.add(useAllBases);
        if (this.preferences.getUseAllDatabases().booleanValue()) {
            useAllBases.setSelected(true);
        } else {
            useActiveBase.setSelected(true);
        }
        autoSync.addActionListener(e -> {
            this.preferences.setSyncWhenCiting(autoSync.isSelected());
            Globals.prefs.setOpenOfficePreferences(this.preferences);
        });
        useAllBases.addActionListener(e -> {
            this.preferences.setUseAllDatabases(useAllBases.isSelected());
            Globals.prefs.setOpenOfficePreferences(this.preferences);
        });
        useActiveBase.addActionListener(e -> {
            this.preferences.setUseAllDatabases(!useActiveBase.isSelected());
            Globals.prefs.setOpenOfficePreferences(this.preferences);
        });
        clearConnectionSettings.addActionListener(e -> {
            this.preferences.clearConnectionSettings();
            Globals.prefs.setOpenOfficePreferences(this.preferences);
        });
        menu.add(autoSync);
        menu.addSeparator();
        menu.add(useActiveBase);
        menu.add(useAllBases);
        menu.addSeparator();
        menu.add(clearConnectionSettings);
        menu.show(this.settingsB, 0, this.settingsB.getHeight());
    }

    public SidePaneComponent.ToggleAction getToggleAction() {
        return this.sidePane.getToggleAction();
    }
}

