/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jabref.Globals;
import org.jabref.gui.importer.ImportInspectionDialog;
import org.jabref.gui.importer.fetcher.EntryFetcher;
import org.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.UnitsToLatexFormatter;
import org.jabref.logic.formatter.casechanger.ProtectTermsFormatter;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.ImportInspector;
import org.jabref.logic.importer.OutputPrinter;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.cleanup.Formatter;
import org.jabref.model.entry.BibEntry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEEEXploreFetcher
implements EntryFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IEEEXploreFetcher.class);
    private static final String URL_SEARCH = "https://ieeexplore.ieee.org/rest/search?reload=true";
    private static final String URL_BIBTEX_START = "https://ieeexplore.ieee.org/xpl/downloadCitations?reload=true&recordIds=";
    private static final String URL_BIBTEX_END = "&download-format=download-bibtex&x=0&y=0";
    private static final String DIALOG_TITLE = Localization.lang("Search %0", "IEEEXplore");
    private static final int MAX_FETCH = 100;
    private static final Pattern PUBLICATION_PATTERN = Pattern.compile("(.*), \\d*\\.*\\s?(.*)");
    private static final Pattern PROCEEDINGS_PATTERN = Pattern.compile("(.*?)\\.?\\s?Proceedings\\s?(.*)");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(\\d*+)\\s*([a-z]*+)-*(\\d*+)\\s*([a-z]*+)");
    private static final Pattern PREPROCESSING_PATTERN = Pattern.compile("(?<!&)(#[x]*[0]*\\p{XDigit}+;)");
    private static final Pattern SUB_DETECTION_1 = Pattern.compile("/sub ([^/]+)/");
    private static final Pattern SUB_DETECTION_2 = Pattern.compile("\\(sub\\)([^(]+)\\(/sub\\)");
    private static final String SUB_TEXT_RESULT = "\\\\textsubscript\\{$1\\}";
    private static final Pattern SUPER_DETECTION_1 = Pattern.compile("/sup ([^/]+)/");
    private static final Pattern SUPER_DETECTION_2 = Pattern.compile("\\(sup\\)([^(]+)\\(/sup\\)");
    private static final String SUPER_TEXT_RESULT = "\\\\textsuperscript\\{$1\\}";
    private final Formatter protectTermsFormatter = new ProtectTermsFormatter(Globals.protectedTermsLoader);
    private final UnitsToLatexFormatter unitsToLatexFormatter = new UnitsToLatexFormatter();
    private final HtmlToLatexFormatter htmlToLatexFormatter = new HtmlToLatexFormatter();
    private final JCheckBox absCheckBox = new JCheckBox(Localization.lang("Include abstracts", new String[0]), false);
    private final JournalAbbreviationLoader abbreviationLoader;
    private boolean shouldContinue;

    public IEEEXploreFetcher(JournalAbbreviationLoader abbreviationLoader) {
        this.abbreviationLoader = Objects.requireNonNull(abbreviationLoader);
        CookieHandler.setDefault(new CookieManager());
    }

    @Override
    public JPanel getOptionsPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.add((Component)this.absCheckBox, "North");
        return pan;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        String terms = query.replaceAll("\"", "\\.QT\\.");
        this.shouldContinue = true;
        int parsed = 0;
        int pageNumber = 1;
        String postData = this.makeSearchPostRequestPayload(pageNumber, terms);
        try {
            URLDownload dl = new URLDownload(URL_SEARCH);
            dl.addHeader("Accept", "application/json");
            dl.addHeader("Content-Type", "application/json");
            dl.addHeader("Referer", "https://ieeexplore.ieee.org/search/searchresult.jsp");
            dl.setPostData(postData);
            String page = dl.asString();
            if (page.isEmpty()) {
                status.showMessage(Localization.lang("You have entered an invalid search '%0'.", query), DIALOG_TITLE, 1);
                return false;
            }
            JSONObject searchResultsJson = new JSONObject(page);
            int hits = searchResultsJson.getInt("totalRecords");
            if (hits == 0) {
                status.showMessage(Localization.lang("No entries found for the search string '%0'", query), DIALOG_TITLE, 1);
                return false;
            }
            if (hits > 100) {
                status.showMessage(Localization.lang("%0 entries found. To reduce server load, only %1 will be downloaded.", String.valueOf(hits), String.valueOf(100)), DIALOG_TITLE, 1);
            }
            String bibtexPage = new URLDownload(this.createBibtexQueryURL(searchResultsJson)).asString(Globals.prefs.getDefaultEncoding());
            bibtexPage = this.preprocessBibtexResultsPage(bibtexPage);
            List<BibEntry> parsedBibtexCollection = new BibtexParser(Globals.prefs.getImportFormatPreferences(), Globals.getFileUpdateMonitor()).parseEntries(bibtexPage);
            int nEntries = parsedBibtexCollection.size();
            Iterator parsedBibtexCollectionIterator = parsedBibtexCollection.iterator();
            while (parsedBibtexCollectionIterator.hasNext() && this.shouldContinue) {
                dialog.addEntry(this.cleanup((BibEntry)parsedBibtexCollectionIterator.next()));
                dialog.setProgress(parsed, nEntries);
                ++parsed;
            }
            return true;
        }
        catch (IOException | ParseException | JSONException e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)dialog).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "IEEEXplore";
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_IEEEXPLORE;
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    private String makeSearchPostRequestPayload(int startIndex, String terms) {
        return "{\"queryText\":" + JSONObject.quote(terms) + ",\"refinements\":[],\"pageNumber\":\"" + startIndex + "\",\"searchWithin\":[],\"newsearch\":\"true\",\"searchField\":\"Search_All\",\"rowsPerPage\":\"100\"}";
    }

    private String createBibtexQueryURL(JSONObject searchResultsJson) {
        StringBuilder bibtexQueryURLStringBuf = new StringBuilder();
        bibtexQueryURLStringBuf.append(URL_BIBTEX_START);
        JSONArray recordsJsonArray = searchResultsJson.getJSONArray("records");
        for (int n = 0; n < recordsJsonArray.length(); ++n) {
            if (recordsJsonArray.getJSONObject(n).isNull("articleNumber")) continue;
            bibtexQueryURLStringBuf.append(recordsJsonArray.getJSONObject(n).getString("articleNumber")).append(',');
        }
        bibtexQueryURLStringBuf.deleteCharAt(bibtexQueryURLStringBuf.length() - 1);
        boolean includeAbstract = this.absCheckBox.isSelected();
        if (includeAbstract) {
            bibtexQueryURLStringBuf.append("&citations-format=citation-abstract");
        } else {
            bibtexQueryURLStringBuf.append("&citations-format=citation-only");
        }
        bibtexQueryURLStringBuf.append(URL_BIBTEX_END);
        return bibtexQueryURLStringBuf.toString();
    }

    private String preprocessBibtexResultsPage(String bibtexPage) {
        String result = PREPROCESSING_PATTERN.matcher(bibtexPage).replaceAll("&$1");
        result = result.replaceAll("(?<!\\\\)%", "\\\\%");
        result = this.htmlToLatexFormatter.format(result);
        return result;
    }

    private BibEntry cleanup(BibEntry entry) {
        if (entry == null) {
            return null;
        }
        entry.getField("title").ifPresent(dirtyTitle -> {
            String title = dirtyTitle.replaceAll("[ ]?img src=[^ ]+ alt=\"([^\"]+)\">[ ]?", "\\$$1\\$");
            title = title.replaceAll("/sub /spl infin//", "\\$_\\\\infty\\$");
            title = title.replaceAll("/sup /spl infin//", "\\$\\^\\\\infty\\$");
            title = title.replaceAll("/[sS]pl ([^/]+)/", "\\$\\\\$1\\$");
            title = SUPER_DETECTION_1.matcher(title).replaceAll(SUPER_TEXT_RESULT);
            title = SUB_DETECTION_1.matcher(title).replaceAll(SUB_TEXT_RESULT);
            title = SUPER_DETECTION_2.matcher(title).replaceAll(SUPER_TEXT_RESULT);
            title = SUB_DETECTION_2.matcher(title).replaceAll(SUB_TEXT_RESULT);
            title = title.replaceAll("\\\\infin", "\\\\infty");
            if (Globals.prefs.getBoolean("useUnitFormatterOnSearch")) {
                title = this.unitsToLatexFormatter.format(title);
            }
            if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                title = this.protectTermsFormatter.format(title);
            }
            entry.setField("title", title);
        });
        entry.getField("author").ifPresent(dirtyAuthor -> {
            String author = dirtyAuthor.replaceAll("\\s+", " ");
            String[] authorSplit = author.split("(^\\s*|\\s*$|\\s+and\\s+)");
            ArrayList<String> authorResult = new ArrayList<String>();
            for (String authorSplitPart : authorSplit) {
                authorResult.add(authorSplitPart.replaceAll("(.+?),(.+?),(.+)", "$1,$3,$2"));
            }
            author = String.join((CharSequence)" and ", authorResult);
            author = author.replace(".", ". ").replace("  ", " ").replace(". -", ".-").replace("; ", " and ").replace(" ,", ",").replace("  ", " ");
            author = author.replaceAll("[ ,;]+$", "");
            entry.setField("author", author);
        });
        entry.getField("month").filter(month -> !month.isEmpty()).ifPresent(dirtyMonth -> {
            String month = dirtyMonth.replace(".", "");
            month = month.toLowerCase(Locale.ROOT);
            Matcher mm3 = MONTH_PATTERN.matcher(month);
            StringBuilder date = new StringBuilder(month);
            if (mm3.find()) {
                if (mm3.group(3).isEmpty()) {
                    if (mm3.group(2).isEmpty()) {
                        date = new StringBuilder().append(mm3.group(1)).append(',');
                    } else {
                        date = new StringBuilder().append('#').append(mm3.group(2).substring(0, 3)).append('#');
                        if (!mm3.group(1).isEmpty()) {
                            date.append(' ').append(mm3.group(1)).append(',');
                        }
                    }
                } else if (mm3.group(2).isEmpty()) {
                    if (mm3.group(4).isEmpty()) {
                        date.append(',');
                    } else {
                        date = new StringBuilder().append('#').append(mm3.group(4).substring(0, 3)).append('#').append(mm3.group(1)).append("--").append(mm3.group(3)).append(',');
                    }
                } else {
                    date = new StringBuilder().append('#').append(mm3.group(2).substring(0, 3)).append('#').append(mm3.group(1)).append("--#").append(mm3.group(4).substring(0, 3)).append('#').append(mm3.group(3)).append(',');
                }
            }
            entry.setField("month", date.toString());
        });
        entry.getField("pages").ifPresent(pages -> {
            String[] pageNumbers = pages.split("-");
            if (pageNumbers.length == 2) {
                if (pageNumbers[0].equals(pageNumbers[1])) {
                    entry.setField("pages", pageNumbers[0]);
                } else {
                    entry.setField("pages", pages.replace("-", "--"));
                }
            }
        });
        String type = entry.getType();
        String sourceField = "";
        if ("article".equals(type)) {
            sourceField = "journal";
            entry.clearField("booktitle");
        } else if ("inproceedings".equals(type)) {
            sourceField = "booktitle";
        }
        if (entry.hasField(sourceField)) {
            String fullName = entry.getField(sourceField).get();
            if ("article".equals(type)) {
                int ind = fullName.indexOf(": Accepted for future publication");
                if (ind > 0) {
                    fullName = fullName.substring(0, ind);
                    entry.setField("year", "to be published");
                    entry.clearField("month");
                    entry.clearField("pages");
                    entry.clearField("number");
                }
                String[] parts = fullName.split("[\\[\\]]");
                fullName = parts[0];
                if (parts.length == 3) {
                    fullName = fullName + parts[2];
                }
                entry.getField("note").filter(note -> "Early Access".equals(note)).ifPresent(note -> {
                    entry.setField("year", "to be published");
                    entry.clearField("month");
                    entry.clearField("pages");
                    entry.clearField("number");
                });
            } else {
                fullName = fullName.replace("Conference Proceedings", "Proceedings").replace("Proceedings of", "Proceedings").replace("Proceedings.", "Proceedings");
                fullName = fullName.replace("International", "Int.");
                fullName = fullName.replace("Symposium", "Symp.");
                fullName = fullName.replace("Conference", "Conf.");
                fullName = fullName.replace(" on", " ").replace("  ", " ");
            }
            Matcher m1 = PUBLICATION_PATTERN.matcher(fullName);
            String abrvPattern = ".*[^,] '?\\d+\\)?";
            if (m1.find()) {
                String prefix = m1.group(2).trim();
                String postfix = m1.group(1).trim();
                String abrv = "";
                String[] parts = prefix.split("\\. ", 2);
                if (parts.length == 2) {
                    if (parts[0].matches(abrvPattern)) {
                        prefix = parts[1];
                        abrv = parts[0];
                    } else {
                        prefix = parts[0];
                        abrv = parts[1];
                    }
                }
                if (prefix.matches(abrvPattern)) {
                    fullName = postfix + " " + prefix;
                } else {
                    fullName = prefix + " " + postfix + " " + abrv;
                    fullName = fullName.trim();
                }
            }
            if ("article".equals(type)) {
                fullName = fullName.replace(" - ", "-");
                fullName = fullName.trim();
                JournalAbbreviationPreferences journalAbbreviationPreferences = Globals.prefs.getJournalAbbreviationPreferences();
                if (journalAbbreviationPreferences.useIEEEAbbreviations()) {
                    fullName = this.abbreviationLoader.getRepository(journalAbbreviationPreferences).getMedlineAbbreviation(fullName).orElse(fullName);
                }
            }
            if ("inproceedings".equals(type)) {
                Matcher m22 = PROCEEDINGS_PATTERN.matcher(fullName);
                if (m22.find()) {
                    String prefix = m22.group(2);
                    String postfix = m22.group(1).replaceAll("\\.$", "");
                    if (prefix.matches(abrvPattern)) {
                        fullName = postfix.trim() + " " + prefix.trim();
                    } else {
                        String abrv = "";
                        String[] parts = postfix.split("\\. ", 2);
                        if (parts.length == 2) {
                            if (parts[0].matches(abrvPattern)) {
                                postfix = parts[1];
                                abrv = parts[0];
                            } else {
                                postfix = parts[0];
                                abrv = parts[1];
                            }
                        }
                        fullName = prefix.trim() + " " + postfix.trim() + " " + abrv;
                    }
                }
                fullName = fullName.trim();
                fullName = fullName.replaceAll("^[tT]he ", "").replaceAll("^\\d{4} ", "").replaceAll("[,.]$", "");
                Optional<String> year = entry.getField("year");
                if (year.isPresent()) {
                    fullName = fullName.replaceAll(", " + year.get() + "\\.?", "");
                }
                if (!(fullName.contains("Abstract") || fullName.contains("Summaries") || fullName.contains("Conference Record"))) {
                    fullName = "Proc. " + fullName;
                }
            }
            entry.setField(sourceField, fullName);
        }
        entry.getField("abstract").ifPresent(dirtyAbstr -> {
            String abstr = dirtyAbstr.replaceAll("/sub /spl infin//", "\\$_\\\\infty\\$");
            abstr = abstr.replaceAll("/sup /spl infin//", "\\$\\^\\\\infty\\$");
            abstr = abstr.replaceAll("/[sS]pl ([^/]+)/", "\\$\\\\$1\\$");
            abstr = SUPER_DETECTION_1.matcher(abstr).replaceAll(SUPER_TEXT_RESULT);
            abstr = SUB_DETECTION_1.matcher(abstr).replaceAll(SUB_TEXT_RESULT);
            abstr = SUPER_DETECTION_2.matcher(abstr).replaceAll(SUPER_TEXT_RESULT);
            abstr = SUB_DETECTION_2.matcher(abstr).replaceAll(SUB_TEXT_RESULT);
            abstr = abstr.replace("\\infin", "\\infty");
            entry.setField("abstract", abstr);
        });
        entry.getField("url").ifPresent(url -> entry.setField("url", "https://ieeexplore.ieee.org" + url.replace("tp=&", "")));
        entry.getField("keywords").ifPresent(keys -> entry.setField("keywords", keys.replace(";", Globals.prefs.get("groupKeywordSeparator"))));
        return entry;
    }
}

