/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jabref.Globals;
import org.jabref.gui.importer.ImportInspectionDialog;
import org.jabref.gui.importer.fetcher.EntryFetcher;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.ImportInspector;
import org.jabref.logic.importer.OutputPrinter;
import org.jabref.logic.importer.util.JSONEntryParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOAJFetcher
implements EntryFetcher {
    private static final String SEARCH_URL = "https://doaj.org/api/v1/search/articles/";
    private static final Logger LOGGER = LoggerFactory.getLogger(DOAJFetcher.class);
    private static final int MAX_PER_PAGE = 100;
    private boolean shouldContinue;
    private final JSONEntryParser jsonConverter = new JSONEntryParser();

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        this.shouldContinue = true;
        try {
            status.setStatus(Localization.lang("Searching...", new String[0]));
            HttpResponse<JsonNode> jsonResponse = Unirest.get(SEARCH_URL + query + "?pageSize=1").header("accept", "application/json").asJson();
            JSONObject jo = jsonResponse.getBody().getObject();
            int numberToFetch = jo.getInt("total");
            if (numberToFetch > 0) {
                if (numberToFetch > 100) {
                    boolean numberEntered = false;
                    do {
                        String strCount;
                        if ((strCount = JOptionPane.showInputDialog(Localization.lang("%0 references found. Number of references to fetch?", String.valueOf(numberToFetch)))) == null) {
                            status.setStatus(Localization.lang("%0 import canceled", this.getTitle()));
                            return false;
                        }
                        try {
                            numberToFetch = Integer.parseInt(strCount.trim());
                            numberEntered = true;
                        }
                        catch (NumberFormatException ex) {
                            status.showMessage(Localization.lang("Please enter a valid number", new String[0]));
                        }
                    } while (!numberEntered);
                }
                int fetched = 0;
                int page = 1;
                while ((page - 1) * 100 <= numberToFetch && this.shouldContinue) {
                    int noToFetch = Math.min(100, numberToFetch - (page - 1) * 100);
                    jsonResponse = Unirest.get(SEARCH_URL + query + "?page=" + page + "&pageSize=" + noToFetch).header("accept", "application/json").asJson();
                    jo = jsonResponse.getBody().getObject();
                    if (jo.has("results")) {
                        JSONArray results = jo.getJSONArray("results");
                        for (int i = 0; i < results.length(); ++i) {
                            JSONObject bibJsonEntry = results.getJSONObject(i).getJSONObject("bibjson");
                            BibEntry entry = this.jsonConverter.parseBibJSONtoBibtex(bibJsonEntry, Globals.prefs.getKeywordDelimiter());
                            inspector.addEntry(entry);
                            inspector.setProgress(++fetched, numberToFetch);
                        }
                    }
                    ++page;
                }
                return true;
            }
            status.showMessage(Localization.lang("No entries found for the search string '%0'", query), Localization.lang("Search %0", this.getTitle()), 1);
            return false;
        }
        catch (UnirestException e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)inspector).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "DOAJ";
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_DOAJ;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

