/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.gui.externalfiles.AutoSetLinks;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.logic.util.io.AutoLinkPreferences;
import org.jabref.logic.util.io.FileFinder;
import org.jabref.logic.util.io.FileFinders;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSetFileLinksUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSetLinks.class);
    private List<Path> directories;
    private AutoLinkPreferences autoLinkPreferences;
    private ExternalFileTypes externalFileTypes;

    public AutoSetFileLinksUtil(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences, AutoLinkPreferences autoLinkPreferences, ExternalFileTypes externalFileTypes) {
        this(databaseContext.getFileDirectoriesAsPaths(fileDirectoryPreferences), autoLinkPreferences, externalFileTypes);
    }

    public AutoSetFileLinksUtil(List<Path> directories, AutoLinkPreferences autoLinkPreferences, ExternalFileTypes externalFileTypes) {
        this.directories = directories;
        this.autoLinkPreferences = autoLinkPreferences;
        this.externalFileTypes = externalFileTypes;
    }

    public List<LinkedFile> findAssociatedNotLinkedFiles(BibEntry entry) throws IOException {
        ArrayList<LinkedFile> linkedFiles = new ArrayList<LinkedFile>();
        List<String> extensions = this.externalFileTypes.getExternalFileTypeSelection().stream().map(ExternalFileType::getExtension).collect(Collectors.toList());
        FileFinder fileFinder = FileFinders.constructFromConfiguration(this.autoLinkPreferences);
        List<Path> result = fileFinder.findAssociatedFiles(entry, this.directories, extensions);
        for (Path foundFile : result) {
            boolean fileAlreadyLinked = entry.getFiles().stream().map(file -> file.findIn(this.directories)).anyMatch(file -> {
                try {
                    return file.isPresent() && Files.isSameFile((Path)file.get(), foundFile);
                }
                catch (IOException e) {
                    LOGGER.error("Problem with isSameFile", e);
                    return false;
                }
            });
            if (fileAlreadyLinked) continue;
            Optional<UnknownExternalFileType> type = FileHelper.getFileExtension(foundFile).map(this.externalFileTypes::getExternalFileTypeByExt).orElse(Optional.of(new UnknownExternalFileType("")));
            String strType = type.isPresent() ? ((ExternalFileType)type.get()).getName() : "";
            String relativeFilePath = FileUtil.shortenFileName(foundFile, this.directories).toString();
            LinkedFile linkedFile = new LinkedFile("", relativeFilePath, strType);
            linkedFiles.add(linkedFile);
        }
        return linkedFiles;
    }
}

