/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import java.awt.event.ActionEvent;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.l10n.Localization;
import spin.Spin;

public class SaveAllAction
extends MnemonicAwareAction
implements Runnable {
    private final JabRefFrame frame;
    private int databases;

    public SaveAllAction(JabRefFrame frame) {
        super(IconTheme.JabRefIcon.SAVE_ALL.getIcon());
        this.frame = frame;
        this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.SAVE_ALL));
        this.putValue("ShortDescription", Localization.lang("Save all open libraries", new String[0]));
        this.putValue("Name", Localization.menuTitle("Save all", new String[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.databases = this.frame.getBasePanelCount();
        this.frame.output(Localization.lang("Saving all libraries...", new String[0]));
        Spin.off(this);
        this.run();
        this.frame.output(Localization.lang("Save all finished.", new String[0]));
    }

    @Override
    public void run() {
        for (int i = 0; i < this.databases; ++i) {
            if (i >= this.frame.getBasePanelCount()) continue;
            BasePanel panel = this.frame.getBasePanelAt(i);
            if (!panel.getBibDatabaseContext().getDatabaseFile().isPresent()) {
                this.frame.showBasePanelAt(i);
            }
            panel.runCommand("save");
        }
    }
}

