/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.customentrytypes;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.customentrytypes.CustomEntryTypesManager;
import org.jabref.gui.customentrytypes.EntryTypeList;
import org.jabref.gui.customentrytypes.FieldSetComponent;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.CustomEntryType;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.strings.StringUtil;

public class EntryCustomizationDialog
extends JabRefDialog
implements ListSelectionListener {
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints con = new GridBagConstraints();
    protected JButton delete;
    private final JabRefFrame frame;
    private FieldSetComponent reqComp;
    private FieldSetComponent optComp;
    private FieldSetComponent optComp2;
    private EntryTypeList typeComp;
    private final List<String> preset = InternalBibtexFields.getAllPublicFieldNames();
    private String lastSelected;
    private final Map<String, Set<String>> reqLists = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> optLists = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> opt2Lists = new HashMap<String, Set<String>>();
    private final Set<String> defaulted = new HashSet<String>();
    private final Set<String> changed = new HashSet<String>();
    private boolean biblatexMode;
    private BibDatabaseMode bibDatabaseMode;

    public EntryCustomizationDialog(JabRefFrame frame) {
        super((Frame)frame, Localization.lang("Customize entry types", new String[0]), false, EntryCustomizationDialog.class);
        this.frame = frame;
        this.initGui();
    }

    private void initGui() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.bibDatabaseMode = this.frame.getCurrentBasePanel() == null ? Globals.prefs.getDefaultBibDatabaseMode() : this.frame.getCurrentBasePanel().getBibDatabaseContext().getMode();
        this.biblatexMode = BibDatabaseMode.BIBLATEX.equals((Object)this.bibDatabaseMode);
        JPanel main = new JPanel();
        JPanel buttons = new JPanel();
        JPanel right = new JPanel();
        main.setLayout(new BorderLayout());
        right.setLayout(new GridLayout(this.biblatexMode ? 2 : 1, 2));
        ArrayList<String> entryTypes = new ArrayList<String>();
        entryTypes.addAll(EntryTypes.getAllTypes(this.bibDatabaseMode));
        this.typeComp = new EntryTypeList(entryTypes, this.bibDatabaseMode);
        this.typeComp.addListSelectionListener(this);
        this.typeComp.addAdditionActionListener(e -> this.typeComp.selectField(e.getActionCommand()));
        this.typeComp.addDefaultActionListener(new DefaultListener());
        this.typeComp.setListSelectionMode(0);
        this.reqComp = new FieldSetComponent(Localization.lang("Required fields", new String[0]), new ArrayList<String>(), this.preset, true, true);
        this.reqComp.setEnabled(false);
        this.reqComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        DataListener dataListener = new DataListener();
        this.reqComp.addListDataListener(dataListener);
        this.optComp = new FieldSetComponent(Localization.lang("Optional fields", new String[0]), new ArrayList<String>(), this.preset, true, true);
        this.optComp.setEnabled(false);
        this.optComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.optComp.addListDataListener(dataListener);
        right.add(this.reqComp);
        right.add(this.optComp);
        if (this.biblatexMode) {
            this.optComp2 = new FieldSetComponent(Localization.lang("Optional fields", new String[0]) + " 2", new ArrayList<String>(), this.preset, true, true);
            this.optComp2.setEnabled(false);
            this.optComp2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.optComp2.addListDataListener(dataListener);
            right.add(new JPanel());
            right.add(this.optComp2);
        }
        right.setBorder(BorderFactory.createEtchedBorder());
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        JButton apply2 = new JButton(Localization.lang("Apply", new String[0]));
        ok.addActionListener(e -> {
            this.applyChanges();
            this.dispose();
        });
        apply2.addActionListener(e -> this.applyChanges());
        cancel.addActionListener(e -> this.dispose());
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)apply2);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryCustomizationDialog.this.dispose();
            }
        };
        ActionMap am = main.getActionMap();
        InputMap im = main.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
        main.add((Component)this.typeComp, "West");
        main.add((Component)right, "Center");
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)main, "Center");
        pane.add((Component)buttons, "South");
        this.pack();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String selectedTypeName;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.lastSelected != null) {
            this.reqLists.put(this.lastSelected, this.reqComp.getFields());
            this.optLists.put(this.lastSelected, this.optComp.getFields());
            if (this.biblatexMode) {
                this.opt2Lists.put(this.lastSelected, this.optComp2.getFields());
            }
        }
        if ((selectedTypeName = this.typeComp.getFirstSelected()) == null) {
            return;
        }
        Set<String> requiredFieldsSelectedType = this.reqLists.get(selectedTypeName);
        if (requiredFieldsSelectedType == null) {
            Optional<EntryType> type = EntryTypes.getType(selectedTypeName, this.bibDatabaseMode);
            if (type.isPresent()) {
                Set<String> opt;
                Set<String> req = type.get().getRequiredFields();
                if (this.biblatexMode) {
                    opt = type.get().getPrimaryOptionalFields();
                    Set<String> opt2 = type.get().getSecondaryOptionalFields();
                    this.optComp2.setFields(opt2);
                    this.optComp2.setEnabled(true);
                } else {
                    opt = type.get().getOptionalFields();
                }
                this.reqComp.setFields(req);
                this.reqComp.setEnabled(true);
                this.optComp.setFields(opt);
                this.optComp.setEnabled(true);
            } else {
                this.reqComp.setFields(new HashSet<String>());
                this.reqComp.setEnabled(true);
                this.optComp.setFields(new HashSet<String>());
                this.optComp.setEnabled(true);
                if (this.biblatexMode) {
                    this.optComp2.setFields(new HashSet<String>());
                    this.optComp2.setEnabled(true);
                }
                this.reqComp.requestFocus();
            }
        } else {
            this.reqComp.setFields(requiredFieldsSelectedType);
            this.optComp.setFields(this.optLists.get(selectedTypeName));
            if (this.biblatexMode) {
                this.optComp2.setFields(this.opt2Lists.get(selectedTypeName));
            }
        }
        this.lastSelected = selectedTypeName;
        this.typeComp.enable(selectedTypeName, this.changed.contains(this.lastSelected) && !this.defaulted.contains(this.lastSelected));
    }

    private void applyChanges() {
        this.valueChanged(new ListSelectionEvent(new JList(), 0, 0, false));
        ArrayList<String> actuallyChangedTypes = new ArrayList<String>();
        Set types = this.typeComp.getFields();
        for (Map.Entry<String, Set<String>> stringListEntry : this.reqLists.entrySet()) {
            if (!types.contains(stringListEntry.getKey())) continue;
            Set<String> requiredFieldsList = stringListEntry.getValue();
            Set<String> optionalFieldsList = this.optLists.get(stringListEntry.getKey());
            Set<String> secondaryOptionalFieldsLists = this.opt2Lists.get(stringListEntry.getKey());
            if (secondaryOptionalFieldsLists == null) {
                secondaryOptionalFieldsLists = new HashSet<String>(0);
            }
            boolean changesMade = true;
            if (this.defaulted.contains(stringListEntry.getKey())) {
                EntryTypes.removeType(stringListEntry.getKey(), this.bibDatabaseMode);
                actuallyChangedTypes.add(stringListEntry.getKey().toLowerCase(Locale.ENGLISH));
                this.defaulted.remove(stringListEntry.getKey());
                continue;
            }
            Optional<EntryType> oldType = EntryTypes.getType(stringListEntry.getKey(), this.bibDatabaseMode);
            if (oldType.isPresent()) {
                Set<String> oldRequiredFieldsList = oldType.get().getRequiredFieldsFlat();
                Set<String> oldOptionalFieldsList = oldType.get().getOptionalFields();
                if (this.biblatexMode) {
                    Set<String> oldPrimaryOptionalFieldsLists = oldType.get().getPrimaryOptionalFields();
                    Set<String> oldSecondaryOptionalFieldsList = oldType.get().getSecondaryOptionalFields();
                    if (oldRequiredFieldsList.equals(requiredFieldsList) && oldPrimaryOptionalFieldsLists.equals(optionalFieldsList) && oldSecondaryOptionalFieldsList.equals(secondaryOptionalFieldsLists)) {
                        changesMade = false;
                    }
                } else if (oldRequiredFieldsList.equals(requiredFieldsList) && oldOptionalFieldsList.equals(optionalFieldsList)) {
                    changesMade = false;
                }
            }
            if (!changesMade) continue;
            CustomEntryType customType = this.biblatexMode ? new CustomEntryType(StringUtil.capitalizeFirst(stringListEntry.getKey()), requiredFieldsList, optionalFieldsList, secondaryOptionalFieldsLists) : new CustomEntryType(StringUtil.capitalizeFirst(stringListEntry.getKey()), requiredFieldsList, optionalFieldsList);
            EntryTypes.addOrModifyCustomEntryType(customType, this.bibDatabaseMode);
            actuallyChangedTypes.add(customType.getName().toLowerCase(Locale.ENGLISH));
        }
        if (!actuallyChangedTypes.isEmpty()) {
            this.updateEntriesForChangedTypes(actuallyChangedTypes);
        }
        HashSet<String> typesToRemove = new HashSet<String>();
        for (String existingType : EntryTypes.getAllTypes(this.bibDatabaseMode)) {
            if (types.contains(existingType)) continue;
            typesToRemove.add(existingType);
        }
        if (!typesToRemove.isEmpty()) {
            for (String typeToRemove : typesToRemove) {
                this.deleteType(typeToRemove);
            }
        }
        this.updateTables();
        CustomEntryTypesManager.saveCustomEntryTypes(Globals.prefs);
    }

    private void deleteType(String name) {
        Optional<EntryType> type = EntryTypes.getType(name, this.bibDatabaseMode);
        if (type.isPresent() && type.get() instanceof CustomEntryType) {
            int reply;
            if (!EntryTypes.getStandardType(name, this.bibDatabaseMode).isPresent() && (reply = JOptionPane.showConfirmDialog(this.frame, Localization.lang("All entries of this type will be declared typeless. Continue?", new String[0]), Localization.lang("Delete custom format", new String[0]) + " '" + StringUtil.capitalizeFirst(name) + '\'', 0, 2)) != 0) {
                return;
            }
            EntryTypes.removeType(name, this.bibDatabaseMode);
            this.updateEntriesForChangedTypes(Collections.singletonList(name.toLowerCase(Locale.ENGLISH)));
            this.changed.remove(name);
            this.reqLists.remove(name);
            this.optLists.remove(name);
            if (this.biblatexMode) {
                this.opt2Lists.remove(name);
            }
        }
    }

    private void updateEntriesForChangedTypes(List<String> actuallyChangedTypes) {
        for (BasePanel bp : this.frame.getBasePanelList()) {
            List<BibEntry> filtered = bp.getDatabase().getEntries().stream().filter(entry -> actuallyChangedTypes.contains(entry.getType().toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
            filtered.forEach(entry -> EntryTypes.getType(entry.getType(), this.bibDatabaseMode).ifPresent(entry::setType));
        }
    }

    private void updateTables() {
        for (BasePanel basePanel : this.frame.getBasePanelList()) {
            ((AbstractTableModel)basePanel.getMainTable().getModel()).fireTableDataChanged();
        }
    }

    class DataListener
    implements ListDataListener {
        DataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.record();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.record();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.record();
        }

        private void record() {
            if (EntryCustomizationDialog.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog.this.defaulted.remove(EntryCustomizationDialog.this.lastSelected);
            EntryCustomizationDialog.this.changed.add(EntryCustomizationDialog.this.lastSelected);
            EntryCustomizationDialog.this.typeComp.enable(EntryCustomizationDialog.this.lastSelected, true);
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntryCustomizationDialog.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog.this.defaulted.add(EntryCustomizationDialog.this.lastSelected);
            Optional<EntryType> type = EntryTypes.getStandardType(EntryCustomizationDialog.this.lastSelected, EntryCustomizationDialog.this.bibDatabaseMode);
            if (type.isPresent()) {
                Set<String> of = type.get().getOptionalFields();
                Set<String> req = type.get().getRequiredFields();
                HashSet<String> opt1 = new HashSet();
                HashSet<String> opt2 = new HashSet();
                if (!of.isEmpty()) {
                    if (EntryCustomizationDialog.this.biblatexMode) {
                        opt1 = type.get().getPrimaryOptionalFields();
                        opt2 = type.get().getSecondaryOptionalFields();
                    } else {
                        opt1 = of;
                    }
                }
                EntryCustomizationDialog.this.reqComp.setFields(req);
                EntryCustomizationDialog.this.reqComp.setEnabled(true);
                EntryCustomizationDialog.this.optComp.setFields(opt1);
                if (EntryCustomizationDialog.this.biblatexMode) {
                    EntryCustomizationDialog.this.optComp2.setFields(opt2);
                }
            }
        }
    }
}

