/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import org.jabref.gui.BasePanel;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.collab.InfoPane;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.bibtex.DuplicateCheck;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntryChangeViewModel
extends ChangeViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryChangeViewModel.class);

    public EntryChangeViewModel(BibEntry memEntry, BibEntry tmpEntry, BibEntry diskEntry) {
        Optional<String> key = tmpEntry.getCiteKeyOptional();
        this.name = key.isPresent() ? Localization.lang("Modified entry", new String[0]) + ": '" + key.get() + '\'' : Localization.lang("Modified entry", new String[0]);
        boolean isModifiedLocally = DuplicateCheck.compareEntriesStrictly(memEntry, tmpEntry) <= 1.0;
        boolean modificationsAgree = DuplicateCheck.compareEntriesStrictly(memEntry, diskEntry) > 1.0;
        LOGGER.debug("Modified entry: " + memEntry.getCiteKeyOptional().orElse("<no BibTeX key set>") + "\n Modified locally: " + isModifiedLocally + " Modifications agree: " + modificationsAgree);
        TreeSet<String> allFields = new TreeSet<String>();
        allFields.addAll(memEntry.getFieldNames());
        allFields.addAll(tmpEntry.getFieldNames());
        allFields.addAll(diskEntry.getFieldNames());
        for (String field2 : allFields) {
            Optional<String> mem = memEntry.getField(field2);
            Optional<String> tmp = tmpEntry.getField(field2);
            Optional<String> disk = diskEntry.getField(field2);
            if (tmp.isPresent() && disk.isPresent()) {
                if (tmp.equals(disk)) continue;
                this.add(new FieldChangeViewModel(field2, memEntry, tmpEntry, mem.orElse(null), tmp.get(), disk.get()));
                continue;
            }
            if ((tmp.isPresent() || !disk.isPresent() || disk.get().isEmpty()) && (disk.isPresent() || !tmp.isPresent() || tmp.get().isEmpty() || !mem.isPresent() || mem.get().isEmpty())) continue;
            this.add(new FieldChangeViewModel(field2, memEntry, tmpEntry, mem.orElse(null), tmp.orElse(null), disk.orElse(null)));
        }
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        boolean allAccepted = true;
        Enumeration<TreeNode> e = this.children();
        for (ChangeViewModel changeViewModel : Collections.list(e)) {
            if (changeViewModel.isAcceptable() && changeViewModel.isAccepted()) {
                changeViewModel.makeChange(panel, secondary, undoEdit);
                continue;
            }
            allAccepted = false;
        }
        return allAccepted;
    }

    @Override
    public JComponent description() {
        return new JLabel(this.name);
    }

    static class FieldChangeViewModel
    extends ChangeViewModel {
        private final BibEntry entry;
        private final BibEntry tmpEntry;
        private final String field;
        private final String inMem;
        private final String onDisk;
        private final InfoPane tp = new InfoPane();
        private final JScrollPane sp = new JScrollPane(this.tp);

        public FieldChangeViewModel(String field2, BibEntry memEntry, BibEntry tmpEntry, String inMem, String onTmp, String onDisk) {
            super(field2);
            this.entry = memEntry;
            this.tmpEntry = tmpEntry;
            this.field = field2;
            this.inMem = inMem;
            this.onDisk = onDisk;
            StringBuilder text = new StringBuilder(36);
            text.append("<FONT SIZE=10><H2>").append(Localization.lang("Modification of field", new String[0])).append(" <I>").append(field2).append("</I></H2>");
            if (onDisk != null && !onDisk.isEmpty()) {
                text.append("<H3>").append(Localization.lang("Value set externally", new String[0])).append(":</H3> ").append(onDisk);
            } else {
                text.append("<H3>").append(Localization.lang("Value cleared externally", new String[0])).append("</H3>");
            }
            if (inMem != null && !inMem.isEmpty()) {
                text.append("<H3>").append(Localization.lang("Current value", new String[0])).append(":</H3> ").append(inMem);
            }
            if (onTmp != null && !onTmp.isEmpty()) {
                text.append("<H3>").append(Localization.lang("Current tmp value", new String[0])).append(":</H3> ").append(onTmp);
            }
            this.tp.setContentType("text/html");
            this.tp.setText(text.toString());
        }

        @Override
        public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
            if (this.onDisk == null) {
                this.entry.clearField(this.field);
            } else {
                this.entry.setField(this.field, this.onDisk);
            }
            undoEdit.addEdit(new UndoableFieldChange(this.entry, this.field, this.inMem, this.onDisk));
            if (this.onDisk == null) {
                this.tmpEntry.clearField(this.field);
            } else {
                this.tmpEntry.setField(this.field, this.onDisk);
            }
            return true;
        }

        @Override
        public JComponent description() {
            return this.sp;
        }
    }
}

