/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.behavior.TableViewBehavior;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;

public class GridViewBehavior
extends TableViewBehavior<ObservableList<SpreadsheetCell>> {
    private GridViewSkin skin;

    public GridViewBehavior(TableView<ObservableList<SpreadsheetCell>> control) {
        super(control);
    }

    void setGridViewSkin(GridViewSkin skin) {
        this.skin = skin;
    }

    protected void updateCellVerticalSelection(int delta, Runnable defaultAction) {
        TableViewSpanSelectionModel sm = (TableViewSpanSelectionModel)this.getSelectionModel();
        if (sm == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (this.isShiftDown && this.getAnchor() != null) {
            SpreadsheetCell cell = (SpreadsheetCell)focusedCell.getTableColumn().getCellData(focusedCell.getRow());
            sm.direction = new Pair((Object)delta, (Object)0);
            int newRow = delta < 0 ? this.skin.getFirstRow(cell, focusedCell.getRow()) + delta : focusedCell.getRow() + this.skin.spreadsheetView.getRowSpan(cell, focusedCell.getRow()) - 1 + delta;
            newRow = Math.max(Math.min(this.getItemCount() - 1, newRow), 0);
            TablePositionBase anchor = this.getAnchor();
            int minRow = Math.min(anchor.getRow(), newRow);
            int maxRow = Math.max(anchor.getRow(), newRow);
            int minColumn = Math.min(anchor.getColumn(), focusedCell.getColumn());
            int maxColumn = Math.max(anchor.getColumn(), focusedCell.getColumn());
            sm.clearSelection();
            if (minColumn != -1 && maxColumn != -1) {
                sm.selectRange(minRow, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getControl()).getVisibleLeafColumn(minColumn), maxRow, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getControl()).getVisibleLeafColumn(maxColumn));
            }
            fm.focus(newRow, focusedCell.getTableColumn());
        } else {
            int focusIndex = fm.getFocusedIndex();
            if (!sm.isSelected(focusIndex, focusedCell.getTableColumn())) {
                sm.select(focusIndex, focusedCell.getTableColumn());
            }
            defaultAction.run();
        }
    }

    protected void updateCellHorizontalSelection(int delta, Runnable defaultAction) {
        TableViewSpanSelectionModel sm = (TableViewSpanSelectionModel)this.getSelectionModel();
        if (sm == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (focusedCell == null || focusedCell.getTableColumn() == null) {
            return;
        }
        TableColumnBase adjacentColumn = this.getColumn(focusedCell.getTableColumn(), delta);
        if (adjacentColumn == null) {
            return;
        }
        int focusedCellRow = focusedCell.getRow();
        if (this.isShiftDown && this.getAnchor() != null) {
            SpreadsheetCell cell = (SpreadsheetCell)focusedCell.getTableColumn().getCellData(focusedCell.getRow());
            sm.direction = new Pair((Object)0, (Object)delta);
            int newColumn = delta < 0 ? this.skin.spreadsheetView.getViewColumn(cell.getColumn()) + delta : this.skin.spreadsheetView.getViewColumn(cell.getColumn()) + this.skin.spreadsheetView.getColumnSpan(cell) - 1 + delta;
            TablePositionBase anchor = this.getAnchor();
            int minRow = Math.min(anchor.getRow(), focusedCellRow);
            int maxRow = Math.max(anchor.getRow(), focusedCellRow);
            int minColumn = Math.min(anchor.getColumn(), newColumn);
            int maxColumn = Math.max(anchor.getColumn(), newColumn);
            sm.clearSelection();
            if (minColumn != -1 && maxColumn != -1) {
                sm.selectRange(minRow, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getControl()).getVisibleLeafColumn(minColumn), maxRow, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getControl()).getVisibleLeafColumn(maxColumn));
            }
            fm.focus(focusedCell.getRow(), this.getColumn(newColumn));
        } else {
            defaultAction.run();
        }
    }

    protected void focusPreviousRow() {
        this.focusVertical(true);
    }

    protected void focusNextRow() {
        this.focusVertical(false);
    }

    protected void focusLeftCell() {
        this.focusHorizontal(true);
    }

    protected void focusRightCell() {
        this.focusHorizontal(false);
    }

    protected void discontinuousSelectPreviousRow() {
        this.discontinuousSelectVertical(true);
    }

    protected void discontinuousSelectNextRow() {
        this.discontinuousSelectVertical(false);
    }

    protected void discontinuousSelectPreviousColumn() {
        this.discontinuousSelectHorizontal(true);
    }

    protected void discontinuousSelectNextColumn() {
        this.discontinuousSelectHorizontal(false);
    }

    private void focusVertical(boolean previous) {
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null || sm.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (focusedCell == null || focusedCell.getTableColumn() == null) {
            return;
        }
        SpreadsheetCell cell = (SpreadsheetCell)focusedCell.getTableColumn().getCellData(focusedCell.getRow());
        sm.clearAndSelect(previous ? this.findPreviousRow(focusedCell, cell) : this.findNextRow(focusedCell, cell), focusedCell.getTableColumn());
        this.skin.focusScroll();
    }

    private void focusHorizontal(boolean previous) {
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (focusedCell == null || focusedCell.getTableColumn() == null) {
            return;
        }
        SpreadsheetCell cell = (SpreadsheetCell)focusedCell.getTableColumn().getCellData(focusedCell.getRow());
        sm.clearAndSelect(focusedCell.getRow(), (TableColumnBase)((TableView)this.getControl()).getVisibleLeafColumn(previous ? this.findPreviousColumn(focusedCell, cell) : this.findNextColumn(focusedCell, cell)));
        this.skin.focusScroll();
    }

    private int findPreviousRow(TablePositionBase focusedCell, SpreadsheetCell cell) {
        ObservableList items = ((TableView)this.getControl()).getItems();
        if (this.isEmpty(cell)) {
            for (int row = focusedCell.getRow() - 1; row >= 0; --row) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(row)).get(focusedCell.getColumn());
                if (this.isEmpty(temp)) continue;
                return row;
            }
        } else if (focusedCell.getRow() - 1 >= 0 && !this.isEmpty((SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow() - 1)).get(focusedCell.getColumn()))) {
            for (int row = focusedCell.getRow() - 2; row >= 0; --row) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(row)).get(focusedCell.getColumn());
                if (!this.isEmpty(temp)) continue;
                return row + 1;
            }
        } else {
            for (int row = focusedCell.getRow() - 2; row >= 0; --row) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(row)).get(focusedCell.getColumn());
                if (this.isEmpty(temp)) continue;
                return row;
            }
        }
        return 0;
    }

    public void selectCell(int rowDiff, int columnDiff) {
        TableViewSpanSelectionModel sm = (TableViewSpanSelectionModel)this.getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.direction = new Pair((Object)rowDiff, (Object)columnDiff);
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        int currentRow = focusedCell.getRow();
        int currentColumn = this.getVisibleLeafIndex(focusedCell.getTableColumn());
        if (rowDiff < 0 && currentRow <= 0) {
            return;
        }
        if (rowDiff > 0 && currentRow >= this.getItemCount() - 1) {
            return;
        }
        if (columnDiff < 0 && currentColumn <= 0) {
            return;
        }
        if (columnDiff > 0 && currentColumn >= this.getVisibleLeafColumns().size() - 1) {
            return;
        }
        if (columnDiff > 0 && currentColumn == -1) {
            return;
        }
        TableColumnBase tc = focusedCell.getTableColumn();
        tc = this.getColumn(tc, columnDiff);
        int row = focusedCell.getRow() + rowDiff;
        sm.clearAndSelect(row, tc);
        this.setAnchor(row, tc);
    }

    private int findNextRow(TablePositionBase focusedCell, SpreadsheetCell cell) {
        ObservableList items = ((TableView)this.getControl()).getItems();
        int itemCount = this.getItemCount();
        if (this.isEmpty(cell)) {
            for (int row = focusedCell.getRow() + 1; row < itemCount; ++row) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(row)).get(focusedCell.getColumn());
                if (this.isEmpty(temp)) continue;
                return row;
            }
        } else if (focusedCell.getRow() + 1 < itemCount && !this.isEmpty((SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow() + 1)).get(focusedCell.getColumn()))) {
            for (int row = focusedCell.getRow() + 2; row < this.getItemCount(); ++row) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(row)).get(focusedCell.getColumn());
                if (!this.isEmpty(temp)) continue;
                return row - 1;
            }
        } else {
            for (int row = focusedCell.getRow() + 2; row < itemCount; ++row) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(row)).get(focusedCell.getColumn());
                if (this.isEmpty(temp)) continue;
                return row;
            }
        }
        return itemCount - 1;
    }

    private void discontinuousSelectVertical(boolean previous) {
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (focusedCell == null || focusedCell.getTableColumn() == null) {
            return;
        }
        SpreadsheetCell cell = (SpreadsheetCell)focusedCell.getTableColumn().getCellData(focusedCell.getRow());
        int newRow = previous ? this.findPreviousRow(focusedCell, cell) : this.findNextRow(focusedCell, cell);
        newRow = Math.max(Math.min(this.getItemCount() - 1, newRow), 0);
        TablePositionBase anchor = this.getAnchor();
        int minRow = Math.min(anchor.getRow(), newRow);
        int maxRow = Math.max(anchor.getRow(), newRow);
        int minColumn = Math.min(anchor.getColumn(), focusedCell.getColumn());
        int maxColumn = Math.max(anchor.getColumn(), focusedCell.getColumn());
        sm.clearSelection();
        if (minColumn != -1 && maxColumn != -1) {
            sm.selectRange(minRow, (TableColumnBase)((TableView)this.getControl()).getVisibleLeafColumn(minColumn), maxRow, (TableColumnBase)((TableView)this.getControl()).getVisibleLeafColumn(maxColumn));
        }
        fm.focus(newRow, focusedCell.getTableColumn());
        this.skin.focusScroll();
    }

    private void discontinuousSelectHorizontal(boolean previous) {
        TableSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        TableFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (focusedCell == null || focusedCell.getTableColumn() == null) {
            return;
        }
        int columnPos = this.getVisibleLeafIndex(focusedCell.getTableColumn());
        int focusedCellRow = focusedCell.getRow();
        SpreadsheetCell cell = (SpreadsheetCell)focusedCell.getTableColumn().getCellData(focusedCell.getRow());
        int newColumn = previous ? this.findPreviousColumn(focusedCell, cell) : this.findNextColumn(focusedCell, cell);
        TablePositionBase anchor = this.getAnchor();
        int minRow = Math.min(anchor.getRow(), focusedCellRow);
        int maxRow = Math.max(anchor.getRow(), focusedCellRow);
        int minColumn = Math.min(anchor.getColumn(), newColumn);
        int maxColumn = Math.max(anchor.getColumn(), newColumn);
        sm.clearSelection();
        if (minColumn != -1 && maxColumn != -1) {
            sm.selectRange(minRow, (TableColumnBase)((TableView)this.getControl()).getVisibleLeafColumn(minColumn), maxRow, (TableColumnBase)((TableView)this.getControl()).getVisibleLeafColumn(maxColumn));
        }
        fm.focus(focusedCell.getRow(), this.getColumn(newColumn));
        this.skin.focusScroll();
    }

    private int findNextColumn(TablePositionBase focusedCell, SpreadsheetCell cell) {
        ObservableList items = ((TableView)this.getControl()).getItems();
        int itemCount = ((TableView)this.getControl()).getColumns().size();
        if (this.isEmpty(cell)) {
            for (int column = focusedCell.getColumn() + 1; column < itemCount; ++column) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(column);
                if (this.isEmpty(temp)) continue;
                return column;
            }
        } else if (focusedCell.getColumn() + 1 < itemCount && !this.isEmpty((SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(focusedCell.getColumn() + 1))) {
            for (int column = focusedCell.getColumn() + 2; column < itemCount; ++column) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(column);
                if (!this.isEmpty(temp)) continue;
                return column - 1;
            }
        } else {
            for (int column = focusedCell.getColumn() + 2; column < itemCount; ++column) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(column);
                if (this.isEmpty(temp)) continue;
                return column;
            }
        }
        return itemCount - 1;
    }

    private int findPreviousColumn(TablePositionBase focusedCell, SpreadsheetCell cell) {
        ObservableList items = ((TableView)this.getControl()).getItems();
        if (this.isEmpty(cell)) {
            for (int column = focusedCell.getColumn() - 1; column >= 0; --column) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(column);
                if (this.isEmpty(temp)) continue;
                return column;
            }
        } else if (focusedCell.getColumn() - 1 >= 0 && !this.isEmpty((SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(focusedCell.getColumn() - 1))) {
            for (int column = focusedCell.getColumn() - 2; column >= 0; --column) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(column);
                if (!this.isEmpty(temp)) continue;
                return column + 1;
            }
        } else {
            for (int column = focusedCell.getColumn() - 2; column >= 0; --column) {
                SpreadsheetCell temp = (SpreadsheetCell)((ObservableList)items.get(focusedCell.getRow())).get(column);
                if (this.isEmpty(temp)) continue;
                return column;
            }
        }
        return 0;
    }

    private boolean isEmpty(SpreadsheetCell cell) {
        return cell.getGraphic() == null && (cell.getItem() == null || cell.getItem() instanceof Double && ((Double)cell.getItem()).isNaN());
    }
}

