/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterContainer;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCountersFactory;
import java.util.Collection;

public abstract class AbstractPerformanceCounterModule
implements TelemetryModule {
    protected final PerformanceCountersFactory factory;

    protected AbstractPerformanceCounterModule(PerformanceCountersFactory factory) {
        this.factory = factory;
    }

    @Override
    public void initialize(TelemetryConfiguration configuration) {
        Collection<PerformanceCounter> performanceCounters = this.factory.getPerformanceCounters();
        for (PerformanceCounter performanceCounter : performanceCounters) {
            try {
                PerformanceCounterContainer.INSTANCE.register(performanceCounter);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                try {
                    InternalLogger.INSTANCE.error("Failed to register performance counter '%s': '%s'", performanceCounter.getId(), e.toString());
                    InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

