/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TransmissionOutput;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicy;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyStateFetcher;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ActiveTransmissionFileSystemOutput
implements TransmissionOutput {
    private static final AtomicInteger INSTANCE_ID_POOL = new AtomicInteger(1);
    private final ThreadPoolExecutor threadPool;
    private final TransmissionOutput actualOutput;
    private final TransmissionPolicyStateFetcher transmissionPolicy;
    private final int instanceId = INSTANCE_ID_POOL.getAndIncrement();

    public ActiveTransmissionFileSystemOutput(TransmissionOutput actualOutput, TransmissionPolicyStateFetcher transmissionPolicy) {
        Preconditions.checkNotNull(transmissionPolicy, "transmissionPolicy must be a non-null value");
        this.actualOutput = actualOutput;
        this.transmissionPolicy = transmissionPolicy;
        this.threadPool = ThreadPoolUtils.newLimitedThreadPool(1, 3, 20L, 1024);
        this.threadPool.setThreadFactory(ThreadPoolUtils.createDaemonThreadFactory(ActiveTransmissionFileSystemOutput.class, this.instanceId));
    }

    @Override
    public boolean send(final Transmission transmission) {
        try {
            if (this.transmissionPolicy.getCurrentState() == TransmissionPolicy.BLOCKED_AND_CANNOT_BE_PERSISTED) {
                return false;
            }
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveTransmissionFileSystemOutput.this.actualOutput.send(transmission);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        this.actualOutput.stop(timeout, timeUnit);
        ThreadPoolUtils.stop(this.threadPool, timeout, timeUnit);
    }
}

