/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.http.impl.conn;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.logging.Log;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.logging.LogFactory;
import com.microsoft.applicationinsights.core.dependencies.http.HttpException;
import com.microsoft.applicationinsights.core.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.HttpResponseFactory;
import com.microsoft.applicationinsights.core.dependencies.http.NoHttpResponseException;
import com.microsoft.applicationinsights.core.dependencies.http.ProtocolException;
import com.microsoft.applicationinsights.core.dependencies.http.StatusLine;
import com.microsoft.applicationinsights.core.dependencies.http.config.MessageConstraints;
import com.microsoft.applicationinsights.core.dependencies.http.impl.DefaultHttpResponseFactory;
import com.microsoft.applicationinsights.core.dependencies.http.impl.io.AbstractMessageParser;
import com.microsoft.applicationinsights.core.dependencies.http.io.SessionInputBuffer;
import com.microsoft.applicationinsights.core.dependencies.http.message.LineParser;
import com.microsoft.applicationinsights.core.dependencies.http.message.ParserCursor;
import com.microsoft.applicationinsights.core.dependencies.http.params.HttpParams;
import com.microsoft.applicationinsights.core.dependencies.http.util.Args;
import com.microsoft.applicationinsights.core.dependencies.http.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        Args.notNull(responseFactory, "Response factory");
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        int count = 0;
        ParserCursor cursor = null;
        while (true) {
            this.lineBuf.clear();
            int i = sessionBuffer.readLine(this.lineBuf);
            if (i == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            cursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
            if (i == -1 || this.reject(this.lineBuf, count)) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Garbage in response: " + this.lineBuf.toString());
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }

    protected boolean reject(CharArrayBuffer line, int count) {
        return false;
    }
}

